!     #########
      SUBROUTINE AVERAGE1_OROGRAPHY (USS, &
                                     KLUOUT,KNBLINES,PLAT,PLON,PVALUE,PNODATA)
!     #######################################################
!
!!**** *AVERAGE1_OROGRAPHY* computes the sum of orography, squared orography
!!                              and subgrid orography characteristics
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    V. Masson         Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    12/09/95
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_SURF_ATM_SSO_n, ONLY : SURF_ATM_SSO_t
!
USE MODD_PGDWORK,       ONLY : XSUMVAL, XSUMVAL2, NSIZE, XSSQO, LSSQO, NSSO
!
USE MODI_GET_MESH_INDEX
USE MODD_POINT_OVERLAY, ONLY : NOVMX
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(SURF_ATM_SSO_t), INTENT(INOUT) :: USS
!
INTEGER,                 INTENT(IN)    :: KLUOUT
INTEGER,                 INTENT(IN)    :: KNBLINES
REAL, DIMENSION(:),      INTENT(IN)    :: PLAT    ! latitude of the point to add
REAL, DIMENSION(:),      INTENT(IN)    :: PLON    ! longitude of the point to add
REAL, DIMENSION(:),      INTENT(IN)    :: PVALUE  ! value of the point to add
REAL, OPTIONAL, INTENT(IN) :: PNODATA
!
!*    0.2    Declaration of other local variables
!            ------------------------------------
!
INTEGER, DIMENSION(NOVMX,SIZE(PLAT)) :: IINDEX ! mesh index of all input points
                                         ! 0 indicates the point is out of the domain
INTEGER, DIMENSION(NOVMX,SIZE(PLAT)) :: ISSOX  ! X submesh index in their mesh of all input points
INTEGER, DIMENSION(NOVMX,SIZE(PLAT)) :: ISSOY  ! Y submesh index in their mesh of all input points
!
INTEGER :: JLOOP, JOVER        ! loop index on input arrays
REAL, DIMENSION(SIZE(PLAT)) :: ZVALUE
REAL :: ZNODATA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!----------------------------------------------------------------------------
!
!
!*    1.     Get position
!            ------------
!     
IF (LHOOK) CALL DR_HOOK('AVERAGE1_OROGRAPHY',0,ZHOOK_HANDLE)
!      
IF (PRESENT(PNODATA)) THEN
  ZVALUE(:) = PVALUE(:)
  ZNODATA = PNODATA
  CALL GET_MESH_INDEX(KLUOUT,KNBLINES,PLAT,PLON,IINDEX,ZVALUE,ZNODATA,NSSO,ISSOX,ISSOY)
ELSE
  ZVALUE(:) = 1.
  ZNODATA = 0.
  CALL GET_MESH_INDEX(KLUOUT,KNBLINES,PLAT,PLON,IINDEX,KSSO=NSSO,KISSOX=ISSOX,KISSOY=ISSOY)
ENDIF
!
!*    2.     Loop on all input data points
!            -----------------------------
!    
bloop: &
DO JLOOP = 1 , SIZE(PLAT)
!
  DO JOVER = 1, NOVMX
!
!*    3.     Tests on position
!            -----------------
!     
    IF (IINDEX(JOVER,JLOOP)==0) CYCLE bloop
!
!*    4.     Summation
!            ---------
!
    NSIZE(IINDEX(JOVER,JLOOP))=NSIZE(IINDEX(JOVER,JLOOP))+1
!
!*    5.     Orography
!            ---------
!
    XSUMVAL(IINDEX(JOVER,JLOOP))=XSUMVAL(IINDEX(JOVER,JLOOP))+PVALUE(JLOOP)
!
!*    6.     Square of Orography
!            -------------------
!
    XSUMVAL2(IINDEX(JOVER,JLOOP))=XSUMVAL2(IINDEX(JOVER,JLOOP))+PVALUE(JLOOP)**2
!
!*    7.     Maximum orography in a subgrid square
!            -------------------------------------
!
    LSSQO(ISSOX(JOVER,JLOOP),ISSOY(JOVER,JLOOP),IINDEX(JOVER,JLOOP)) = .TRUE.
    XSSQO(ISSOX(JOVER,JLOOP),ISSOY(JOVER,JLOOP),IINDEX(JOVER,JLOOP)) = &
         MAX (  XSSQO(ISSOX(JOVER,JLOOP),ISSOY(JOVER,JLOOP),IINDEX(JOVER,JLOOP)) , PVALUE(JLOOP) )   
!
!
!*    8.     Maximum orography in the mesh
!            -----------------------------
!
    USS%XMAX_ZS(IINDEX(JOVER,JLOOP))=MAX(USS%XMAX_ZS(IINDEX(JOVER,JLOOP)),PVALUE(JLOOP))
!
!
!*    9.     Minimum orography in the mesh
!            -----------------------------
!
    USS%XMIN_ZS(IINDEX(JOVER,JLOOP))=MIN(USS%XMIN_ZS(IINDEX(JOVER,JLOOP)),PVALUE(JLOOP))
!
!
  END DO
!
ENDDO bloop
IF (LHOOK) CALL DR_HOOK('AVERAGE1_OROGRAPHY',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE AVERAGE1_OROGRAPHY
