!     #############################################################
      SUBROUTINE ALLOC_DIAG_SURF_ATM_n (DGU, U, &
                                        HPROGRAM,KSW)
!     #############################################################
!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    01/2006 : sea flux parameterization.
!!                  08/2009 : TIME_BUDGETC for all Tile
!       B. decharme 09/2012 : XQS_TILE not initialize
!       B. decharme 04/2013 : Add EVAP and SUBL diag
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_DATA_COVER_PAR, ONLY : NTILESFC
USE MODD_SURF_PAR,       ONLY : XUNDEF
                                

!
USE MODI_READ_SURF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
 CHARACTER(LEN=6),        INTENT(IN) :: HPROGRAM  ! program calling surf. schemes
INTEGER,                 INTENT(IN) :: KSW       ! number of short-wave spectral bands
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IVERSION
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!
! Initialization: Outputs to atmosphere over each tile:
!
IF (LHOOK) CALL DR_HOOK('ALLOC_DIAG_SURF_ATM_N',0,ZHOOK_HANDLE)
ALLOCATE(DGU%XRI_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XCD_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XCH_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XCE_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XRN_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XH_TILE      (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XLE_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XLEI_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XGFLUX_TILE  (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XEVAP_TILE   (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XSUBL_TILE   (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XT2M_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XTS_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XT2M_MIN_TILE(U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XT2M_MAX_TILE(U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XQ2M_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XHU2M_TILE   (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XHU2M_MIN_TILE(U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XHU2M_MAX_TILE(U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XZON10M_TILE (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XMER10M_TILE (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XQS_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XZ0_TILE     (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XZ0H_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XSWD_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XSWU_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XLWD_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XLWU_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XSWBD_TILE   (U%NSIZE_FULL,NTILESFC,KSW))
ALLOCATE(DGU%XSWBU_TILE   (U%NSIZE_FULL,NTILESFC,KSW))
ALLOCATE(DGU%XFMU_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XFMV_TILE    (U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XWIND10M_TILE(U%NSIZE_FULL,NTILESFC))
ALLOCATE(DGU%XWIND10M_MAX_TILE(U%NSIZE_FULL,NTILESFC))
!
DGU%XRI_TILE      = XUNDEF
DGU%XCD_TILE      = XUNDEF
DGU%XCH_TILE      = XUNDEF
DGU%XCE_TILE      = XUNDEF
DGU%XRN_TILE      = XUNDEF
DGU%XH_TILE       = XUNDEF
DGU%XLE_TILE      = XUNDEF
DGU%XLEI_TILE     = XUNDEF
DGU%XGFLUX_TILE   = XUNDEF
DGU%XEVAP_TILE    = XUNDEF
DGU%XSUBL_TILE    = XUNDEF
DGU%XT2M_TILE     = XUNDEF
DGU%XTS_TILE      = XUNDEF
DGU%XT2M_MIN_TILE = XUNDEF
DGU%XT2M_MAX_TILE = XUNDEF
DGU%XQ2M_TILE     = XUNDEF
DGU%XHU2M_TILE    = XUNDEF
DGU%XHU2M_MIN_TILE= XUNDEF
DGU%XHU2M_MAX_TILE= XUNDEF
DGU%XZON10M_TILE  = XUNDEF
DGU%XMER10M_TILE  = XUNDEF
DGU%XQS_TILE      = XUNDEF
DGU%XZ0_TILE      = XUNDEF
DGU%XZ0H_TILE     = XUNDEF
DGU%XSWD_TILE     = XUNDEF
DGU%XSWU_TILE     = XUNDEF
DGU%XLWD_TILE     = XUNDEF
DGU%XLWU_TILE     = XUNDEF
DGU%XSWBD_TILE    = XUNDEF
DGU%XSWBU_TILE    = XUNDEF
DGU%XFMU_TILE     = XUNDEF
DGU%XFMV_TILE     = XUNDEF
DGU%XWIND10M_TILE = XUNDEF
DGU%XWIND10M_MAX_TILE = XUNDEF
!
! Initialization: aggregated fields
!
ALLOCATE(DGU%XAVG_RI     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_CD     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_CH     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_CE     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_RN     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_H      (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_LE     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_LEI    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_GFLUX  (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_EVAP   (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_SUBL   (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_T2M    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_TS     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_T2M_MIN(U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_T2M_MAX(U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_Q2M    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_HU2M   (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_HU2M_MIN(U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_HU2M_MAX(U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_ZON10M (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_MER10M (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_SFCO2  (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_T2M_MIN_ZS    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_Q2M_MIN_ZS    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_HU2M_MIN_ZS   (U%NSIZE_FULL))
ALLOCATE(DGU%XPS                (U%NSIZE_FULL))
ALLOCATE(DGU%XRHOA              (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_QS     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_Z0     (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_Z0H    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_SWD    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_SWU    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_LWD    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_LWU    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_SWBD   (U%NSIZE_FULL,KSW))
ALLOCATE(DGU%XAVG_SWBU   (U%NSIZE_FULL,KSW))
ALLOCATE(DGU%XAVG_FMU    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_FMV    (U%NSIZE_FULL))
ALLOCATE(DGU%XSSO_FMU    (U%NSIZE_FULL))
ALLOCATE(DGU%XSSO_FMV    (U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_WIND10M(U%NSIZE_FULL))
ALLOCATE(DGU%XAVG_WIND10M_MAX(U%NSIZE_FULL))
!
ALLOCATE(DGU%XDIAG_UREF  (U%NSIZE_FULL))
ALLOCATE(DGU%XDIAG_ZREF  (U%NSIZE_FULL))
ALLOCATE(DGU%XDIAG_TRAD  (U%NSIZE_FULL))
ALLOCATE(DGU%XDIAG_EMIS  (U%NSIZE_FULL))
!
DGU%XAVG_RI      = XUNDEF
DGU%XAVG_CD      = XUNDEF
DGU%XAVG_CH      = XUNDEF
DGU%XAVG_CE      = XUNDEF
DGU%XAVG_RN      = XUNDEF
DGU%XAVG_H       = XUNDEF
DGU%XAVG_LE      = XUNDEF
DGU%XAVG_LEI     = XUNDEF
DGU%XAVG_GFLUX   = XUNDEF
DGU%XAVG_EVAP    = XUNDEF
DGU%XAVG_SUBL    = XUNDEF
DGU%XAVG_T2M     = XUNDEF
DGU%XAVG_TS      = XUNDEF
DGU%XAVG_T2M_MIN = XUNDEF
DGU%XAVG_T2M_MAX = XUNDEF
DGU%XAVG_Q2M     = XUNDEF
DGU%XAVG_HU2M    = XUNDEF
DGU%XAVG_HU2M_MIN= XUNDEF
DGU%XAVG_HU2M_MAX= XUNDEF
DGU%XAVG_ZON10M  = XUNDEF
DGU%XAVG_MER10M  = XUNDEF
DGU%XAVG_SFCO2   = XUNDEF
DGU%XAVG_T2M_MIN_ZS     = XUNDEF
DGU%XAVG_Q2M_MIN_ZS     = XUNDEF
DGU%XAVG_HU2M_MIN_ZS    = XUNDEF
DGU%XPS                 = XUNDEF
DGU%XRHOA               = XUNDEF
DGU%XAVG_QS      = XUNDEF
DGU%XAVG_Z0      = XUNDEF
DGU%XAVG_Z0H     = XUNDEF
DGU%XAVG_SWD     = XUNDEF
DGU%XAVG_SWU     = XUNDEF
DGU%XAVG_LWD     = XUNDEF
DGU%XAVG_LWU     = XUNDEF
DGU%XAVG_SWBD    = XUNDEF
DGU%XAVG_SWBU    = XUNDEF
DGU%XAVG_FMU     = XUNDEF
DGU%XAVG_FMV     = XUNDEF
DGU%XSSO_FMU     = XUNDEF
DGU%XSSO_FMV     = XUNDEF
DGU%XAVG_WIND10M = XUNDEF
DGU%XAVG_WIND10M_MAX = XUNDEF
!
DGU%XDIAG_UREF   = XUNDEF
DGU%XDIAG_ZREF   = XUNDEF
DGU%XDIAG_TRAD   = XUNDEF
DGU%XDIAG_EMIS   = XUNDEF
!
IF (DGU%LSURF_BUDGETC) THEN
!
  ALLOCATE(DGU%XRNC_TILE     (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XHC_TILE      (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XLEC_TILE     (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XLEIC_TILE    (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XGFLUXC_TILE  (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XEVAPC_TILE   (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XSUBLC_TILE   (U%NSIZE_FULL,NTILESFC))  
  ALLOCATE(DGU%XSWDC_TILE    (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XSWUC_TILE    (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XLWDC_TILE    (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XLWUC_TILE    (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XFMUC_TILE    (U%NSIZE_FULL,NTILESFC))
  ALLOCATE(DGU%XFMVC_TILE    (U%NSIZE_FULL,NTILESFC))
!
  DGU%XRNC_TILE      = XUNDEF
  DGU%XHC_TILE       = XUNDEF
  DGU%XLEC_TILE      = XUNDEF
  DGU%XLEIC_TILE     = XUNDEF
  DGU%XGFLUXC_TILE   = XUNDEF
  DGU%XEVAPC_TILE    = XUNDEF
  DGU%XSUBLC_TILE    = XUNDEF  
  DGU%XSWDC_TILE     = XUNDEF
  DGU%XSWUC_TILE     = XUNDEF
  DGU%XLWDC_TILE     = XUNDEF
  DGU%XLWUC_TILE     = XUNDEF
  DGU%XFMUC_TILE     = XUNDEF
  DGU%XFMVC_TILE     = XUNDEF
!
  ALLOCATE(DGU%XAVG_RNC     (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_HC      (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_LEC     (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_LEIC    (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_GFLUXC  (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_EVAPC   (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_SUBLC   (U%NSIZE_FULL))  
  ALLOCATE(DGU%XAVG_SWDC    (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_SWUC    (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_LWDC    (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_LWUC    (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_FMUC    (U%NSIZE_FULL))
  ALLOCATE(DGU%XAVG_FMVC    (U%NSIZE_FULL))
!
  YREC='BUDC'
  CALL READ_SURF(HPROGRAM,YREC,DGU%LREAD_BUDGETC,IRESP)
!
  IF (.NOT. DGU%LREAD_BUDGETC) THEN
      DGU%TIME_BUDGETC = U%TTIME
      DGU%XAVG_RNC    = 0.0
      DGU%XAVG_HC     = 0.0
      DGU%XAVG_LEC    = 0.0
      DGU%XAVG_LEIC   = 0.0
      DGU%XAVG_GFLUXC = 0.0
      DGU%XAVG_EVAPC  = 0.0
      DGU%XAVG_SUBLC  = 0.0      
      DGU%XAVG_SWDC   = 0.0
      DGU%XAVG_SWUC   = 0.0
      DGU%XAVG_LWDC   = 0.0
      DGU%XAVG_LWUC   = 0.0
      DGU%XAVG_FMUC   = 0.0
      DGU%XAVG_FMVC   = 0.0      
  ELSEIF (DGU%LREAD_BUDGETC.AND.DGU%LRESET_BUDGETC) THEN
      DGU%TIME_BUDGETC = U%TTIME
      DGU%XAVG_RNC    = 0.0
      DGU%XAVG_HC     = 0.0
      DGU%XAVG_LEC    = 0.0
      DGU%XAVG_LEIC   = 0.0
      DGU%XAVG_GFLUXC = 0.0
      DGU%XAVG_EVAPC  = 0.0
      DGU%XAVG_SUBLC  = 0.0      
      DGU%XAVG_SWDC   = 0.0
      DGU%XAVG_SWUC   = 0.0
      DGU%XAVG_LWDC   = 0.0
      DGU%XAVG_LWUC   = 0.0
      DGU%XAVG_FMUC   = 0.0
      DGU%XAVG_FMVC   = 0.0       
  ELSE
      YREC='TBUDC'
      CALL READ_SURF(HPROGRAM,YREC,DGU%TIME_BUDGETC,IRESP)
     YREC='RNC'
     CALL READ_SURF(HPROGRAM,YREC,DGU%XAVG_RNC,IRESP)
     YREC='HC'
     CALL READ_SURF(HPROGRAM,YREC,DGU%XAVG_HC ,IRESP)
     YREC='LEC'
     CALL READ_SURF(HPROGRAM,YREC,DGU%XAVG_LEC,IRESP)
     YREC='LEIC'
     CALL READ_SURF(HPROGRAM,YREC,DGU%XAVG_LEIC,IRESP)     
     YREC='GFLUXC'
     CALL READ_SURF(HPROGRAM,YREC,DGU%XAVG_GFLUXC ,IRESP)
     YREC='SWDC'
     CALL READ_SURF(HPROGRAM,YREC,DGU%XAVG_SWDC,IRESP)
     YREC='SWUC'
     CALL READ_SURF(HPROGRAM,YREC,DGU%XAVG_SWUC,IRESP)
     YREC='LWDC'
     CALL READ_SURF(HPROGRAM,YREC,DGU%XAVG_LWDC,IRESP)
     YREC='LWUC'
     CALL READ_SURF( &
                 HPROGRAM,YREC,DGU%XAVG_LWUC,IRESP)
     YREC='FMUC'
     CALL READ_SURF(&
                 HPROGRAM,YREC,DGU%XAVG_FMUC,IRESP)
     YREC='FMVC'
     CALL READ_SURF(&
                 HPROGRAM,YREC,DGU%XAVG_FMVC,IRESP)   
!
     CALL READ_SURF(&
                 HPROGRAM,'VERSION',IVERSION,IRESP)
      IF (IVERSION<8)THEN
         DGU%XAVG_EVAPC  = 0.0
         DGU%XAVG_SUBLC  = 0.0              
      ELSE
         YREC='EVAPC'
         CALL READ_SURF(&
                 HPROGRAM,YREC,DGU%XAVG_EVAPC,IRESP)
         YREC='SUBLC'
         CALL READ_SURF(&
                 HPROGRAM,YREC,DGU%XAVG_SUBLC,IRESP)              
      ENDIF
!     
  ENDIF
!
ELSE
!
  ALLOCATE(DGU%XRNC_TILE     (0,0))
  ALLOCATE(DGU%XHC_TILE      (0,0))
  ALLOCATE(DGU%XLEC_TILE     (0,0))
  ALLOCATE(DGU%XLEIC_TILE    (0,0))
  ALLOCATE(DGU%XGFLUXC_TILE  (0,0))
  ALLOCATE(DGU%XEVAPC_TILE   (0,0))
  ALLOCATE(DGU%XSUBLC_TILE   (0,0))  
  ALLOCATE(DGU%XSWDC_TILE    (0,0))
  ALLOCATE(DGU%XSWUC_TILE    (0,0))
  ALLOCATE(DGU%XLWDC_TILE    (0,0))
  ALLOCATE(DGU%XLWUC_TILE    (0,0))
  ALLOCATE(DGU%XFMUC_TILE    (0,0))
  ALLOCATE(DGU%XFMVC_TILE    (0,0))
!
  ALLOCATE(DGU%XAVG_RNC     (0))
  ALLOCATE(DGU%XAVG_HC      (0))
  ALLOCATE(DGU%XAVG_LEC     (0))
  ALLOCATE(DGU%XAVG_LEIC    (0))
  ALLOCATE(DGU%XAVG_GFLUXC  (0))
  ALLOCATE(DGU%XAVG_EVAPC   (0))
  ALLOCATE(DGU%XAVG_SUBLC   (0))
  ALLOCATE(DGU%XAVG_SWDC    (0))
  ALLOCATE(DGU%XAVG_SWUC    (0))
  ALLOCATE(DGU%XAVG_LWDC    (0))
  ALLOCATE(DGU%XAVG_LWUC    (0))
  ALLOCATE(DGU%XAVG_FMUC    (0))
  ALLOCATE(DGU%XAVG_FMVC    (0))
!
ENDIF
IF (LHOOK) CALL DR_HOOK('ALLOC_DIAG_SURF_ATM_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE ALLOC_DIAG_SURF_ATM_n
