module methane_output

  use methane_parameters, only: dp,n_flux_parts, &
    mdiff,mplant,mebuair,mebutot,mprod      ,moxi, &
    cdiff,cplant,cebuair,cebutot,cprod,cresp,coxi, &
    odiff,oplant,oebuair,oebutot,oprod,oresp,ooxi
  use methane_geometry, only: geometry
  implicit none

  private
  public R_output

contains

  subroutine R_output(time,dt,nz,geom,por,methaneP,co2P,oxygenP, &
      gases_out_rates, ch4_wtd_flux, oxygen_wtd_flux, co2_wtd_flux)

    real(dp), intent(in)       :: time,dt,por
    integer, intent(in)        :: nz
    type(geometry), intent(in) :: geom
    real(dp), intent(in)       :: methaneP(nz),co2P(nz),oxygenP(nz), &
                                  gases_out_rates(n_flux_parts), &
                                  ch4_wtd_flux, oxygen_wtd_flux, co2_wtd_flux
    logical, save              :: first_call = .true.
    real(dp), parameter        :: day = 24._dp*3600._dp
    integer                    :: i

    if (first_call) then
      first_call = .false.
      open(11,file='output_methane_water.txt',action='WRITE',status='REPLACE')
      open(12,file='output_methane_air.txt',action='WRITE',status='REPLACE')
      open(13,file='output_co2_water.txt',action='WRITE',status='REPLACE')
      open(14,file='output_co2_air.txt',action='WRITE',status='REPLACE')
      open(15,file='output_oxygen_water.txt',action='WRITE',status='REPLACE')
      open(16,file='output_oxygen_air.txt',action='WRITE',status='REPLACE')

      write(11,*) '  t        y        w        conc'
      write(12,*) '  t        y        w        conc'
      write(13,*) '  t        y        w        conc'
      write(14,*) '  t        y        w        conc'
      write(15,*) '  t        y        w        conc'
      write(16,*) '  t        y        w        conc'



      open(20,file='output_processes.txt',action='WRITE',status='REPLACE')
      write(20,*) '  t CH4diff CH4plant CH4ebu CH4ebutot CH4respao CH4oxi&
                  & CO2diff CO2plant CO2ebu CO2ebutot CO2respao CO2respox CO2metoxi& 
                  & O2diff O2plant O2ebu O2ebutot O2respao O2respox O2oxi'
      open(21,file='output_fluxes.txt',action='WRITE',status='REPLACE')
      write(21,*) '  t CH4diff CH4plant CH4ebu CH4ebutot& 
                  & CO2diff CO2plant CO2ebu CO2ebutot& 
                  & O2diff O2plant O2ebu O2ebutot&
                  & CH4wtdflx CO2wtdflx O2wtdflx'

      open(22,file='output_processes.txt.readme',action='WRITE',status='REPLACE')
      write(22,*) 'time is in days since 2005-01-01'
      write(22,*) 'output is once per day'
      write(22,*) 'rates are in [mol s-1]'
      write(22,*) 'contains all processes'
      write(22,*) 'positive=influx or production, negative=outflux or consumption'

      open(23,file='output_fluxes.txt.readme',action='WRITE',status='REPLACE')
      write(23,*) 'time is in days since 2005-01-01'
      write(23,*) 'output is once per day'
      write(23,*) 'rates are in [mol s-1]'
      write(23,*) 'contains only fluxes'
      write(23,*) 'positive=source, negative=sink'
  

    end if

    if (geom%waterQ) then
      do i = geom%w2, geom%w1, -1
        write(11,*) &
          time/day,geom%dzP(i),dt/day,methaneP(i)/(por*geom%dzP(i))
        write(13,*) &
          time/day,geom%dzP(i),dt/day,co2P(i)/(por*geom%dzP(i))
        write(15,*) &
          time/day,geom%dzP(i),dt/day,oxygenP(i)/(por*geom%dzP(i))
      end do
    end if
    if (geom%SurfaceQ) then
      do i = geom%s2, geom%s1, -1
        write(11,*) &
          time/day,geom%dzP(i),dt/day,methaneP(i)/(geom%dzP(i))
        write(13,*) &
          time/day,geom%dzP(i),dt/day,co2P(i)/(geom%dzP(i))
        write(15,*) &
          time/day,geom%dzP(i),dt/day,oxygenP(i)/(geom%dzP(i))
      end do
    end if
    if (geom%airQ) then
      do i = geom%a1, geom%a2
        write(12,*) &
          time/day,-geom%dzP(i),dt/day,methaneP(i)/(por*geom%dzP(i))
        write(14,*) &
          time/day,-geom%dzP(i),dt/day,co2P(i)/(por*geom%dzP(i))
        write(16,*) &
          time/day,-geom%dzP(i),dt/day,oxygenP(i)/(por*geom%dzP(i))
      end do
    end if


    write(20,*) time/day, gases_out_rates
    write(21,*) time/day, &
         ! methane fluxes
         -gases_out_rates(mdiff),-gases_out_rates(mplant), &
         -gases_out_rates(mebuair),-gases_out_rates(mebutot), &
         ! co2 fluxes
         -gases_out_rates(cdiff),-gases_out_rates(cplant), &
         -gases_out_rates(cebuair),-gases_out_rates(cebutot), &
         ! oxygen fluxes
         -gases_out_rates(odiff),-gases_out_rates(oplant), &
         -gases_out_rates(oebuair),-gases_out_rates(oebutot), &
        ! wtd change fluxes 
         ch4_wtd_flux/day, co2_wtd_flux/day, &
         oxygen_wtd_flux/day

  end subroutine R_output

end module methane_output
