%CLM-CASA' model
function Data = datainputCarbon3
%DATAINPUT_CARBON3 Summary of this function goes here
%   Detailed explanation goes here
   % Data.xlow =[0 0 0.1541 0.001 0.3 0 0.3214 0 0 0 0.0001 1.5238 0.0065 0 0.0140 0.0004 0.35 0.5442 0 0.0010];
    %Data.xup =[0.0408 0.0106 0.5 0.002 0.5150 0.1 0.75 1 0.03 0.03 0.0008 2.0281 0.7 0.3260 0.9 0.9 1.1692 0.7 0.7 1.0001];
    Data.xlow = zeros(1,20) ;
    Data.xup = ones(1,20) ;
    Data.integer=[]; %indices of integer variables
    Data.continuous=(1:20); %indices of continuous variables
    Data.dim = 20; %problem dimension
    Data.data = load('carbon3data') ;
    Data.objfunction = @(x)clmCarbon(Data.data,x) ;
    Data.evaluate = @(flag,x)evaluate(Data.data,flag,x) ;
end

function J_new = clmCarbon(obj, pars)
    xlow =[0 0 0.1541 0.001 0.3 0 0.3214 0 0 0 0.0001 1.5238 0.0065 0 0.0140 0.0004 0.35 0.5442 0 0.0010];
    xup =[0.0408 0.0106 0.5 0.002 0.5150 0.1 0.75 1 0.03 0.03 0.0008 2.0281 0.7 0.3260 0.9 0.9 1.1692 0.7 0.7 1.0001];

    paras = pars.*(xup-xlow)+xlow ;
    e=paras(1);
    f=paras(2);
    cslow=paras(3);
    cpassive=paras(4);
    g=paras(5);
    h=paras(6);
    i=paras(7);
    j=paras(8);
    k=paras(9);
    l=paras(10);
    n=paras(11);
    Q10=paras(12);
    m=paras(13);
    o=paras(14);
    p=paras(15);
    q=paras(16);
    r=paras(17);
    s=paras(18);
    v=paras(19);
    w=paras(20);

    bgtemp=Q10.^((obj.tsoil-30)./10);
    bgmoist=0.25+0.75*obj.wlim;
    a1211=e*obj.clay+f;
    a1011=g-(e*obj.clay);
    a1110=  i-k*obj.clay+j*obj.sand-h*obj.clay.*obj.sand;
    a1210=n+ k*obj.clay+l*obj.sand-h*obj.clay.*obj.sand;

    a95=r-m*obj.structurallignin;
    a115=o*(obj.structurallignin);
    a107=s-p*obj.structurallignin;
    a117=q*(obj.structurallignin);
    a82=1.0;
    a63=v*(obj.solublefract);
    a73=1-(v*(obj.solublefract));
    a41=w*obj.solublefract;
    a51=1-a41;
    leaf=obj.b1.*obj.NPP./(obj.cleaf+obj.ksil);
    wood=obj.b2.*obj.NPP./(obj.cwood);
    root=obj.b3.*obj.NPP./obj.croot;
    surfmet= a41.*leaf.*(obj.cleaf)./((obj.csurfmet).*(bgmoist).*(((bgtemp))));
    surfstr=(a51.*leaf.*(obj.cleaf+obj.ksil))./(obj.csurfstr.*(bgmoist).*(((bgtemp))));
    soilmet=(a63.*root.*obj.croot)./(obj.csoilmet.*(bgmoist).*(((bgtemp))));
    soilstr=(a73.*root.*obj.croot)./(obj.csoilstr.*(bgmoist).*(((bgtemp))));
    cwd=(a82.*wood.*obj.cwood)./(obj.ccwd.*(bgmoist).*(((bgtemp))));
    surfmic=(a95.*obj.csurfstr.*surfstr+0.24*obj.ccwd*cwd)./(obj.csurfmic);
    slow= ((-a115).*surfstr.*obj.csurfstr-a117.*soilstr.*obj.csoilstr-0.28*cwd*obj.ccwd-0.4*surfmic*obj.csurfmic-a1110.*(0.4*surfmet*obj.csurfmet+0.45*soilmet*obj.csoilmet+a107.*soilstr.*obj.csoilstr))./((a1110.*a1011-1.0)*cslow);
    soilmic= (0.4*surfmet.*obj.csurfmet+0.45*soilmet.*obj.csoilmet+a107.*soilstr.*obj.csoilstr+a1011.*slow*cslow)./(obj.csoilmic);
    passive=(a1210.*soilmic.*obj.csoilmic+a1211.*slow.*cslow)./(cpassive);
    SoilC=soilmic + slow + passive;

    output = reshape(SoilC,64*128,1);
    %use RMSE as metrics
    J_new = sqrt(nanmean((output-obj.obs).^2)) ;
    %use J in Sarah work
    %J_new=(nansum((((output-obj.obs).^2))./(2.*(0.6*obj.obs).^2)));
   % J_new = nansum(((output-obj.obs).^2)./(2.*nanvar(obj.obs))) ;
end

function res = evaluate(obj,flag,pars)
    xlow =[0 0 0.1541 0.001 0.3 0 0.3214 0 0 0 0.0001 1.5238 0.0065 0 0.0140 0.0004 0.35 0.5442 0 0.0010];
    xup =[0.0408 0.0106 0.5 0.002 0.5150 0.1 0.75 1 0.03 0.03 0.0008 2.0281 0.7 0.3260 0.9 0.9 1.1692 0.7 0.7 1.0001];

    paras = [0.00405 0.0135 0.2 0.0045 0.44865 0.02176 0.16949 0.67796 0.00544 0.00204 0.00051 2 0.4 0.7 0.45 0.7 0.4 0.45 0.2 1]'  ;
    for i=1:length(flag)
        paras(flag(i)) = xlow(flag(i)) + (xup(flag(i))-xlow(flag(i)))*pars(i) ;
    end
    e=paras(1);
    f=paras(2);
    cslow=paras(3);
    cpassive=paras(4);
    g=paras(5);
    h=paras(6);
    i=paras(7);
    j=paras(8);
    k=paras(9);
    l=paras(10);
    n=paras(11);
    Q10=paras(12);
    m=paras(13);
    o=paras(14);
    p=paras(15);
    q=paras(16);
    r=paras(17);
    s=paras(18);
    v=paras(19);
    w=paras(20);

    bgtemp=Q10.^((obj.tsoil-30)./10);
    bgmoist=0.25+0.75*obj.wlim;
    a1211=e*obj.clay+f;
    a1011=g-(e*obj.clay);
    a1110=  i-k*obj.clay+j*obj.sand-h*obj.clay.*obj.sand;
    a1210=n+ k*obj.clay+l*obj.sand-h*obj.clay.*obj.sand;

    a95=r-m*obj.structurallignin;
    a115=o*(obj.structurallignin);
    a107=s-p*obj.structurallignin;
    a117=q*(obj.structurallignin);
    a82=1.0;
    a63=v*(obj.solublefract);
    a73=1-(v*(obj.solublefract));
    a41=w*obj.solublefract;
    a51=1-a41;
    leaf=obj.b1.*obj.NPP./(obj.cleaf+obj.ksil);
    wood=obj.b2.*obj.NPP./(obj.cwood);
    root=obj.b3.*obj.NPP./obj.croot;
    surfmet= a41.*leaf.*(obj.cleaf)./((obj.csurfmet).*(bgmoist).*(((bgtemp))));
    surfstr=(a51.*leaf.*(obj.cleaf+obj.ksil))./(obj.csurfstr.*(bgmoist).*(((bgtemp))));
    soilmet=(a63.*root.*obj.croot)./(obj.csoilmet.*(bgmoist).*(((bgtemp))));
    soilstr=(a73.*root.*obj.croot)./(obj.csoilstr.*(bgmoist).*(((bgtemp))));
    cwd=(a82.*wood.*obj.cwood)./(obj.ccwd.*(bgmoist).*(((bgtemp))));
    surfmic=(a95.*obj.csurfstr.*surfstr+0.24*obj.ccwd*cwd)./(obj.csurfmic);
    slow= ((-a115).*surfstr.*obj.csurfstr-a117.*soilstr.*obj.csoilstr-0.28*cwd*obj.ccwd-0.4*surfmic*obj.csurfmic-a1110.*(0.4*surfmet*obj.csurfmet+0.45*soilmet*obj.csoilmet+a107.*soilstr.*obj.csoilstr))./((a1110.*a1011-1.0)*cslow);
    soilmic= (0.4*surfmet.*obj.csurfmet+0.45*soilmet.*obj.csoilmet+a107.*soilstr.*obj.csoilstr+a1011.*slow*cslow)./(obj.csoilmic);
    passive=(a1210.*soilmic.*obj.csoilmic+a1211.*slow.*cslow)./(cpassive);
    SoilC=soilmic + slow + passive;

    output = reshape(SoilC,64*128,1);
    %return rmses and linear corr ;
    J_t = sqrt(nanmean((output-obj.obs).^2)) ;
    J_v = sqrt(nanmean((output-obj.obsv).^2)) ;
    covr = nancov(output,obj.obs) ;
    corr_t = covr(1,2)/sqrt(covr(1,1)*covr(2,2)) ;
    covr = nancov(output,obj.obsv) ;
    corr_v = covr(1,2)/sqrt(covr(1,1)*covr(2,2)) ;
    res = [J_t, corr_t, J_v, corr_v] ;
end