%4-pool microbial model 
%This is only for Surrogate Optimization, A little change on the interface.
function Data =datainputCarbon2
%DATAINPUT_CARBON2 Summary of this function goes here
%   Detailed explanation goes here
    %Data.xlow = [1,0.03,7, 0.05, 0.1, 0, 0.1, 50, 0, 400000, 0, -0.1, 30000, 30000, -0.1];
    %Data.xup = [6, 0.06, 10, 0.95, 1, 0.03, 1, 150, 20, 600000, 10000, 7, 55000, 55000, 6] ;
    Data.xlow = zeros(1,15) ;
    Data.xup = ones(1,15) ;
    Data.pname = {'rd','rEnzProd','rEnzLoss','rootDOC','aMic2SOC','CUEslope','Cue0','Kmup0',...
        'Kmupslope','Km0p','Kmslope','ligpar','Eaup','Ea','claypar'};
    Data.integer=[]; %indices of integer variables
    Data.continuous=(1:15); %indices of continuous variables
    Data.dim = 15; %problem dimension
    Data.data = load('carbon2data') ;
    Data.objfunction = @(x)micro4Pool(Data.data,x) ;
    Data.evaluate = @(flag,x)evaluate(Data.data,flag,x) ;
end 

function J_new = micro4Pool(data, paras)
%MICRO4POOL Summary of this function goes here
%   Detailed explanation goes here
    xlow = [1,0.03,7, 0.05, 0.1, 0, 0.1, 50, 0, 400000, 0, -0.1, 30000, 30000, -0.1];
    xup = [6, 0.06, 10, 0.95, 1, 0.03, 1, 150, 20, 600000, 10000, 7, 55000, 55000, 6] ;
    %par_new =[4.38 0.0438 8.76 0.3 0.5 0.016 0.63 100 10 500000 5000 0 47000 47000 0];
    par_new = paras.*(xup-xlow)+xlow ;
    rd=par_new(1);
    rEnzProd=par_new(2);
    rEnzLoss=par_new(3);
    rootDOC=par_new(4);
    MtoS=par_new(5);
    CUEslope=par_new(6);
    Cue0=par_new(7);
    Kmup0=par_new(8);
    Kmupslope=par_new(9);
    Km0p=par_new(10);
    Kmslope=par_new(11);
    ligpar=par_new(12);
    Eaup=par_new(13);
    Ea=par_new(14);
    claypar=par_new(15);
    %name = {'rd';'rEnzProd';'rEnzLoss';'rootDOC';'MtoS';'CUEslope';'Cue0';'Kmup0';'Kmupslope';'Km0p';'Kmslope';'ligpar';'Eaup';'Ea';'claypar'};

    Kmup=Kmupslope*data.tsoil+Kmup0;
    Km0=Km0p.*exp(ligpar*data.lignin);
    Km=Kmslope*data.tsoil+Km0;
    Vmaxup=data.Vmaxup0.*exp(-Eaup./(data.R.*(data.tsoil+273)));
    Vmax=data.Vmax0.*exp(-Ea./(data.R.*(data.tsoil+273))).*exp(-claypar*(data.clay));
    CUE=-CUEslope*data.tsoil+Cue0;

    iDOC=rootDOC.*data.SoilInflux;
    iSOC=(1-rootDOC).*data.SoilInflux;
% calculating equilibria soil pools with proposed parameters:
    MIC=CUE.*(iDOC+iSOC)./((1-CUE).*(rd+rEnzProd));
    ENZ=rEnzProd.*MIC./rEnzLoss;
    DOC=Kmup.*(iDOC+rd.*MIC+iSOC+rEnzProd.*MIC)./(Vmaxup.*MIC-iDOC-rd.*MIC-iSOC-rEnzProd.*MIC);
    SOC = Km .* (iSOC + rd .* MIC .* MtoS) ./ (Vmax .* ENZ - iSOC - rd .* MIC .* MtoS);

    modm=reshape(MIC,64*128,1);
    mod=reshape((SOC+DOC+MIC+ENZ),64*128,1);
    output = mod ;
    nanmean(nanmean(mod)) ;
    nanmean(nanmean(data.obs));
    %J_new=(1/(2*nanvar(data.obs)))*(nansum((mod-data.obs).^2))+(1/(2*nanvar(data.obs2)))*(nansum((modm-data.obs2).^2));
     J_new = sqrt(nanmean((mod-data.obs).^2))/2+sqrt(nanmean((modm-data.obs2).^2))/2 ;
end

function res = evaluate(data, flag, paras)
%MICRO4POOL Summary of this function goes here
%   Detailed explanation goes here
    xlow = [1,0.03,7, 0.05, 0.1, 0, 0.1, 50, 0, 400000, 0, -0.1, 30000, 30000, -0.1];
    xup = [6, 0.06, 10, 0.95, 1, 0.03, 1, 150, 20, 600000, 10000, 7, 55000, 55000, 6] ;
    par_new =[4.38 0.0438 8.76 0.3 0.5 0.016 0.63 100 10 500000 5000 0 47000 47000 0];
    for i=1:length(flag)
       par_new(flag(i)) = paras(i)*(xup(flag(i))-xlow(flag(i)))+xlow(flag(i)) ;
    end
    rd=par_new(1);
    rEnzProd=par_new(2);
    rEnzLoss=par_new(3);
    rootDOC=par_new(4);
    MtoS=par_new(5);
    CUEslope=par_new(6);
    Cue0=par_new(7);
    Kmup0=par_new(8);
    Kmupslope=par_new(9);
    Km0p=par_new(10);
    Kmslope=par_new(11);
    ligpar=par_new(12);
    Eaup=par_new(13);
    Ea=par_new(14);
    claypar=par_new(15);
    %name = {'rd';'rEnzProd';'rEnzLoss';'rootDOC';'MtoS';'CUEslope';'Cue0';'Kmup0';'Kmupslope';'Km0p';'Kmslope';'ligpar';'Eaup';'Ea';'claypar'};

    Kmup=Kmupslope*data.tsoil+Kmup0;
    Km0=Km0p.*exp(ligpar*data.lignin);
    Km=Kmslope*data.tsoil+Km0;
    Vmaxup=data.Vmaxup0.*exp(-Eaup./(data.R.*(data.tsoil+273)));
    Vmax=data.Vmax0.*exp(-Ea./(data.R.*(data.tsoil+273))).*exp(-claypar*(data.clay));
    CUE=-CUEslope*data.tsoil+Cue0;

    iDOC=rootDOC.*data.SoilInflux;
    iSOC=(1-rootDOC).*data.SoilInflux;
% calculating equilibria soil pools with proposed parameters:
    MIC=CUE.*(iDOC+iSOC)./((1-CUE).*(rd+rEnzProd));
    ENZ=rEnzProd.*MIC./rEnzLoss;
    DOC=Kmup.*(iDOC+rd.*MIC+iSOC+rEnzProd.*MIC)./(Vmaxup.*MIC-iDOC-rd.*MIC-iSOC-rEnzProd.*MIC);
    SOC = Km .* (iSOC + rd .* MIC .* MtoS) ./ (Vmax .* ENZ - iSOC - rd .* MIC .* MtoS);

    modm=reshape(MIC,64*128,1);
    mod=reshape((SOC+DOC+MIC+ENZ),64*128,1);

    %J_new=(1/(2*nanvar(data.obs)))*(nansum((mod-data.obs).^2))+(1/(2*nanvar(data.obs2)))*(nansum((modm-data.obs2).^2));
    J_t = sqrt(nanmean((mod-data.obs).^2)) ;
    J_v = sqrt(nanmean((mod-data.obsv).^2)) ;
    covr = nancov(mod,data.obs) ;
    corr_t = covr(1,2)/sqrt(covr(1,1)*covr(2,2)) ;
    covr = nancov(mod,data.obsv) ;
    corr_v = covr(1,2)/sqrt(covr(1,1)*covr(2,2)) ;
    res = [J_t, corr_t, J_v, corr_v] ;
end



