% this code was used to obtain the results for the 4 pool microbial model in Hararuk et al., Global Change Biology, 2014
% the structure of the code is as follows:
% 1. Load input data
% 2. Define initial model parameters
% 3. Calculate soil carbon and microbial biomass pools using the initial model parameters
% 4. Propose a new set of parameters using first uniform and then multivariate normal proposal distributions
% 5. Calculate soil carbon and microbial biomass pools using the proposed model parameters
% 6. Accept or reject the proposed parameters using the acceptance criterion 

clear all;
load dasas.mat;
load obsNPPsoilC.mat; 
load OptSoilInflux.mat 

for i=1:128
    for j=1:64
        if (tsoil(j,i)<0)
            tsoil(j,i)=0;
        end
         if(CobsUse(j,i)==0)
             CobsUse(j,i)=NaN;
         end
         if(CmicroUse(j,i)==0)
             CmicroUse(j,i)=NaN;
         end
    end
end


structurallignin=(lignin*0.65*2.22)./(1-solublefract); % structural lignin is the same as in Hararuk et al., JGR-Biogeosciences, 2014
%initial parameters calculated from Allison et al. Nature Geoscience,2010
R=8.314;
Kmup0=100;
Kmupslope=10;
rd=4.38;
rEnzProd=0.0438;
rEnzLoss=8.76;
MtoS=0.5;
Vmaxup0=876000000000;
Eaup=47000;
Cue0=0.63;
CUEslope=0.016;
Vmax0=876000000000;

% original parameters:
par=[4.38 0.0438 8.76 0.3 0.5 0.016 0.63 100 10 500000 5000 0 47000 47000 0]';
% parameter bounds:
Min=[1 0.03 7 0.05 0.1 0 0.1 50 0 400000 0 -0.1 30000 30000 -0.1]';
Max=[6 0.06 10 0.95 1 0.03 1 150 20 600000 10000 7 55000 55000 6]';

CUE=-CUEslope*tsoil+Cue0;
Kmup=Kmupslope*tsoil+Kmup0;
Km0=500000./exp(-0*lignin);
Kmslope=5000;
Q10km=exp((47000./R).*((1./(tsoil+273-5))-(1./(tsoil+273+5))));
Km=(Kmslope.*tsoil+Km0);
Ea=47000./exp(-0*(clay));
Vmaxup=Vmaxup0.*exp(-Eaup./(R.*(tsoil+273)));
Vmax=Vmax0.*exp(-Ea./(R.*(tsoil+273)));

iDOC=0.3*SoilInflux; %SoilInflux is carbon flux from litter to soil obtained in Hararuk et al., JGR-Biogeosciences,2014
iSOC=0.7*SoilInflux;

% calculating equilibria soil pools with original parameters:
MIC=CUE.*(iDOC+iSOC)./((1-CUE).*(rd+rEnzProd));
ENZ=rEnzProd.*MIC./rEnzLoss;
DOC=Kmup.*(iDOC+rd.*MIC+iSOC+rEnzProd.*MIC)./(Vmaxup.*MIC-iDOC-rd.*MIC-iSOC-rEnzProd.*MIC);
SOC = Km .* (iSOC + rd .* MIC .* MtoS) ./ (Vmax .* ENZ - iSOC - rd .* MIC .* MtoS);

SOC1=reshape(SOC+DOC+MIC+ENZ,64*128,1);
MIC1=MIC;

mod=SOC1;
modm=reshape(MIC,64*128,1);

obs=reshape(CobsUse,64*128,1);%portion of IGBP soil carbon used for calibration
obsv=reshape(CobsVal,128*64,1); % portion of IGBP soil carbon used for validation
obs2=reshape(CmicroUse,128*64,1); % portion of microbial biomass carbon from Xu et al., Global Ecology and Biogeography, 2013 used for calibration
obs2v=reshape(CmicroVal,128*64,1);% portion of microbial biomass carbon from Xu et al., Global Ecology and Biogeography, 2013 used for validation
 
% calculating cost function:
J_old=(1/(2*nanvar(obs)))*(nansum((mod-obs).^2))+(1/(2*nanvar(obs2)))*(nansum((modm-obs2).^2));

Parameters_keep= [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]';
nsimu=500000; % number of simulations                
keep_count=1;
upgrade=1;
allow=2; 
par_old=par;
diff=Max-Min;
sd=2.3./sqrt(20);

% beginning the data assimilation routine:
for simu=1:nsimu
    if simu>10000
        while (true)
            par_new = mvnrnd(par_old,Covs*sd); % choosing the new parameter set using multivariate normal proposal distributio
            if (par_new(1)>Min(1)&par_new(1)<Max(1)...
                &par_new(2)>Min(2)&par_new(2)<Max(2)...
                &par_new(3)>Min(3)&par_new(3)<Max(3)...
                &par_new(4)>Min(4)&par_new(4)<Max(4)...
                &par_new(5)>Min(5)&par_new(5)<Max(5)...
                &par_new(6)>Min(6)&par_new(6)<Max(6)...
                &par_new(7)>Min(7)&par_new(7)<Max(7)...
                &par_new(8)>Min(8)&par_new(8)<Max(8)...
                &par_new(9)>Min(9)&par_new(9)<Max(9)...
                &par_new(10)>Min(10)&par_new(10)<Max(10)...
                &par_new(11)>Min(11)&par_new(11)<Max(11)...
                &par_new(12)>Min(12)&par_new(12)<Max(12)...
                &par_new(13)>Min(13)&par_new(13)<Max(13)...
                &par_new(14)>Min(14)&par_new(14)<Max(14)...
                &par_new(15)>Min(15)&par_new(15)<Max(15))
                break;
            end
        end   
rd=par_new(1);
rEnzProd=par_new(2);
rEnzLoss=par_new(3);
rootDOC=par_new(4);
MtoS=par_new(5);
CUEslope=par_new(6);
Cue0=par_new(7);
Kmup0=par_new(8);
Kmupslope=par_new(9);
Km0p=par_new(10);
Kmslope=par_new(11);
ligpar=par_new(12);
Eaup=par_new(13);
Ea=par_new(14);
claypar=par_new(15);

Kmup=Kmupslope*tsoil+Kmup0;
Km0=Km0p.*exp(ligpar*lignin);
Km=Kmslope*tsoil+Km0;
Vmaxup=Vmaxup0.*exp(-Eaup./(R.*(tsoil+273)));
Vmax=Vmax0.*exp(-Ea./(R.*(tsoil+273))).*exp(-claypar*(clay));
CUE=-CUEslope*tsoil+Cue0;

iDOC=rootDOC.*SoilInflux;
iSOC=(1-rootDOC).*SoilInflux;
% calculating equilibria soil pools with proposed parameters:
MIC=CUE.*(iDOC+iSOC)./((1-CUE).*(rd+rEnzProd));
ENZ=rEnzProd.*MIC./rEnzLoss;
DOC=Kmup.*(iDOC+rd.*MIC+iSOC+rEnzProd.*MIC)./(Vmaxup.*MIC-iDOC-rd.*MIC-iSOC-rEnzProd.*MIC);
SOC = Km .* (iSOC + rd .* MIC .* MtoS) ./ (Vmax .* ENZ - iSOC - rd .* MIC .* MtoS);

modm=reshape(MIC,64*128,1);
mod=reshape((SOC+DOC+MIC+ENZ),64*128,1);

J_new=(1/(2*nanvar(obs)))*(nansum((mod-obs).^2))+(1/(2*nanvar(obs2)))*(nansum((modm-obs2).^2));

delta_J = J_new-J_old;
	if min(1,exp(-delta_J))>rand % parameter acceptance criterion
                 Parameters_keep(:,upgrade)=par_new; % accepted parameters
                 J_keep(upgrade)=J_new; % cost functions calculated with accepted parameters
                 upgrade=upgrade+1;
                 par_old=par_new; 
                 J_old = J_new ;
   	end
     Parameters_rec(:,simu)=par_old;        
     J_rec(:,simu)=J_old;                                     
        Covs=cov(Parameters_rec');
        
        else
		while (true)
        par_new = par_old+(rand(15,1)-0.5).*diff/allow;% choosing the new parameter set using uniform proposal distribution
   
            if (par_new(1)>Min(1)&par_new(1)<Max(1)...
            &par_new(2)>Min(2)&par_new(2)<Max(2)...
            &par_new(3)>Min(3)&par_new(3)<Max(3)...
            &par_new(4)>Min(4)&par_new(4)<Max(4)...
            &par_new(5)>Min(5)&par_new(5)<Max(5)...
            &par_new(6)>Min(6)&par_new(6)<Max(6)...
            &par_new(7)>Min(7)&par_new(7)<Max(7)...
            &par_new(8)>Min(8)&par_new(8)<Max(8)...
            &par_new(9)>Min(9)&par_new(9)<Max(9)...
            &par_new(10)>Min(10)&par_new(10)<Max(10)...
            &par_new(11)>Min(11)&par_new(11)<Max(11)...
            &par_new(12)>Min(12)&par_new(12)<Max(12)...
            &par_new(13)>Min(13)&par_new(13)<Max(13)...
            &par_new(14)>Min(14)&par_new(14)<Max(14)...
            &par_new(15)>Min(15)&par_new(15)<Max(15))

             break;
            end
       
         
        end
         
        
rd=par_new(1);
rEnzProd=par_new(2);
rEnzLoss=par_new(3);
rootDOC=par_new(4);
MtoS=par_new(5);
CUEslope=par_new(6);
Cue0=par_new(7);
Kmup0=par_new(8);
Kmupslope=par_new(9);
Km0p=par_new(10);
Kmslope=par_new(11);
ligpar=par_new(12);
Eaup=par_new(13);
Ea=par_new(14);
claypar=par_new(15);

Kmup=Kmupslope*tsoil+Kmup0;
Km0=Km0p.*exp(ligpar*lignin);
Km=Kmslope*tsoil+Km0;
Vmaxup=Vmaxup0.*exp(-Eaup./(R.*(tsoil+273)));
Vmax=Vmax0.*exp(-Ea./(R.*(tsoil+273))).*exp(-claypar*(clay));
CUE=-CUEslope*tsoil+Cue0;

iDOC=rootDOC.*SoilInflux;
iSOC=(1-rootDOC).*SoilInflux;

MIC=CUE.*(iDOC+iSOC)./((1-CUE).*(rd+rEnzProd));
ENZ=rEnzProd.*MIC./rEnzLoss;
DOC=Kmup.*(iDOC+rd.*MIC+iSOC+rEnzProd.*MIC)./(Vmaxup.*MIC-iDOC-rd.*MIC-iSOC-rEnzProd.*MIC);
SOC = Km .* (iSOC + rd .* MIC .* MtoS) ./ (Vmax .* ENZ - iSOC - rd .* MIC .* MtoS);


modm=reshape(MIC,64*128,1);
mod=reshape((SOC+DOC+MIC+ENZ),64*128,1);

J_new=(1/(2*nanvar(obs)))*(nansum((mod-obs).^2))+(1/(2*nanvar(obs2)))*(nansum((modm-obs2).^2));

delta_J = J_new-J_old;
	if min(1,exp(-delta_J))>rand % parameter acceptance criterion
                 Parameters_keep(:,upgrade)=par_new; % accepted parameters
                 J_keep(upgrade)=J_new; % cost functions calculated with accepted parameters
                 upgrade=upgrade+1 ;
                 par_old=par_new; 
                 J_old = J_new ;
   	end
 simu;
Parameters_rec(:,simu)=par_old;          
J_rec(:,simu)=J_old;                                    

Covs=cov(Parameters_rec');

end
end

% calculating maximum likelihood parameter values:
rd=mle(Parameters_keep(1,upgrade/3:(upgrade-1)),'distribution','gev');
rd=rd(3);

rEnzProd=mle(Parameters_keep(2,upgrade/3:(upgrade-1)),'distribution','gev');
rEnzProd=rEnzProd(3);

rEnzLoss=mle(Parameters_keep(3,upgrade/3:(upgrade-1)),'distribution','gev');
rEnzLoss=rEnzLoss(3);

rootDOC=mle(Parameters_keep(4,upgrade/3:(upgrade-1)),'distribution','gev');
rootDOC=rootDOC(3);

MtoS=mle(Parameters_keep(5,upgrade/3:(upgrade-1)),'distribution','gev');
MtoS=MtoS(3);

CUEslope=mle(Parameters_keep(6,upgrade/3:(upgrade-1)),'distribution','gev');
CUEslope=CUEslope(3);

Cue0=mle(Parameters_keep(7,upgrade/3:(upgrade-1)),'distribution','gev');
Cue0=Cue0(3);

Kmup0=mle(Parameters_keep(8,upgrade/3:(upgrade-1)),'distribution','gev');
Kmup0=Kmup0(3);

Kmupslope=mle(Parameters_keep(9,upgrade/3:(upgrade-1)),'distribution','gev');
Kmupslope=Kmupslope(3);

Km0p=mle(Parameters_keep(10,upgrade/3:(upgrade-1)),'distribution','gev');
Km0p=Km0p(3);

Kmslope=mle(Parameters_keep(11,upgrade/3:(upgrade-1)),'distribution','gev');
Kmslope=Kmslope(3);

ligpar=mle(Parameters_keep(12,upgrade/3:(upgrade-1)),'distribution','gev');
ligpar=ligpar(3);

Eaup=mle(Parameters_keep(13,upgrade/3:(upgrade-1)),'distribution','gev');
Eaup=Eaup(3);

Ea=mle(Parameters_keep(14,upgrade/3:(upgrade-1)),'distribution','gev');
Ea=Ea(3);

claypar=mle(Parameters_keep(15,upgrade/3:(upgrade-1)),'distribution','gev');
claypar=claypar(3);

mic4Paras = [rd,rEnzProd,rEnzLoss,rootDOC,MtoS,CUEslope,Cue0,Kmup0,Kmupslope,Km0p,...
    Kmslope,ligpar,Eaup,Ea,claypar] ;

% calculating calibrated soil pools:
Kmup=Kmupslope*tsoil+Kmup0;
Km0=Km0p.*exp(ligpar*lignin);
Km=Kmslope*tsoil+Km0;
Vmaxup=Vmaxup0.*exp(-Eaup./(R.*(tsoil+273)));
Vmax=Vmax0.*exp(-Ea./(R.*(tsoil+273))).*exp(-claypar*(clay));
CUE=-CUEslope*tsoil+Cue0;
iDOC=rootDOC.*SoilInflux;
iSOC=(1-rootDOC).*SoilInflux;

MIC=CUE.*(iDOC+iSOC)./((1-CUE).*(rd+rEnzProd));
ENZ=rEnzProd.*MIC./rEnzLoss;
DOC=Kmup.*(iDOC+rd.*MIC+iSOC+rEnzProd.*MIC)./(Vmaxup.*MIC-iDOC-rd.*MIC-iSOC-rEnzProd.*MIC);
SOC = Km .* (iSOC + rd .* MIC .* MtoS) ./ (Vmax .* ENZ - iSOC - rd .* MIC .* MtoS);


Final_Mic=reshape(MIC,64*128,1);
Final_SOC=reshape((SOC+DOC+MIC+ENZ),64*128,1);
