% this code was used to obtain the results for the 2 pool microbial model in Hararuk et al., Global Change Biology, 2014
% the structure of the code is as follows:
% 1. Load input data
% 2. Define initial model parameters
% 3. Calculate soil carbon and microbial biomass pools using the initial model parameters
% 4. Propose a new set of parameters using first uniform and then multivariate normal proposal distributions
% 5. Calculate soil carbon and microbial biomass pools using the proposed model parameters
% 6. Accept or reject the proposed parameters using the acceptance criterion 

clear all;
load dasas.mat;
load obsNPPsoilC.mat;
load OptSoilInflux.mat;

for i=1:128
    for j=1:64
        if (tsoil(j,i)<0)
            tsoil(j,i)=0;
        end
         if(CobsUse(j,i)==0)
             CobsUse(j,i)=NaN;
         end
         if(CmicroUse(j,i)==0)
             CmicroUse(j,i)=NaN;
         end
    end
end


structurallignin=(lignin*0.65*2.22)./(1-solublefract);% structural lignin is the same as in Hararuk et al., JGR-Biogeosciences, 2014
R=8.314;
rd=4.38;
Cue0=0.63;
CUEslope=-0.016;
Km0=500000./exp(-0*lignin);
Kmslope=5000;
Vmax0=876000000000;

% original parameters:
par=[4.38 0.016 0.63 500000 5000 0 47000 0]';
% parameter bounds:
Min=[1 0 0.1 400000 0 -0.1 30000 -0.1]';
Max=[6 0.03 1 600000 10000 7 55000 6]';

Ea=47000./exp(-0*(clay));
Vmax=Vmax0.*exp(-Ea./(R.*(tsoil+273)));
CUE=CUEslope*tsoil+Cue0;
Km=(Kmslope.*tsoil+Km0);

iSOC = (SoilInflux); %SoilInflux is carbon flux from litter to soil obtained in Hararuk et al., JGR-Biogeosciences,2014
% calculating equilibria soil pools with original parameters:
SOC=Km.*(rd)./(Vmax.*CUE-rd);
MIC=(iSOC)./(Vmax.*(SOC./(Km+SOC))-rd);

mod=reshape((SOC+MIC),64*128,1);
modm=reshape((MIC),64*128,1);
obs=reshape(CobsUse,64*128,1);%portion of IGBP soil carbon used for calibration
obsv=reshape(CobsVal,64*128,1);%portion of IGBP soil carbon used for validation
obs2=reshape(CmicroUse,64*128,1);% portion of microbial biomass carbon from Xu et al., Global Ecology and Biogeography, 2013 used for calibration
obs2v=reshape(CmicroVal,64*128,1);% portion of microbial biomass carbon from Xu et al., Global Ecology and Biogeography, 2013 used for validation
% calculating cost function:
J_old=(1/(2*nanvar(obs)))*(nansum((mod-obs).^2))+(1/(2*nanvar(obs2)))*(nansum((modm-obs2).^2));

Parameters_keep= [0 0 0 0 0 0 0 0]';
nsimu=100000;                   
keep_count=1;
upgrade=1;
allow=2;
par_old=par;
diff=Max-Min;
sd=2.3./sqrt(8);
% beginning the data assimilation routine:
for simu=1:nsimu
     if simu>10000
        while (true)
        par_new = mvnrnd(par_old,Covs*sd);% choosing the new parameter set using multivariate normal proposal distribution
        if (par_new(1)>Min(1)&par_new(1)<Max(1)...
            &par_new(2)>Min(2)&par_new(2)<Max(2)...
            &par_new(3)>Min(3)&par_new(3)<Max(3)...
            &par_new(4)>Min(4)&par_new(4)<Max(4)...
            &par_new(5)>Min(5)&par_new(5)<Max(5)...
            &par_new(6)>Min(6)&par_new(6)<Max(6)...
            &par_new(7)>Min(7)&par_new(7)<Max(7)...
            &par_new(8)>Min(8)&par_new(8)<Max(8))
             break;
            end
        end
rd=par_new(1);
CUEslope=par_new(2);
Cue0=par_new(3);
Km0p=par_new(4);
Kmslope=par_new(5);
ligpar=par_new(6);
Ea=par_new(7);
claypar=par_new(8);

CUE=-CUEslope*tsoil+Cue0;
Km0=Km0p./exp(-ligpar*lignin);%243-360000 - german
Km=(Kmslope.*tsoil+Km0);
Vmax=Vmax0.*exp(-Ea./(R.*(tsoil+273))).*exp(-claypar*(clay));
% calculating equilibria soil pools with proposed parameters:
SOC=Km.*(rd)./(Vmax.*CUE-rd);
MIC=(iSOC)./(Vmax.*(SOC./(Km+SOC))-rd);

mod=reshape(SOC+MIC,64*128,1);
modm=reshape(MIC,64*128,1);

J_new=(1/(2*nanvar(obs)))*(nansum((mod-obs).^2))+(1/(2*nanvar(obs2)))*(nansum((modm-obs2).^2));

delta_J = J_new-J_old;
	if min(1,exp(-delta_J))>rand  % parameter acceptance criterion
                 Parameters_keep(:,upgrade)=par_new; % accepted parameters
                 J_keep(upgrade)=J_new; % cost functions calculated with accepted parameters
                upgrade=upgrade+1 ;
                 par_old=par_new;
                 J_old=J_new;
   	end
	
     Parameters_rec(:,simu)=par_old;         
     J_rec(:,simu)=J_old;                                     
     Covs=cov(Parameters_rec');

     else
        
		while (true)
        par_new = par_old+(rand(8,1)-0.5).*diff/allow; % choosing the new parameter set using uniform proposal distribution
            if (par_new(1)>Min(1)&par_new(1)<Max(1)...
            &par_new(2)>Min(2)&par_new(2)<Max(2)...
            &par_new(3)>Min(3)&par_new(3)<Max(3)...
            &par_new(4)>Min(4)&par_new(4)<Max(4)...
            &par_new(5)>Min(5)&par_new(5)<Max(5)...
            &par_new(6)>Min(6)&par_new(6)<Max(6)...
            &par_new(7)>Min(7)&par_new(7)<Max(7)...
            &par_new(8)>Min(8)&par_new(8)<Max(8))
             break;
            end       
        end

rd=par_new(1);
CUEslope=par_new(2);
Cue0=par_new(3);
Km0p=par_new(4);
Kmslope=par_new(5);
ligpar=par_new(6);
Ea=par_new(7);
claypar=par_new(8);

CUE=-CUEslope*tsoil+Cue0;
Km0=Km0p./exp(-ligpar*lignin);
Km=(Kmslope.*tsoil+Km0);
Vmax=Vmax0.*exp(-Ea./(R.*(tsoil+273))).*exp(-claypar*(clay));

SOC=Km.*(rd)./(Vmax.*CUE-rd);
MIC=(iSOC)./(Vmax.*(SOC./(Km+SOC))-rd);

mod=reshape(SOC+MIC,64*128,1);
modm=reshape(MIC,64*128,1);
J_new=(1/(2*nanvar(obs)))*(nansum((mod-obs).^2))+(1/(2*nanvar(obs2)))*(nansum((modm-obs2).^2));


delta_J = J_new-J_old;
	if min(1,exp(-delta_J))>rand  % parameter acceptance criterion
                 Parameters_keep(:,upgrade)=par_new; % accepted parameters
                 J_keep(upgrade)=J_new; % cost functions calculated with accepted parameters
                upgrade=upgrade+1 ;
                 par_old=par_new;
                 J_old=J_new;
   	end

     Parameters_rec(:,simu)=par_old;          
     J_rec(:,simu)=J_old;                                     

Covs=cov(Parameters_rec');
     end
end

% calculating maximum likelihood parameter values:
% rd=mle(Parameters_keep(1,simu/2:(simu-1)),'distribution','gev');
% rd=rd(3);
% 
% CUEslope=mle(Parameters_keep(2,simu/2:(simu-1)),'distribution','gev');
% CUEslope=CUEslope(3);
% 
% Cue0=mle(Parameters_keep(3,simu/2:(simu-1)),'distribution','gev');
% Cue0=Cue0(3);
% 
% Km0p=mle(Parameters_keep(4,simu/2:(simu-1)),'distribution','gev');
% Km0p=Km0p(3);
% 
% Kmslope=mle(Parameters_keep(5,simu/2:(simu-1)),'distribution','gev');
% Kmslope=Kmslope(3);
% 
% ligpar=mle(Parameters_keep(6,simu/2:(simu-1)),'distribution','gev');
% ligpar=ligpar(3);
% 
% Ea=mle(Parameters_keep(7,simu/2:(simu-1)),'distribution','gev');
% Ea=Ea(3);
% 
% claypar=mle(Parameters_keep(8,simu/2:(simu-1)),'distribution','gev');
rd=mle(Parameters_keep(1,upgrade/3:(upgrade-1)),'distribution','gev');
rd=rd(3);

CUEslope=mle(Parameters_keep(2,upgrade/3:(upgrade-1)),'distribution','gev');
CUEslope=CUEslope(3);

Cue0=mle(Parameters_keep(3,upgrade/3:(upgrade-1)),'distribution','gev');
Cue0=Cue0(3);

Km0p=mle(Parameters_keep(4,upgrade/3:(upgrade-1)),'distribution','gev');
Km0p=Km0p(3);

Kmslope=mle(Parameters_keep(5,upgrade/3:(upgrade-1)),'distribution','gev');
Kmslope=Kmslope(3);

ligpar=mle(Parameters_keep(6,upgrade/3:(upgrade-1)),'distribution','gev');
ligpar=ligpar(3);

Ea=mle(Parameters_keep(7,upgrade/3:(upgrade-1)),'distribution','gev');
Ea=Ea(3);

claypar=mle(Parameters_keep(8,upgrade/3:(upgrade-1)),'distribution','gev');
claypar = claypar(3) ;

CUE=-CUEslope*tsoil+Cue0;
Km0=Km0p./exp(-ligpar*lignin);
Km=(Kmslope.*tsoil+Km0);
Vmax=Vmax0.*exp(-Ea./(R.*(tsoil+273))).*exp(-claypar*(clay));

% calculating calibrated soil pools:
SOC=Km.*(rd)./(Vmax.*CUE-rd);
MIC=(iSOC)./(Vmax.*(SOC./(Km+SOC))-rd);
Final_Mic=reshape(MIC,64*128,1);
Final_SOC=reshape((SOC+MIC),64*128,1);
