clear all;
%import data
load input.mat;


secpy=31536000.0;
NPP=NPP*secpy;
croot=croot*secpy;
cleaf=cleaf*secpy;
cwood=cwood*secpy;

% use half of the observed soil C for parameter estimation
obs=reshape(CobsUse,64*128,1);

%define initial parameter values, minima, and maxima
Min=[0 0 0.1 0.001 0.3 0 0.019 0 0 0 0.0001 1 0 0 0 0 0.35 0.4 0 0]';
Max=[0.7 0.02 0.5 0.005 0.7 0.1 0.75 1 0.03 0.03 0.0008 3 0.7 0.8 0.9 0.9 2.3 0.7 0.7 1.0001]';
par=[0.00405 0.0135 0.2 0.0045 0.44865 0.02176 0.16949 0.67796 0.00544 0.00204 0.00051 2 0.4 0.7 0.45 0.7 0.4 0.45 0.2 1]';

%define turnover rates and functions for partitioning coefficients and
%environmental limitation
lignineffect=exp(-3.*structurallignin);
csurfmet=14.8;
csurfstr=3.9*lignineffect;
csoilmet=18.5;
csoilstr=4.9*lignineffect;
ccwd=0.2424;
csurfmic=6;
csoilmic=7.3;
cslow=par(3);
cpassive=par(4);
 
 a82=1.0;
 a41=solublefract;
 a51=1-a41;
 a63=(solublefract);
 a73=1-((solublefract));
 a1211=0.0135+0.00405*clay;
 a1011=0.45*(1-(0.003+0.009*clay));
 a1110= (0.85-0.68*(1-sand)).*(0.997-0.032*clay); 
 a1210=(0.85-0.68*(1-sand)).*(0.003+0.032*clay);
 a95=0.4-0.4*structurallignin;
 a115=0.7*structurallignin;
 a107=0.45-0.45*structurallignin;
 a117=0.7*structurallignin;

 bgtemp=2.^(0.1.*(tsoil-30));
 bgmoist=0.25+0.75*wlim;
 
 %calculate equilibrium carbon pools

        leaf=b1.*NPP./(cleaf +ksil);
        wood=b2 .*NPP ./(cwood);
        root=b3 .*NPP ./(croot);
        surfmet= a41 .*leaf .*(cleaf )./((csurfmet).*(bgmoist).*(bgtemp));
        surfstr =(a51 .*leaf .*(cleaf +ksil ))./(csurfstr.*(bgmoist).*(bgtemp));
        soilmet =(a63 .*root .*croot )./(csoilmet.*(bgmoist).*(bgtemp));
        soilstr =(a73 .*root .*croot )./(csoilstr.*(bgmoist).*(bgtemp));
        cwd =(a82.*wood .*cwood )./(ccwd.*(bgmoist).*(bgtemp));
        surfmic =(a95 .*csurfstr.*surfstr +0.24.*ccwd.*cwd )./(csurfmic);
        slow = ((-a115 ).*surfstr .*csurfstr-a117 .*soilstr .*csoilstr-0.28.*cwd .*ccwd-0.4.*surfmic .*csurfmic-a1110 .*(0.4.*surfmet .*csurfmet+0.45.*soilmet .*csoilmet+a107 .*soilstr .*csoilstr))./((a1110 .*a1011-1.0).*cslow);
        soilmic = (0.4.*surfmet .*csurfmet+0.45.*soilmet .*csoilmet+a107 .*soilstr .*csoilstr+a1011.*slow .*cslow)./(csoilmic);
        passive =(a1210 .*soilmic .*csoilmic+a1211 .*slow .*cslow)./(cpassive);
        SoilC =soilmic  + slow  + passive ;
        SoilCfirst=SoilC;
       
mod=reshape(SoilC,64*128,1);

%begin data assimilation
 
MCMC1

% calculate maximum likelihood values for parameters
e1=mle(Parameters_keep(1,upgrade/3:(upgrade-1)),'distribution','gev');
e=e1(3);
f1=mle(Parameters_keep(2,upgrade/3:(upgrade-1)),'distribution','gev');
f=f1(3);
cslow1=mle(Parameters_keep(3,upgrade/3:(upgrade-1)),'distribution','gev');
cslow=cslow1(3);
cpassive1=mle(Parameters_keep(4,upgrade/3:(upgrade-1)),'distribution','gev');
cpassive=cpassive1(3);
g1=mle(Parameters_keep(5,upgrade/3:(upgrade-1)),'distribution','gev');
g=g1(3);
h1=mle(Parameters_keep(6,upgrade/3:(upgrade-1)),'distribution','gev');
h=h1(3);
i1=mle(Parameters_keep(7,upgrade/3:(upgrade-1)),'distribution','gev');
i=i1(3);
j1=mle(Parameters_keep(8,upgrade/3:(upgrade-1)),'distribution','gev');
j=j1(3);
k1=mle(Parameters_keep(9,upgrade/3:(upgrade-1)),'distribution','gev');
k=k1(3);
l1=mle(Parameters_keep(10,upgrade/3:(upgrade-1)),'distribution','gev');
l=l1(3);
n1=mle(Parameters_keep(11,upgrade/3:(upgrade-1)),'distribution','gev');
n=n1(3);
Q101=mle(Parameters_keep(12,upgrade/3:(upgrade-1)),'distribution','gev');
Q10=Q101(3);
m1=mle(Parameters_keep(13,upgrade/3:(upgrade-1)),'distribution','gev');
m=m1(3);
o1=mle(Parameters_keep(14,upgrade/3:(upgrade-1)),'distribution','gev');
o=o1(3);
p1=mle(Parameters_keep(15,upgrade/3:(upgrade-1)),'distribution','gev');
p=p1(3);
q1=mle(Parameters_keep(16,upgrade/3:(upgrade-1)),'distribution','gev');
q=q1(3);
r1=mle(Parameters_keep(17,upgrade/3:(upgrade-1)),'distribution','gev');
r=r1(3);
s1=mle(Parameters_keep(18,upgrade/3:(upgrade-1)),'distribution','gev');
s=s1(3);
v1=mle(Parameters_keep(19,upgrade/3:(upgrade-1)),'distribution','gev');
v=v1(3);
w1=mle(Parameters_keep(20,upgrade/3:(upgrade-1)),'distribution','gev');
w=w1(3);

cm3Paras = [e,f,cslow,cpassive,g,h,i,j,k,l,n,Q10,m,o,p,q,r,s,v,w] ;

%calculate maximum likelihood turnover rates, environmental limitation, and
%partitioning coefficients
bgtemp=Q10.^((tsoil-30)./10);

a1211=e*clay+f;
 a1011=g-(e*clay);
 a1110=  i-k*clay+j*sand-h*clay.*sand;
 a1210=n+ k*clay+l*sand-h*clay.*sand;
 
 a95=r-m*(structurallignin);
 a115=o*(structurallignin);
 a107=s-p*structurallignin;
 a117=q*structurallignin;
 
 a63=v*(solublefract);
 a73=1-(v*(solublefract));
 a41=w*solublefract;
 a51=1-a41;
 
 %calculate maximum likelihood equilibrium carbon pools
 
        leaf=b1.*NPP./(cleaf+ksil);
        wood=(b2).*NPP./(cwood);
        root=b3.*NPP./croot;
        surfmet= a41.*leaf.*(cleaf)./((csurfmet).*(bgmoist).*(((bgtemp))));
        surfstr=(a51.*leaf.*(cleaf+ksil))./(csurfstr.*(bgmoist).*(((bgtemp))));
        soilmet=(a63.*root.*croot)./(csoilmet.*(bgmoist).*(((bgtemp))));
        soilstr=(a73.*root.*croot)./(csoilstr.*(bgmoist).*(((bgtemp))));
        cwd=(a82.*wood.*cwood)./(ccwd.*(bgmoist).*(((bgtemp))));
        surfmic=(a95.*csurfstr.*surfstr+0.24*ccwd*cwd)./(csurfmic);
        slow= ((-a115).*surfstr.*csurfstr-a117.*soilstr.*csoilstr-0.28*cwd*ccwd-0.4*surfmic*csurfmic-a1110.*(0.4*surfmet*csurfmet+0.45*soilmet*csoilmet+a107.*soilstr.*csoilstr))./((a1110.*a1011-1.0)*cslow);
        soilmic= (0.4*surfmet.*csurfmet+0.45*soilmet.*csoilmet+a107.*soilstr.*csoilstr+a1011.*slow*cslow)./(csoilmic);
        passive=(a1210.*soilmic.*csoilmic+a1211.*slow.*cslow)./(cpassive);
        SoilC=soilmic + slow + passive;
        
       
        
    modf=reshape(SoilC,64*128,1);
    obsv=reshape(CobsVal,64*128,1); %using the other half of soil C observations for performance evaluation

%create plots
%histograms 

