%The example script for running global optimization algorithms

%datainputCarbon1 : 2-pool microbial model
%datainputCarbon2 : 4-pool microbial model
%datainputCarbon3 : clm-casa' model

%The model class instance 
cmodel = datainput_Carbon3;
%define the max model run times
max_funevals = 500 ;
%The flag define the parameters you want to calibrate.
%e.g. If the flag is [1,3,5], The algorithm will only calibrate the 1st,
%3rd and 5th parameters and return the results of these three parameters,
%other parameters are default value. If you want to calibrate all
%parameters, flag is 1:dim
flag = 1:cmodel.dim ;

%run
[xbest, fbest, histf, histx] = PSO(cmodel,max_funevals,flag) ;
%The algorithm function return 4 vairables
%xbest: The parameter values with the lowest RMSE
%fbest: The lowest RMSE value
%histf: The RMSE of all sampled points
%histx: All sampled points

%The detail of the optimization is stored into Results.mat
load('Results.mat');