%2-pool microbial model for global optimization
function Data = datainput_Carbon1
%DATAINPUT_CARBON1 Summary of this function goes here
%   Detailed explanation goes here
    Data.xlow=[1, 0, 0.1, 400000, 0, -0.1, 30000, -0.1]; %variable lower bounds
    Data.xup=[6, 0.03, 1, 600000, 10000, 7, 55000, 6]; %variable upper bounds
    Data.integer=[]; %indices of integer variables
    Data.continuous=(1:8); %indices of continuous variables
    Data.dim = 8; %problem dimension
    Data.data = load('carbon1data') ;
    Data.objfunction = @(flag,x)micro2Pool(Data.data,flag,x) ;
    Data.evaluate = @(flag,x)evaluate(Data.data,flag,x) ;
end

function J_new = micro2Pool(data, flag, paras)
%MICRO2POOL Summary of this function goes here
%   Detailed explanation goes here
    xlow=[1, 0, 0.1, 400000, 0, -0.1, 30000, -0.1]; %variable lower bounds
    xup=[6, 0.03, 1, 600000, 10000, 7, 55000, 6]; %variable upper bounds
    par_new = [4.38 0.016 0.63 500000 5000 0 47000 0] ;
    for i=1:length(flag)
       par_new(flag(i)) = paras(i)*(xup(flag(i))-xlow(flag(i)))+xlow(flag(i)) ;
    end
    rd=par_new(1);
    CUEslope=par_new(2);
    Cue0=par_new(3);
    Km0p=par_new(4);
    Kmslope=par_new(5);
    ligpar=par_new(6);
    Ea=par_new(7);
    claypar=par_new(8);
    
    CUE=-CUEslope*data.tsoil+Cue0;
    Km0=Km0p./exp(-ligpar*data.lignin);%243-360000 - german
    Km=(Kmslope.*data.tsoil+Km0);
    Vmax=data.Vmax0.*exp(-Ea./(data.R.*(data.tsoil+273))).*exp(-claypar*(data.clay));
% calculating equilibria soil pools with proposed parameters:
    SOC=Km.*(rd)./(Vmax.*CUE-rd);
    MIC=(data.iSOC)./(Vmax.*(SOC./(Km+SOC))-rd);

    mod=reshape(SOC+MIC,64*128,1);
    modm=reshape(MIC,64*128,1);

    %J_new=(1/(2*nanvar(data.obs)))*(nansum((mod-data.obs).^2))+(1/(2*nanvar(data.obs2)))*(nansum((modm-data.obs2).^2));
    J_new = sqrt(nanmean((mod-data.obs).^2))/2+sqrt(nanmean((modm-data.obs2).^2))/2 ;
    %J_new = sqrt(nanmean((mod-data.obs).^2)
end

function res = evaluate(data, flag, paras)
%MICRO2POOL Summary of this function goes here
%   Detailed explanation goes here
    xlow=[1, 0, 0.1, 400000, 0, -0.1, 30000, -0.1]; %variable lower bounds
    xup=[6, 0.03, 1, 600000, 10000, 7, 55000, 6]; %variable upper bounds
    par_new = [4.38 0.016 0.63 500000 5000 0 47000 0] ;
    for i=1:length(flag)
       par_new(flag(i)) = paras(i)*(xup(flag(i))-xlow(flag(i)))+xlow(flag(i)) ;
    end
    rd=par_new(1);
    CUEslope=par_new(2);
    Cue0=par_new(3);
    Km0p=par_new(4);
    Kmslope=par_new(5);
    ligpar=par_new(6);
    Ea=par_new(7);
    claypar=par_new(8);
    
    CUE=-CUEslope*data.tsoil+Cue0;
    Km0=Km0p./exp(-ligpar*data.lignin);%243-360000 - german
    Km=(Kmslope.*data.tsoil+Km0);
    Vmax=data.Vmax0.*exp(-Ea./(data.R.*(data.tsoil+273))).*exp(-claypar*(data.clay));
% calculating equilibria soil pools with proposed parameters:
    SOC=Km.*(rd)./(Vmax.*CUE-rd);
    MIC=(data.iSOC)./(Vmax.*(SOC./(Km+SOC))-rd);

    mod=reshape(SOC+MIC,64*128,1);
    modm=reshape(MIC,64*128,1);

    %J_new=(1/(2*nanvar(data.obs)))*(nansum((mod-data.obs).^2))+(1/(2*nanvar(data.obs2)))*(nansum((modm-data.obs2).^2));
    J_t = sqrt(nanmean((mod-data.obs).^2)) ;
    J_v = sqrt(nanmean((mod-data.obsv).^2)) ;
    covr = nancov(mod,data.obs) ;
    corr_t = covr(1,2)/sqrt(covr(1,1)*covr(2,2)) ;
    covr = nancov(mod,data.obsv) ;
    corr_v = covr(1,2)/sqrt(covr(1,1)*covr(2,2)) ;
    res = [J_t, corr_t, J_v, corr_v] ;
end
