%%%-------------------------------------------------------------%%%
function [xbest, fbest,allf,allx] = SCEUA(cmodel,maxfunevals,flag)
% classical DE algorithm from "The DE Evolution Strategy: A Tutorial"
    %set SCEUA parameters
   % cmodel = datainput_Carbon2;
    
    DIM = length(flag) ;
    p = 3 ;
    m = 2*DIM ;
    s = p*m ;
    q = DIM+1 ;
    a = 1 ;
    b = 2*DIM+1 ;
    n = s ;
    pops = rand(n,DIM) ;
    fs = zeros(1,s) ;
    for i=1:s 
        fs(i) = cmodel.objfunction(flag,pops(i,:));
    end
    allf = fs' ;
    allx = pops ;
    [fbest,fid] = min(fs) ;
    xbest = pops(fid,:) ;
    counteval = s ;
    while counteval < maxfunevals 
        %counteval = counteval+s ;
        
        [sf,index] = sort(fs) ;
        for pi=1:p
            ccePop = zeros(DIM,m) ;
            cceF = zeros(m,1) ;
            for mi=1:m 
                ccePop(:,mi) = pops(index(mi+pi*m-m),:)' ;
                cceF(mi) = sf(mi+pi*m-m) ;
            end
            for bi=1:b
                cceB = zeros(DIM,q) ;
                cceBf = zeros(q,1) ;
                cceL = zeros(q,1) ;
                cceUsed = zeros(m,1) ;
                pii = zeros(m,1) ;
                for mi=1:m
                    pii(mi) = 2*(m-mi+1)/(m*(m+1)) ;
                end
                qii = 1 ;
                while qii<=q 
                    
                    rd = rand();
                    st = 0 ;
              
                    tar = 0 ;
                    while(rd>st)
                        tar = tar+1 ;
                        st = st+pii(tar) ;
                    end
                    if(cceUsed(tar)==1)
                        qii = qii-1 ;
                    else
                        cceUsed(tar) = 1 ;
                        cceL(qii) = tar ;
                        cceBf(qii) = cceF(tar) ;
                        cceB(:,qii) = ccePop(:,tar) ;
                    end
                    qii = qii+1 ;
                end
                for ai=1:a
                    [scceb, scceind] = sort(cceBf) ;
                    cceG = zeros(DIM,1) ;
                    for di = 1:DIM
                        cceG(di) = mean(cceB(di,:)) ;
                    end
                    cceR = cceG*2-cceB(:,scceind(q)) ;
                    for di=1:DIM
                        if cceR(di)>1 || cceR(di)<0
                            cceR(di) = rand() ;
                        end
                    end

                    fr = cmodel.objfunction(flag,cceR') ;
                    allf = [allf;fr] ;
                    allx = [allx;cceR'] ;
                    counteval = counteval+1 ;
                    
                    if fr<cceBf(scceind(q))
                        cceB(:,scceind(q)) = cceR ;
                        cceBf(scceind(q)) = fr ;
                    else
                        cceR = (cceG + cceB(:,scceind(q)))/2 ;
                         fr = cmodel.objfunction(flag,cceR') ;
                        allf = [allf;fr] ;
                        allx = [allx;cceR'] ;
                        counteval = counteval+1 ;
                        if fr<cceBf(scceind(q))
                            cceB(:,scceind(q)) = cceR ;
                            cceBf(scceind(q)) = fr ;
                        else
                            cceB(:,scceind(q)) = rand(DIM,1) ;
                            counteval = counteval+1 ;
                            cceBf(scceind(q)) = cmodel.objfunction(flag,cceB(:,scceind(q))') ;
                            allf = [allf;cceBf(scceind(q))] ;
                            allx = [allx;cceB(:,scceind(q))'] ;
                        end
                    end
                end
                
                for qi=1:q
                    ccePop(:,cceL(qi)) = cceB(:,qi) ;
                    cceF(cceL(qi)) = cceBf(qi) ;
                end
                [newccef, cceind] = sort(cceF) ;
                cceF = newccef ;
                newcceP = zeros(DIM,m) ;
                for mi=1:m 
                    newcceP(:,mi) = ccePop(:,cceind(mi)) ;
                end
                ccePop = newcceP ;
            end
            for mi=1:m 
                pops(index(mi+pi*m-m),:) = ccePop(:,mi)' ;
                fs(index(mi+pi*m-m)) = cceF(mi) ;
            end
        end
        if fbest>min(fs)
            [fbest, bind] = min(fs) ;
            xbest = pops(bind,:) ;
        end 
    end
    fbest = cmodel.evaluate(flag,xbest) ;
    %save sceua_res
    %xbest = pops(:,index(1))' ;
    %mybest-fgeneric('ftarget')
end
        
        
                
                
                
                            
                            



