%%%-------------------------------------------------------------%%%
function [xbest, fbest,allf,allx] = PSO(cmodel,maxfunevals, flag)
% Adaptive PSO algorithm from "The DE Evolution Strategy: A Tutorial"
    % set F, CR and N
   % cmodel = datainput_Carbon1 ;
    
    history = zeros(100,1) ;
    hist_step = 5000 ;
    hist_id = 0 ;
    
    n = 50;
    vmax = 0.15 ;
    w = 0.8 ;
    w1 = 0.8 ;
    w2 = 0.2 ;
    c1 = 1.0 ;
    c2 = 1.0 ;
    DIM = length(flag) ;
    %initialize the population
%     pops = goodParas(:,1:n)' ;
%     for i=1:n 
%         for j=1:DIM
%             pops(i,j) = (pops(i,j)-postmin(j))/(postmax(j)-postmin(j)) ;
%         end
%     end
%     pops
%     popF = goodJ(1:n) ;
    pops = rand(n,DIM) ;
    popF = zeros(n,1) ;
    allf = [] ;
    allx = pops ;
    for i=1:n
        %feval(FUN,pops(i,:)')
        
        popF(i) = cmodel.objfunction(flag,pops(i,:));
        allf = [allf;popF(i)] ;
    end
    v = 0.15*(rand(n,DIM)) ;
    pBest = pops ;
    pBestF = popF ;
    [gBestF, id] = min(pBestF) ;
    gBest = pBest(id,:) ;
    counteval = n ;
    allpoints = pops ;
    allf = popF ;
    while counteval<maxfunevals
       
        if counteval>hist_id*hist_step 
            hist_id = hist_id+1 ;
            history(hist_id) = gBestF ;
        end
        counteval = counteval+n ;
        pops = pops+v ;
        w = w - (w1-w2)/(maxfunevals/n) ;
        %check the pops 
        for i=1:n
            for j=1:DIM
                if pops(i,j)>1 || pops(i,j)<0
                    pops(i,j) = rand() ;
                end
            end
        end
        
        %update the pBestF and gBest
        for i=1:n
            popF(i) = cmodel.objfunction(flag,pops(i,:));
            allx = [allx;pops(i,:)] ;
            if popF(i)<pBestF(i)
                pBestF(i) = popF(i) ;
                pBest(i,:) = pops(i,:);
                if pBestF(i) < gBestF
                    gBest = pBest(i,:) ;
                    gBestF = pBestF(i) ;
                    
                end
            end
        end
        allpoints = [allpoints;pops] ;
        allf = [allf;popF] ;
        %update speed v
        for i=1:n
            for j=1:DIM
                v(i,j) = w*v(i,j) + c1*rand()*(pBest(i,j)-pops(i,j)) ...
                        + c2*rand()*(gBest(j)-pops(i,j)) ;
                if abs(v(i,j))>vmax*10 
                    v(i,j) = v(i,j)/2 ;
                end
            end
        end
    end
    xbest = gBest ;
    fbest = cmodel.evaluate(flag,xbest) ;
    %save psores.mat
end
