%%%-------------------------------------------------------------%%%
function [xbest, fbest, allf, allx] = DE(cmodel, maxfunevals,fflag)
% classical DE algorithm from "The DE Evolution Strategy: A Tutorial"
% set F, CR and N
    %cmodel = datainput_Carbon1 ;

    history = zeros(100,1) ;
    hist_id = 0 ;
    hist_step = 5000 ;

    DIM = length(fflag) ;
    F = 0.5 ;
    CR = 0.8 ;
    n = 2*DIM ;
    pops = rand(n,DIM) ;
    true_pop = pops ;
    f = zeros(n,1) ;
    fbest = 0 ;
    flag = 0 ;
    high = 1 ;
    low = 0 ;
    xmean = zeros(1,DIM) ;
    allx = pops ;

    for i=1:n
        f(i) = cmodel.objfunction(fflag,pops(i,:)) ;
        if flag==0
            fbest = f(i) ;
            xmean = pops(i,:) ;
            flag = 1 ;
        else
            if f(i)<fbest
                fbest = f(i) ;
                xmean = pops(i,:);
            end
        end
    end
    allf = f ;
    counteval = n ;
    temps = zeros(n,DIM) ;
    tf = zeros(n,1) ;
    while counteval < maxfunevals
        if counteval > hist_id*hist_step
            hist_id = hist_id+1;
            history(hist_id) = min(allf) ;
        end
        counteval = counteval + n ;
        for i=1:n
            r1 = randi([1,n]) ;
            r2 = randi([1,n]) ;
            r3 = randi([1,n]) ;
            while r1 == r2
                r2 = randi([1,n]) ;
            end ;
            while r2==r3 || r3==r1
                r3 = randi([1,n]) ;
            end
            temps(i,:) = pops(r1,:) + F*(pops(r2,:)-pops(r3,:)) ;
            r = randi([1,DIM]) ;
            for j=1:DIM
                if temps(i,j) > high || temps(i,j)<low
                    temps(i,j) = rand() ;
                end
                if j~=r && rand(1,1)>CR
                    temps(i,j) = pops(i,j) ;
                end
            end
            tf(i) = cmodel.objfunction(fflag,temps(i,:)) ;
        end
        allx = [allx;temps] ;
        allf = [allf;tf];
        for i=1:n
            if tf(i)<f(i)
                pops(i,:) = temps(i,:) ;
                if(tf(i)<fbest)
                    fbest = tf(i) ;
                    xmean = pops(i,:) ;
                end
            end
        end
    end
    xbest = xmean ;
    fbest = cmodel.evaluate(fflag,xbest) ;
    %save deres.mat
end

