%%%-------------------------------------------------------------%%%
function [xbest, fbest, allf, allx] = CMAES(cmodel, maxfunevals,flag)
% CMA-ES algorithm from "The CMA Evolution Strategy: A Tutorial"
    %select carbon model ;
    %cmodel = datainput_Carbon2;
    history = zeros(100,1) ;
    hist_id = 0 ;
    hist_step = 1000 ;
    DIM = length(flag) ;
    N = DIM ;
    xmean = rand(N,1) ; %assume the range is (0,1)
    bestf = 1000 ;
    sigma = 0.1;
    stopfitness = 1e-10 ;
    stopeval = maxfunevals ;
    ftarget = 0 ;

    lambda = 4+floor(3*log(N)) ;
    mu = lambda/2 ;
    weights = log(mu+1/2)-log(1:mu) ;
    mu = floor(mu) ;
    weights = weights/sum(weights);
    mueff = sum(weights)^2/sum(weights.^2);

    cc = (4+mueff/N) / (N+4+2*mueff/N) ;
    cs = (mueff+2) /(N+mueff+5) ;
    c1 = 2/((N+1.3)^2+mueff) ;
    cmu = 2*(mueff-2+1/mueff) / ((N+2)^2+2*mueff/2) ;
    damps = 1 + 2*max(0,sqrt((mueff-1)/(N+1))-1) +cs ;

    pc = zeros(N,1) ;
    ps = zeros(N,1) ;
    B= eye(N) ;
    D= eye(N) ;
    C = B*D*(B*D)';
    eigeneval = 0 ;
    chiN = N^0.4*(1-1/(4*N)+1/(21*N^2)) ;
    allx = zeros(0,0) ;
    allf = zeros(0,0);
    counteval = 0 ;
    arz = zeros(N,lambda) ;
    arx = zeros(N,lambda) ;
    while counteval < stopeval
        for k=1:lambda
            arz(:,k) = randn(N,1) ;
            arx(:,k) = xmean + sigma * (B*D*arz(:,k)) ;
            for kk=1:DIM
                if arx(kk,k)>1 || arx(kk,k)<0
                    arx(kk,k) = rand() ;
                end
            end
            fx(k) = cmodel.objfunction(flag,arx(:,k)');
            if bestf>fx(k)
                bestf = fx(k) ;
            end
            counteval = counteval + 1 ;
        end
        allx = [allx;arx'] ;
        allf = [allf;fx'] ;
        [fx, arindex] = sort(fx) ;
        xmean = (arx(:,arindex(1:mu))*weights') ;

        zmean = (arz(:,arindex(1:mu))*weights') ;

        ps = (1-cs)*ps + (sqrt(cs*(2-cs)*mueff)) * (B*zmean);
        hsig = norm(ps)/sqrt(1-(1-cs)^(2*counteval/lambda))/chiN<1.4+2/(N+1) ;
        pc = (1-cc)*pc + hsig * sqrt(cc*(2-cc)*mueff) * (B*D*zmean) ;
        C = (1-c1-cmu)*C ...
            + c1 * (pc*pc' ...
            +(1-hsig)*(2-cc) * C) ...
            + cmu ...
            * (B*D*arz(:,arindex(1:mu))) ...
            * diag(weights) * (B*D*arz(:,arindex(1:mu)))' ;

        % sigma = sigma * exp((cs/damps)*(norm(ps)/chiN-1)) ;
        sigma = sigma * 0.95 ;
        if sigma < 0.01
            sigma = 0.01 ;
        end
        if counteval - eigeneval > lambda/(c1 + cmu)/N/10
            eigeneval = counteval  ;
            C = triu(C) + triu(C,1)' ;
            [B,D] = eig(C) ;
            D = diag(sqrt(diag(D))) ;
        end

        if abs(fx(1)-ftarget) <= stopfitness
            disp('success') ;
            break ;
        end

        %counteval
        if counteval > hist_id * hist_step
            hist_id = hist_id+1 ;
            history(hist_id) = min(allf) ;
        end
        % disp([num2str(counteval) ':' num2str(fx(1))]) ;
    end
    [~, res_id] = min(allf) ;
    xbest = allx(res_id,:) ;
    fbest = cmodel.evaluate(flag,xbest) ;
    
    %save cmaes_res.mat
end

