!     ################################
      MODULE MODI_LIMA_MIXRAT_TO_NCONC
!     ################################
INTERFACE
SUBROUTINE LIMA_MIXRAT_TO_NCONC(PPABST, PTHT, PRVT, PSVT)
!
REAL, DIMENSION(:,:,:),   INTENT(IN) :: PPABST ! Absolute pressure
REAL, DIMENSION(:,:,:),   INTENT(IN) :: PTHT   ! Potential temperature
REAL, DIMENSION(:,:,:),   INTENT(IN) :: PRVT   ! Water Vapor mix. ratio
REAL, DIMENSION(:,:,:,:),   INTENT(INOUT) :: PSVT ! Mixing ratios IN
                                          ! number concentrations OUT
!
END SUBROUTINE LIMA_MIXRAT_TO_NCONC
END INTERFACE
END MODULE MODI_LIMA_MIXRAT_TO_NCONC
!
!     ########################################################
      SUBROUTINE LIMA_MIXRAT_TO_NCONC(PPABST, PTHT, PRVT, PSVT)
!     ########################################################
!
!
!!****  *LIMA_MIXRAT_TO_NCONC* - converts MACC aerosol mixing ratios into
!!                                 number concentrations 
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    23/01/16 (J.-P. Pinty) 
!-------------------------------------------------------------------------------
!
!*      0. DECLARATIONS
!
USE MODD_CST,        ONLY : XP00, XMD, XMV, XRD, XCPD, XTT, XPI, XRHOLW, &
                            XALPW, XBETAW, XGAMW, XALPI, XBETAI, XGAMI
USE MODD_NSV,        ONLY : NSV_LIMA_CCN_FREE, NSV_LIMA_IFN_FREE
USE MODD_PARAM_LIMA, ONLY : NMOD_CCN, NMOD_IFN,                   &
                            XR_MEAN_CCN, XLOGSIG_CCN, XRHO_CCN,   &
                            XMDIAM_IFN, XSIGMA_IFN, XRHO_IFN,     & 
                            NSPECIE, XFRAC
!
IMPLICIT NONE
!
!* 0.1. Declaration of arguments
!       ------------------------
!
REAL, DIMENSION(:,:,:),   INTENT(IN) :: PPABST ! Absolute pressure
REAL, DIMENSION(:,:,:),   INTENT(IN) :: PTHT   ! Potential temperature
REAL, DIMENSION(:,:,:),   INTENT(IN) :: PRVT   ! Water Vapor mix. ratio
REAL, DIMENSION(:,:,:,:),   INTENT(INOUT) :: PSVT ! Mixing ratios IN
                                          ! number concentrations OUT
!
!* 0.2 Declaration of local variables
!      ------------------------------
!
REAL,DIMENSION(SIZE(PTHT,1),SIZE(PTHT,2),SIZE(PTHT,3)) :: ZT    ! Temperature
REAL,DIMENSION(SIZE(PTHT,1),SIZE(PTHT,2),SIZE(PTHT,3)) :: ZREHU ! Relat. Humid.
REAL,DIMENSION(SIZE(PTHT,1),SIZE(PTHT,2),SIZE(PTHT,3)) :: ZGROWTH_FACT
REAL,DIMENSION(SIZE(PTHT,1),SIZE(PTHT,2),SIZE(PTHT,3)) :: ZRHO_CCN_WET
REAL,DIMENSION(SIZE(PTHT,1),SIZE(PTHT,2),SIZE(PTHT,3)) :: ZWORK
!
INTEGER       :: JLOC, JCCN, JIFN, JSPECIE
REAL          :: ZFACT_CCN, ZFACT_IFN
!
!----------------------------------------------------------------------
!
! Temperature to compute the relative humidity
!
ZT(:,:,:) = PTHT(:,:,:)*(PPABST(:,:,:)/XP00)**(XRD/XCPD)
ZWORK(:,:,:) = PRVT(:,:,:)*PPABST(:,:,:)/((XMV/XMD)+PRVT(:,:,:))
                   ! water vapor partial pressure
ZREHU(:,:,:) = ZWORK(:,:,:)/EXP( XALPW-XBETAW/ZT(:,:,:)-XGAMW*ALOG(ZT(:,:,:)) )
                   ! saturation over water
WHERE ( ZT(:,:,:)<XTT )
  ZREHU(:,:,:) = ZWORK(:,:,:)/EXP(XALPI-XBETAI/ZT(:,:,:)-XGAMI*ALOG(ZT(:,:,:)))
                   ! saturation over ice
END WHERE
ZREHU(:,:,:) = MIN( 0.99, MAX( 0.01,ZREHU(:,:,:) ) )
!
! All size distribution parameters are XLOGSIG_CCN and XR_MEAN_CCN (radii)
! Treatment of the soluble aerosols (CCN)
!
!IF( NAERO_TYPE=="CCN" ) THEN
!
! sea-salt, sulfate, hydrophilic (GADS data)
!
!  NMOD_CCN=3
  IF (.NOT.(ALLOCATED(XR_MEAN_CCN))) ALLOCATE(XR_MEAN_CCN(NMOD_CCN))
  IF (.NOT.(ALLOCATED(XLOGSIG_CCN))) ALLOCATE(XLOGSIG_CCN(NMOD_CCN))
  IF (.NOT.(ALLOCATED(XRHO_CCN)))    ALLOCATE(XRHO_CCN(NMOD_CCN))
!!      XR_MEAN_CCN(:) = (/ 0.209E-6 , 0.0695E-6 , 0.0212E-6 /)
!!      XLOGSIG_CCN(:) = (/ 0.708    , 0.708     , 0.806     /)
!!      XRHO_CCN(:)    = (/ 2200.    , 1700.     , 1800.     /)
      XR_MEAN_CCN(:) = (/ 0.209E-6 , 0.0695E-6 , 0.075E-6 /)
      XLOGSIG_CCN(:) = (/ 0.708    , 0.708     , 0.7      /)
      XRHO_CCN(:)    = (/ 2200.    , 1700.     , 1360.    /)
!
DO JCCN = 1,NMOD_CCN
!
! compute the wet diameter from the dry diameter and hygroscopic growth
!
  ZFACT_CCN = ( (0.75/XPI)*EXP(-4.5*(XLOGSIG_CCN(JCCN))**2) )/XR_MEAN_CCN(JCCN)**3
!
! GF=wet/dry look-up table (Chin et al., JAS, 2002)
! GF=wet/dry formula (Kreidenweis et al., ACP, 2005)
!
! JCCN=1 is for Sea Salt
! JCCN=2 is for Sulphate
! JCCN=3 is for Hydrophilic OC and BC (sulphate coating)
!
  ZGROWTH_FACT(:,:,:) = 1.0
  IF( JCCN==1 ) THEN ! Sea salt
!
! ZORDINATE_REHU = (/0.0, 50.0, 70.0, 80.0, 90.0, 95.0, 99.0/)
! ZGROWTH_REHU   = (/1.0, 1.6, 1.8, 2.0, 2.4, 2.9, 4.8/)
!
    WHERE( ZREHU(:,:,:)>0.75 ) ! DRH of NaCl is 75% in S&P (p 508)
      ZGROWTH_FACT(:,:,:) = ( 1.0 + ((3.9265*ZREHU(:,:,:)-8.3817)*   &
                                             ZREHU(:,:,:)+5.7887)*   &
                             ZREHU(:,:,:)/(1.0-ZREHU(:,:,:)) )**0.3333
    END WHERE
  END IF
  IF( JCCN==2 ) THEN ! Ammonium sulphate
!
! ZORDINATE_REHU = (/0.0, 50.0, 70.0, 80.0, 90.0, 95.0, 99.0/)
! ZGROWTH_REHU   = (/1.0, 1.4, 1.5, 1.6, 1.8, 1.9, 2.2/)
!
    WHERE( ZREHU(:,:,:)>0.80 ) ! DRH of (NH4)2SO4 is 80% in S&P (p 508)
      ZGROWTH_FACT(:,:,:) = ( 1.0 + ((1.8816*ZREHU(:,:,:)-3.8526)*   &
                                             ZREHU(:,:,:)+2.4285)*   & 
                             ZREHU(:,:,:)/(1.0-ZREHU(:,:,:)) )**0.3333
    END WHERE
  END IF
  IF( JCCN==3 ) THEN ! OC or BC coated ~Ammonium sulphate
!
! ZORDINATE_REHU = (/0.0, 50.0, 70.0, 80.0, 90.0, 95.0, 99.0/)
! ZGROWTH_REHU   = (/1.0, 1.2, 1.4, 1.5, 1.6, 1.8, 2.2/) !! OC
! ZGROWTH_REHU   = (/1.0, 1.0, 1.0, 1.2, 1.4, 1.5, 1.9/) !! BC
!
    WHERE( ZREHU(:,:,:)>0.50 ) ! DRH of (NH4)2SO4 and organics estimated at 50%
      ZGROWTH_FACT(:,:,:) = ( 1.0 + ((1.8816*ZREHU(:,:,:)-3.8526)*   &
                                             ZREHU(:,:,:)+2.4285)*   & 
                             ZREHU(:,:,:)/(1.0-ZREHU(:,:,:)) )**0.3333
    END WHERE
  END IF
!
! Compute the CCN volumic mass
!
  ZWORK(:,:,:) = (1.0/ZGROWTH_FACT(:,:,:))**3
  ZRHO_CCN_WET(:,:,:) = XRHO_CCN(JCCN)*ZWORK(:,:,:) + XRHOLW*(1.0-ZWORK(:,:,:))
!
! compute the CCN number concentration
!
  JLOC = NSV_LIMA_CCN_FREE + JCCN-1 ! CCN free then CCN acti
!!  PSVT(:,:,:,JLOC) = 2.0 * ZFACT_CCN*(PSVT(:,:,:,JLOC)/ZRHO_CCN_WET(:,:,:)) ! Result 04
!!  PSVT(:,:,:,JLOC) = 0.5 * ZFACT_CCN*(PSVT(:,:,:,JLOC)/ZRHO_CCN_WET(:,:,:)) ! Result 03
  PSVT(:,:,:,JLOC) = ZFACT_CCN*(PSVT(:,:,:,JLOC)/ZRHO_CCN_WET(:,:,:)) ! Result 
!!  PSVT(:,:,:,JLOC) = 0.2 * ZFACT_CCN*(PSVT(:,:,:,JLOC)/ZRHO_CCN_WET(:,:,:)) ! Result 06
!!  PSVT(:,:,:,JLOC) = 5.0 * ZFACT_CCN*(PSVT(:,:,:,JLOC)/ZRHO_CCN_WET(:,:,:)) ! Result 05
                                                       ! is in #/Kg of dry air
END DO
!
! All size distribution parameters are XSIGMA_IFN and XMDIAM_IFN (diameters)
! Treatment of the insoluble aerosols (IFN)
!
!ELSE IF( NAERO_TYPE=="IFN" ) THEN
!
! dust, hydrophobic BIO+ORGA (GADS data)
!
!  NMOD_IFN=2
  NSPECIE=4
  IF (.NOT.(ALLOCATED(XMDIAM_IFN))) ALLOCATE(XMDIAM_IFN(NSPECIE))
  IF (.NOT.(ALLOCATED(XSIGMA_IFN))) ALLOCATE(XSIGMA_IFN(NSPECIE))
  IF (.NOT.(ALLOCATED(XRHO_IFN)))   ALLOCATE(XRHO_IFN(NSPECIE))
!!      XMDIAM_IFN = (/0.8E-6, 3.0E-6, 0.025E-6, 0.2E-6/)
!!      XSIGMA_IFN = (/2.0, 2.15, 2.0, 1.6 /)
!!      XRHO_IFN   = (/2600., 2600., 1000., 1500./)
      XMDIAM_IFN = (/0.8E-6, 3.0E-6, 0.2E-6, 0.2E-6/)
      XSIGMA_IFN = (/2.0, 2.15, 1.6, 1.6 /)
      XRHO_IFN   = (/2600., 2600., 1860., 1500./)
  IF (.NOT.(ALLOCATED(XFRAC))) ALLOCATE(XFRAC(NSPECIE,NMOD_IFN))
      XFRAC(1,1)=1.0
      XFRAC(2,1)=0.0
      XFRAC(3,1)=0.0
      XFRAC(4,1)=0.0
      XFRAC(1,2)=0.0
      XFRAC(2,2)=0.0
      XFRAC(3,2)=0.5
      XFRAC(4,2)=0.5
!
DO JIFN = 1,NMOD_IFN
!
! compute the number concentration assuming no deposition of water
! IFN are considered as insoluble dry aerosols
!
  ZFACT_IFN = 0.0
  DO JSPECIE = 1,NSPECIE ! Conversion factor is weighted by XFRAC
    ZFACT_IFN = ZFACT_IFN + XFRAC(JSPECIE,JIFN)*                       &
                ( (6/XPI)*EXP(-(9.0/2.0)*LOG(XSIGMA_IFN(JSPECIE))) ) / &
                ( XRHO_IFN(JSPECIE)*XMDIAM_IFN(JSPECIE)**3 ) 
  END DO
  JLOC = NSV_LIMA_IFN_FREE + JIFN-1 ! IFN free then IFN nucl
!!  PSVT(:,:,:,JLOC) = 2.0 * ZFACT_IFN*PSVT(:,:,:,JLOC) ! Result is in #/Kg of dry air
!!  PSVT(:,:,:,JLOC) = 0.5 * ZFACT_IFN*PSVT(:,:,:,JLOC) ! Result is in #/Kg of dry air
  PSVT(:,:,:,JLOC) = ZFACT_IFN*PSVT(:,:,:,JLOC) ! Result is in #/Kg of dry air
!!  PSVT(:,:,:,JLOC) = 0.2 * ZFACT_IFN*PSVT(:,:,:,JLOC) ! Result is in #/Kg of dry air
!!  PSVT(:,:,:,JLOC) = 5.0 * ZFACT_IFN*PSVT(:,:,:,JLOC) ! Result is in #/Kg of dry air
END DO
!
END SUBROUTINE LIMA_MIXRAT_TO_NCONC
