#!/usr/bin/python

#def palaeotripfluxes(modeloutput,metadata):

# Write out model output fluxes into the PALAEOTRIP format. 
# 
# Syntax:
# palaeotripfluxes(modeloutput,metadata)
#
# Line Arguments: 
#  modeloutput : CSV file containing model output. See below for
#                instructions on how to fill this. 
#  metadata    : CSV file containing user and model run metadata.
#                See below for instructions on how to fill this.
# Example:
#  python palaeotripfluxes modeloutput.csv metadata.csv
# 
# Information on CSV format:
#  The CSV files should conform to the RFC 4180 standard. The first row will consist of headers (see next section), each field will be seperate by a comma, rows will be seperated by a line break. If a quantitiy is not incuded simply do not include a column with that header. 
# 
# - modeloutput should contain the following headers and fields. 
#    Quantities on levels (those marked * are required). 
#    plevel*  : pressure on levels (layer bountaries) (Pa)
#    Fswdndir : direct solar flux down (W/m/m)
#    Fswdndif : difuse solar flux down (W/m/m)
#    Fswdn    : total solar flux down (Fswdndir+Fswdndif) (W/m/m)
#    Fswup    : solar flux up (W/m/m)
#    Fswnet*  : net solar flux (Fswdn-Fswup) (W/m/m)
#    Flwdn    : thermal flux down (W/m/m)
#    Flwup    : thermal flux up (W/m/m)
#    Flwnet*  : net thermal flux (Flwdn-Flwup) (W/m/m)
#    Quantities on layers (all should be included if any are)
#    player   : pressure at layer centre (Pa)
#    Qsolar   : solar heating rate (K/day)
#    Qtherm   : thermal heating rate (K/day)
#   If the model you are running does not supply data for a field, leave
#   that field empty. 
# 
# - metadata should contain the following headers and fields
#    runcode*  : String containing the code name of run. See protocol for codes.
#    modelname*: String containing the name (and version number) of model. 
#    username* : String containing your name  (e.g. 'Colin Goldblatt')
#    useremail*: String containing your email (e.g. 'czg@uvic.ca')
#    usernotes*: String containing any notes about this run

import sys, csv

# print 'Number of arguments:', len(sys.argv), 'arguments.' # DEBUGGING LINE
# print 'Argument List:', str(sys.argv) # DEBUGGING LINE

if len(sys.argv) != 3:
    print 'Wrong number of arguments, please include both the model output and run metadata CSV files as line argumnets. See code for details.'
    sys.exit(2)
    
modeloutput_file = sys.argv[1]
metadata_file = sys.argv[2]

modeloutput = csv.reader(open(sys.argv[1]))
metadata = csv.reader(open(sys.argv[2]))

Quantlevel = ['plevel','Fswdndir','Fswdndif','Fswdn','Fswup','Fswnet','Flwdn','Flwup','Flwnet']
Quantlayer = ['player', 'Qsolar', 'Qtherm']
Quantreq = ['plevel', 'Fswnet', 'Flwnet']
Quantmeta = ['runcode', 'modelname', 'username', 'useremail', 'usernotes']
nQuantlevel = len(Quantlevel)
nQuantlayer = len(Quantlayer)
nQuantreq =  len(Quantreq)
nQuantmeta = len(Quantmeta)

# check for required quantities
SuppliedQuant = list(next(modeloutput))

for quant in Quantreq:
    if quant not in SuppliedQuant:
        print 'Required quantity %s not supplied' % quant
        sys.exit(2)        
        
# check whether layers are included
if 'player' in SuppliedQuant:
    layeroutput = 1
else:
    layeroutput = 0