function Total_atmos_effect

% Greenhousegas concentration ('total atmosphere effect') forcing files
% Find regional atmeff evolution (combined emissivity, greenhous-gas and polar amplification) that yields surface temperature evolution in EBM that follows GCM-based regional temperatures.
% See manuscript for further details

% Load regional atmospheric temperature data:
load('T_gcm.mat')

atmeff = zeros(eq_length+trans_length,7);

for tt=1:1:eq_length+trans_length
	atmeff(tt,2) = ((1-apln(2))*solin(2)-(diff_cnt(2)*(Tgmc(tt,1)-Tgcm(tt,2))/dyu(3)))/(stebol*Tgcm(tt,1)^4);
	atmeff(tt,3) = ((1-apln(3))*solin(3)-((diff_cnt(3)*(Tgcm(tt,2)-Tgcm(tt,3))/dyu(4))-(diff_cnt(2)*(Tgcm(tt,1)-Tgcm(tt,2))/dyu(3))))/(stebol*Tgcm(tt,2)^4);
	atmeff(tt,4) = ((1-apln(4))*solin(4)-((diff_cnt(4)*(Tgcm(tt,3)-Tgcm(tt,4))/dyu(5))-(diff_cnt(3)*(Tgcm(tt,2)-Tgcm(tt,3))/dyu(4))))/(stebol*Tgcm(tt,3)^4);
	atmeff(tt,5) = ((1-apln(5))*solin(5)-((diff_cnt(5)*(Tgcm(tt,4)-Tgcm(tt,5))/dyu(6))-(diff_cnt(4)*(Tgcm(tt,3)-Tgcm(tt,4))/dyu(5))))/(stebol*Tgcm(tt,4)^4);
	atmeff(tt,6) = ((1-apln(6))*solin(6)-(-(diff_cnt(5)*(Tgcm(tt,4)-Tgcm(tt,5))/dyu(6))))/(stebol*Tgcm(5)^4);
end

save('atmeff.mat','atmeff')

