
clear all;

display('========= run LS-APC algorithm ==========');

iterations = 300;
scaling = 1; % not necessary
pos = 1; % positivity of solution

% turn off warnings of ill-condition...
warning('off','all')

%% data loading
data = 3;
switch data
    case 1
        % different etex experiment then used in GMD
        load ./ETEX1_Run005_GF_0_2.mat
        x_true = xt;
    case 2
        load ./phantom_04_noise00.mat
    case 3
        load ./phantom_04_noise04.mat
    case 4
        load ./phantom_04_noise08.mat
end


%% scaling
if scaling
    coef = max(abs(y));
    y = y./coef;
    M = M./coef;
end

%% run LS-APC algorithm
[hat_x,info] = alg_LSAPC(y,M,iterations,pos);


%% print results
print_type = 1; % 1 - all parameters, 2 - only source term
print_results(print_type,hat_x,y,M,x_true,info);

display(['sum(y) ' num2str(sum(y))]);
display(['sum(M*x_true) ' num2str(sum(M*x_true))]);
display(['sum(M*hat_x) ' num2str(sum(M*hat_x))]);
display(['sum(hat_x) is ' num2str(sum(hat_x)) ' , sum(x_true) is ' num2str(sum(x_true))]);




display('...done')











