function [hat_x,info] = alg_LSAPC(y,M,iterations,pos)

% Least square with adaptive prior covariance (LS-APC) algorithm
% In case of questions, please, do not hasitate to contact me, Ondrej Tichy, at otichy@utia.cas.cz


[p n] = size(M);

%% prepare auxiliary structures
indL = zeros(n,n);
s = 2; 
r = 1; 

if 1
    blok = [ones(1,s) zeros(1,n/r-s)];
    indDiag = kron(ones(1,r),blok);
else
    blok = [ones(1,s) zeros(1,n/r-s)];
    blok2 = [ones(1,s-1) zeros(1,n/r-s+1)];
    indDiag = kron(ones(1,r) - [0 ones(1,r-1)],blok) + kron(ones(1,r) - [1 zeros(1,r-1)],blok2);
end
% keyboard
for j = 1:(n)
    if indDiag(j)
        indL = indL + diag(ones(n-j+1,1),j-1);
    end
end
indL = indL' - eye(n);


%% start data
hat_upsilon = ones(n,1);
hat_L = eye(n);
hat_omega = max(max(M'*M))^(-1);
hat_x = ones(n,1);

Dsi_lj = ones(n,n);

hat_varsigma = indL;
hat_LLt = hat_L*hat_L';

koef_el0 = -1; % prior l0
eL0 = zeros(n,n) + koef_el0*diag(ones(n-1,1),-1);

%% prior
alpha0 = 1e-10;
beta0 = 1e-10;
zeta0 = 1e-2;
eta0 = 1e-2;
vartheta0 = 1e-10;
rho0 = 1e-10;


pomLULt = 1*eye(n);
pomLtxxtL = 1*eye(n);


info.omega = zeros(iterations,1);


%% computation
konec = 1;
iter = 0;
while konec
    iter = iter + 1;
    if mod(iter,10) == 0
        display(['LS-APC alg.: iteration ' num2str(iter) '/' num2str(iterations)])    
    end

    %% x
    si_x = (hat_omega*M'*M + hat_L*diag(hat_upsilon)*hat_L' + pomLULt )^(-1);
    mu_x = si_x*(hat_omega*M'*y);
    
    if pos
        [hat_x hat_xx] = momtrun_low(mu_x,sqrt(diag( si_x )),0);
        var_x = hat_xx - hat_x.^2;
        hat_xxt = hat_x*hat_x' + diag(var_x);
        if 1
            old_dSi = diag(si_x);
            new_dSi = var_x;
            nasobic = diag(sqrt(new_dSi./old_dSi));
            new_si_x = nasobic*si_x*nasobic;
            hat_xxt = hat_x*hat_x' + new_si_x;
        end
    else
        mu_x(mu_x<0) = 0.0*mu_x(mu_x<0);
        hat_x = mu_x;
        hat_xxt = mu_x*mu_x' + si_x;
    end    
  
    %% upsilon
    alpha = alpha0 + (1/2)*ones(n,1);
    
    for j = 1:(n-1)
        ind = find(indL(:,j)>0);
        pomLtxxtL(j,j) = hat_L([j; ind],j)'*hat_xxt([j; ind],[j; ind])*hat_L([j; ind],j) + trace(diag(Dsi_lj(ind,j))*hat_xxt(ind,ind));
    end
    pomLtxxtL(n,n) = hat_xxt(n,n);
    
    beta = beta0 + (1/2)*diag(pomLtxxtL);
    hat_upsilon = alpha./beta;
    
    
    si_LLt = zeros(n);
    pomLULt = zeros(n);
    pomLtxxtL = zeros(n);
    %% l + varsigma
    % hat_L is lower triangular matrix
    for j = 1:(n-1)
        ind = find(indL(:,j)>0); % indexy, kde se bude neco dit...
        
        si_lj = (hat_upsilon(j)*hat_xxt(ind,ind) + diag(hat_varsigma(ind,j)) )^(-1);
        mu_lj = si_lj*(-hat_upsilon(j)*(hat_xxt(ind,j) ) + diag(hat_varsigma(ind,j))*eL0(ind,j));
        
        hat_lj = mu_lj;
        hat_ljljt = mu_lj*mu_lj' + si_lj;
        hat_ljtlj = mu_lj'*mu_lj + sum(diag(si_lj));
        
        hat_L(ind,j) = hat_lj;
        
        Dsi_lj(ind,j) = diag(si_lj);
        
        % varsigma(j)
        zeta = zeta0 + (1/2);
        eta = eta0 + (1/2)*diag(hat_ljljt) - diag(eL0(ind,j)*hat_lj') + (1/2)*diag(eL0(ind,j)*eL0(ind,j)');
        hat_varsigma(ind,j) = zeta./eta; % velka matice, podobna hat_L bez diagonaly

        % matrix LLt
        si_LLt(ind,ind) = si_lj;
        pomLULt(ind,ind) = pomLULt(ind,ind) + si_lj*hat_upsilon(j); % pomocna matice pro x
        
    end
    
    hat_LLt = hat_L*hat_L' + si_LLt;
    
    %% omega
    vartheta = vartheta0 + p/2;
    rho = rho0 + (1/2)*trace(hat_xxt*M'*M) - y'*M*hat_x + (1/2)*y'*y;
    hat_omega = vartheta/rho;
    
    info.omega(iter) = hat_omega;   
    
    


    if iter == iterations
        konec = 0;
    end
end



% keyboard

info.L = hat_L;
info.varsigma = hat_varsigma;
info.ups = hat_upsilon;
info.l1 = diag(hat_L,-1);



end