function varargout = MainBayGmmKda(varargin)
% MAINBAYGMMKDA MATLAB code for MainBayGmmKda.fig
%      MAINBAYGMMKDA, by itself, creates a new MAINBAYGMMKDA or raises the existing
%      singleton*.
%
%      H = MAINBAYGMMKDA returns the handle to a new MAINBAYGMMKDA or the handle to
%      the existing singleton*.
%
%      MAINBAYGMMKDA('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MAINBAYGMMKDA.M with the given input arguments.
%
%      MAINBAYGMMKDA('Property','Value',...) creates a new MAINBAYGMMKDA or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before MainBayGmmKda_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to MainBayGmmKda_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help MainBayGmmKda

% Last Modified by GUIDE v2.5 19-Oct-2016 10:17:13

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @MainBayGmmKda_OpeningFcn, ...
                   'gui_OutputFcn',  @MainBayGmmKda_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before MainBayGmmKda is made visible.
function MainBayGmmKda_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to MainBayGmmKda (see VARARGIN)

% Choose default command line output for MainBayGmmKda
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
addpath(genpath('Content')) 
% UIWAIT makes MainBayGmmKda wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = MainBayGmmKda_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in DataNormalization.
function DataNormalization_Callback(hObject, eventdata, handles)
% hObject    handle to DataNormalization (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
RawData = xlsread('DataSet.xlsx');
NormalizedDataSet = DataNormalizeMatrixForClass(RawData);
csvwrite('NormalizedDataSet.csv', NormalizedDataSet);


% --- Executes on button press in DataHistogram.
function DataHistogram_Callback(hObject, eventdata, handles)
% hObject    handle to DataHistogram (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
RawData = xlsread('DataSet.xlsx');
DatawClass = ConvertReal2Cate(RawData);
FigNum = 1;
FactorIdx_String = get(handles.edit1, 'String');
FactorIdx = str2double(FactorIdx_String);
figure(100);
hist(DatawClass(:, FactorIdx));

function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double


% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ViewData.
function ViewData_Callback(hObject, eventdata, handles)
% hObject    handle to ViewData (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
RawData = xlsread('DataSet.xlsx');
DatawClass = ConvertReal2Cate(RawData);
DatawClassPlusY = [DatawClass RawData(:, end)]
csvwrite('DatawClassPlusY.csv', DatawClassPlusY)
open('DatawClassPlusY.csv');


% --- Executes on button press in ScatterPlot.
function ScatterPlot_Callback(hObject, eventdata, handles)
% hObject    handle to ScatterPlot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
RawData = xlsread('DataSet.xlsx'); FigNum = 2;
Convert2Cate = 1;
ClassLabels = {'No-flood','Flood'};
ScatterPlotSingleVariable(RawData, FigNum, ...
    Convert2Cate, ClassLabels);


function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double


% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double


% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in TrainModel.
function TrainModel_Callback(hObject, eventdata, handles)
% hObject    handle to TrainModel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
KerParString = get(handles.edit5, 'String');
KerPar = str2double(KerParString);

GmmTrainMethod1 = get(handles.radiobutton1, 'Value');
GmmTrainMethod2 = get(handles.radiobutton2, 'Value');

DataSet = xlsread('TrainData.xlsx');

if GmmTrainMethod1 == 1
    MaxComp = 20; CovType = 'full'; Reg = 0.5;
    BayGmmKdaModel = TrainBayGmmKdaEM(DataSet, MaxComp, CovType,...
    Reg, KerPar);    
end

if GmmTrainMethod2 == 1
    MaxComp = 20; CovType = 0; Reg = 0.5;
    BayGmmKdaModel = TrainBayGmmKdaFJ(DataSet, MaxComp, CovType,...
    Reg, KerPar);   
end

save BayGmmKdaModel.mat BayGmmKdaModel;

% --- Executes on button press in FAST.
function FAST_Callback(hObject, eventdata, handles)
% hObject    handle to FAST (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ModelFun = 'BayKdaGmm';

DataSet = xlsread('TrainData.xlsx');
NoFeature = size(DataSet, 2) - 1;

NormalizedFOSIPercent = FastImplementation(NoFeature, ModelFun);
FigNum = 222; YLabel = 'FOSI'; XLabel = 'IF';
YRange = 0 : 10 : max(NormalizedFOSIPercent)*1.3;
BarPlot(NormalizedFOSIPercent, FigNum, XLabel, YLabel, YRange);

% --- Executes on button press in MutualInformation.
function MutualInformation_Callback(hObject, eventdata, handles)
% hObject    handle to MutualInformation (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Data = csvread('NormalizedDataSet.csv');
MI = MutualInfoForClass(Data);
FigNum = 3; YLabel = 'Mutual Information'; XLabel = 'IF';
YRange = 0:0.05:max(MI)*1.3;
    IF_Seq = [1:12];    
    NumX = size(IF_Seq, 2);
    RealXLabelsInput = cell(1, NumX);
    for k = 1 : NumX
        RealXLabelsInput{k} = num2str(IF_Seq(k));
    end
BarPlot(MI, FigNum, XLabel, YLabel, YRange,RealXLabelsInput);
% Data, FigNum, XLabel, YLabel, YRange, RealXLabelsInput


% --- Executes on button press in ModelPrediction.
function ModelPrediction_Callback(hObject, eventdata, handles)
% hObject    handle to ModelPrediction (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
load BayGmmKdaModel.mat BayGmmKdaModel;
TestData = xlsread('DataSet.xlsx');

Xte = TestData(:, 1:end-1);
Yte = TestData(:, end);

[Ytep, Posterior] = ...
    PredictBayGmmKdaClassifier(Xte, BayGmmKdaModel);
Labels = unique(Yte);
Pos = Labels(2); Neg = Labels(1);
[TPR, FPR, FNR, TNR] = ConfusionMatrix(Yte, Ytep, Pos, Neg);
TPRs = num2str(TPR);
FPRs = num2str(FPR);
FNRs = num2str(FNR);
TNRs = num2str(TNR);

CARtest = sum(Ytep==Yte)*100/length(Yte);
CARtests = num2str(CARtest);

save RocPlotCalculationData.mat Yte Posterior;
% FigNum = 260;
% [AUCteset, ~, ~] = RocPlotCalculation(Yte, Posterior(:,2), FigNum);

set(handles.edit6, 'String', CARtests);
set(handles.edit7, 'String', TPRs);
set(handles.edit8, 'String', FPRs);
set(handles.edit9, 'String', FNRs);
set(handles.edit10, 'String', TNRs);


function edit6_Callback(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit6 as text
%        str2double(get(hObject,'String')) returns contents of edit6 as a double


% --- Executes during object creation, after setting all properties.
function edit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit7_Callback(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit7 as text
%        str2double(get(hObject,'String')) returns contents of edit7 as a double


% --- Executes during object creation, after setting all properties.
function edit7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit8_Callback(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit8 as text
%        str2double(get(hObject,'String')) returns contents of edit8 as a double


% --- Executes during object creation, after setting all properties.
function edit8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit9_Callback(hObject, eventdata, handles)
% hObject    handle to edit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit9 as text
%        str2double(get(hObject,'String')) returns contents of edit9 as a double


% --- Executes during object creation, after setting all properties.
function edit9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit10_Callback(hObject, eventdata, handles)
% hObject    handle to edit10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit10 as text
%        str2double(get(hObject,'String')) returns contents of edit10 as a double


% --- Executes during object creation, after setting all properties.
function edit10_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in ROCCurve.
function ROCCurve_Callback(hObject, eventdata, handles)
% hObject    handle to ROCCurve (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
load RocPlotCalculationData.mat Yte Posterior;
FigNum = 392;
RocPlotCalculation(Yte, Posterior(:,2), FigNum);


% --- Executes on button press in Help.
function Help_Callback(hObject, eventdata, handles)
% hObject    handle to Help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
message = sprintf('Please contact via: hoangnhatduc@dtu.edu.vn');
uiwait(msgbox(message));


% --- Executes on button press in About.
function About_Callback(hObject, eventdata, handles)
% hObject    handle to About (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
message = sprintf('BayKdaGmm for Flood Susceptibility Prediction Program Interface');
uiwait(msgbox(message));

% --- Executes on button press in Exit.
function Exit_Callback(hObject, eventdata, handles)
% hObject    handle to Exit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close;
