function GmmClassifierModel = ...
    TrainGmmClassifierFJMethod(DataSet, MaxComp, CovType, Reg)
% Hoang
% Binary classification

if nargin < 4
    DataSet = xlsread('TuongDuongFlood.xlsx');
    MaxComp = 10; % Max. no. of Gaussian mixture components
    CovType = 0; % Full covariance matrix
    Reg = 0.1; % Regularization parameter
end

% Pattern and Class output
X = DataSet(:, 1:end-1);
Y = DataSet(:, end);
% Extract Class-dependent Patterns
Labels = unique(Y);
XC1 = X(Y == Labels(1), :);
XC2 = X(Y == Labels(2), :);
% Prior Probability
PriorC1 = size(XC1, 1)/(size(XC1, 1) + size(XC2, 1));
PriorC2 = size(XC2, 1)/(size(XC1, 1) + size(XC2, 1));
PriorProb = [PriorC1 PriorC2];
%% Fit Model 
% Fit Model 1
BestModelG1 = FitGmmModelFjMethod(XC1, MaxComp, CovType, Reg);
% Fit Model 2
BestModelG2 = FitGmmModelFjMethod(XC2, MaxComp, CovType, Reg);
%%
GmmClassifierModel.GmmC1 = BestModelG1; 
GmmClassifierModel.GmmC2 = BestModelG2; 
GmmClassifierModel.Prior = PriorProb; 
GmmClassifierModel.ClassLabels = Labels; 
end % function [BestModelG1, BestModelG2] = TrainGmmClassifier(DataSet)
