function GmmClassifierModel = TrainGmmClassifierEMMethod(DataSet, MaxComp, ...
    CovType, Reg)
% Hoang Using Matlab toolbox 2012
if nargin < 4
    DataSet = xlsread('TuongDuongFlood.xlsx');
    MaxComp = 10;    
    CovType = 'full'; % 'full' or 'diagonal'
    Reg = 1;
end
% EM method with AIC model selection

% Pattern and Class output
X = DataSet(:, 1:end-1);
Y = DataSet(:, end);
% Extract Class-dependent Patterns
Labels = unique(Y);
XC1 = X(Y == Labels(1), :);
XC2 = X(Y == Labels(2), :);
% Prior Probability
PriorC1 = size(XC1, 1)/(size(XC1, 1) + size(XC2, 1));
PriorC2 = size(XC2, 1)/(size(XC1, 1) + size(XC2, 1));
PriorProb = [PriorC1 PriorC2];
% Set max. number of gaussian components
MaxComponent = MaxComp;
Regularize = Reg;
Options = statset('Display', 'off', 'MaxIter', 3000, 'TolFun', 1e-5);
%% Fit Gmm Model C1
% select a suitable number of components using BIC or AIC
AIC = zeros(1, MaxComponent);
GMModels = cell(1, MaxComponent);

for k = 1 : MaxComponent
    GMModels{k} = gmdistribution.fit(XC1, k, 'CovType', CovType, ...
        'Regularize', Regularize, 'Options', Options);
    AIC(k)= GMModels{k}.AIC;
end
[~, numComponents] = min(AIC);

BestModelG1 = GMModels{numComponents};
%% Fit Gmm Model C2
% select a suitable number of components using BIC or AIC
AIC = zeros(1, MaxComponent);
GMModels = cell(1, MaxComponent);

for k = 1 : MaxComponent
    GMModels{k} = gmdistribution.fit(XC2, k, 'CovType', CovType,...
        'Regularize', Regularize, 'Options', Options);
    AIC(k)= GMModels{k}.AIC;
end
[~, numComponents] = min(AIC);
% numComponents
BestModelG2 = GMModels{numComponents};

%%
GmmClassifierModel.GmmC1 = BestModelG1; 
GmmClassifierModel.GmmC2 = BestModelG2; 
GmmClassifierModel.Prior = PriorProb; 
GmmClassifierModel.ClassLabels = Labels; 
end % function [BestModelG1, BestModelG2] = TrainGmmClassifier(DataSet)
