function BayGmmKdaModel = TrainBayGmmKdaEM(DataSet, MaxComp, CovType,...
    Reg, KerPar)
% Hoang
% Train Bayesian Gmm with KFDA and FJ training method for GMM

if nargin < 5
    DataSet = xlsread('TuongDuongFlood.xlsx');
    MaxComp = 10; % Max. no. of Gaussian mixture components
    CovType = 'full'; % Full covariance matrix
    Reg = 1; % Regularization parameter
    KerPar = 5;    
end % if nargin < 5

Xtr = DataSet(:, 1:end-1);
Ytr = DataSet(:, end);
KfdaModel = TrainKFDA(Xtr, Ytr, KerPar);
IllusOpt = 0; % Illustrating KFDA data projection
Xtrkfda_Normalized = PredictKFDA(Xtr, KfdaModel, IllusOpt);
Xnew = [Xtr Xtrkfda_Normalized];

DataSetNew = [Xnew Ytr];

BayGmmKdaModel = ...
    TrainGmmClassifierEMMethod(DataSetNew, MaxComp, CovType, Reg);
BayGmmKdaModel.KerPar = KerPar;
BayGmmKdaModel.Reg = Reg;
BayGmmKdaModel.KfdaModel = KfdaModel;
end % function BayGmmKdaModel = TrainBayGmmKdaFJ(DataSet, MaxComp, CovType, Reg, KerPar)

