function ScatterPlotSingleVariable(DataSet, FigNum, ...
    Convert2Cate, ClassLabels)
% Hoang
if nargin < 4
%    DataSet = csvread('LandslideLaoCai.csv'); % % Convert2Cate = 0;   
   DataSet = xlsread('TuongDuongFlood'); % Convert2Cate = 1;   
   FigNum = 1;
   Convert2Cate = 1;
   ClassLabels = {'No-flood','Flood'};
end
% Modify the code if numvar > 10
RawDataSet = DataSet; 
RawX = RawDataSet(:,1:end-1);
RawY = RawDataSet(:,end);

if Convert2Cate == 1
    [m n] = size(RawX);
DatawClass = zeros(m,n);
for v = 1 : n
    Xv = RawX(:,v);
    XvClass = unique(Xv);
    XvNumClass = length(XvClass);
    Xvc = zeros(length(XvClass),1);
    for i = 1 : length(Xv)
        for j = 1 : XvNumClass
            if Xv(i) == XvClass(j)
                Xvc(i) = j;
            end %  
        end    
    end % for i = 1 : length(Xv)
    
    DatawClass(:,v) = Xvc;    
end % for v = 1 : n
end % if Convert2Cate == 1

if Convert2Cate == 0
    DatawClass = RawX;
end

%% Draw
figure(FigNum);
set(gcf,'color','white');
X = DatawClass;
Y = RawY;
ClassLabel = unique(Y);
NumVar = size(X, 2);
RowPlot = 2;
ColPlot = NumVar/2;
for i = 1 : NumVar
   Xi =  X(:,i);
   XiC1 = Xi(Y == ClassLabel(1),:);
   XiC2 = Xi(Y == ClassLabel(2),:);
   subplot(RowPlot,ColPlot,i);
   plot(XiC1, 'r<', 'MarkerSize', 5, 'MarkerFaceColor', 'r'); hold on;
   plot(XiC2, 'bo', 'MarkerSize', 5, 'MarkerFaceColor', 'b'); 
   if i < 10
   title(['IF_' num2str(i)]);
   end
   if i == 10
   title('IF_1_0');    
   end
   xlabel('Data Sample'); ylabel('Factor Category');
end % for i = 1 : DimData
legend(ClassLabels);

end % function SingleVariableScatterPlot(DataSet, FigNum, Convert2Cate)
