function [AUC FPRpool TPRpool] = RocPlotCalculation(Ya, Pp, FigNum)
% Hoang
% Computing are under the ROC curve
% Ya is actual class label
% Pp is probability of positive class
% FigNum is figure number
if nargin < 3
   Ya  = [+1 +1 +1 +1 +1 -1 -1 -1 -1 -1 +1 -1 1 -1 +1 -1];   
   Pp  = [0.4 0.7 0.8 0.9 0.6 0.4 0.3 0.2 0.1 0.6 0.4...
       0.6 0.9 0.25 0.88 0.15];   
   FigNum = 1;
end
Classes = unique(Ya);
Pos = Classes(2); 
Neg = Classes(1);
Tpool = linspace(0,1,30);
FPRpool = zeros(1, length(Tpool));
TPRpool = zeros(1, length(Tpool));

for t = 1 : length(Tpool)    
    T = Tpool(t);
    NumData = length(Pp);
    Yp = zeros(1, NumData);
    for i = 1 : NumData
        if Pp(i) > T
            Yp(i) = Pos;
        else
            Yp(i) = Neg;
        end
    end
    [TPR, FPR, ~, ~] = ConfusionMatrix(Ya, Yp, Pos, Neg);
    FPRpool(t) = FPR;
    TPRpool(t) = TPR;
end

AUC = abs(trapz(FPRpool, TPRpool));

if FigNum > 0
    figure(FigNum);
    plot(FPRpool, TPRpool, 'b-', 'LineWidth',3);
    title(['AUC = ' num2str(AUC, 2)]);
    xlabel(' False Positive Rate (FPR)'); ylabel('True Positive Rate (TPR)')
    set(gca,'XTick',(0:0.1:1));
    set(gca,'YTick',(0:0.1:1));
end
end