function [ClassResult, Posterior] = ...
    PredictGmmClassifier(InputPattern, GmmClassifierModel)
% Hoang
% Prediction with BayesGmm
if nargin < 2
    DataSet = xlsread('TuongDuongFlood.xlsx');
    InputPattern = DataSet(:, 1:end-1);
    GmmClassifierModel = TrainGmmClassifierFJMethod(DataSet);
end

PriorG1 = GmmClassifierModel.Prior(1);
PriorG2 = GmmClassifierModel.Prior(2);

% Likelihood
LH_G1 = pdf(GmmClassifierModel.GmmC1, InputPattern) + 1e-10;
LH_G2 = pdf(GmmClassifierModel.GmmC2, InputPattern) + 1e-10;

% Denominator
DeN = PriorG1*LH_G1 + PriorG2*LH_G2;

% Posterior
PosG1 = PriorG1*LH_G1./DeN;
PosG2 = PriorG2*LH_G2./DeN;
Posterior = [PosG1 PosG2];

% Result
ClassResult = zeros(size(InputPattern, 1), 1);
ClassResult(PosG1 >= PosG2) = GmmClassifierModel.ClassLabels(1);
ClassResult(PosG1 < PosG2) = GmmClassifierModel.ClassLabels(2);

end % function [ClassResult, Posterior] = PredictGmmClassifier(InputPattern, GmmClassifierModel)
