function [ClassResult, Posterior] = ...
    PredictBayGmmKdaClassifier(Xte, BayGmmKdaModel)

% Hoang
% Prediction with BayesGmmKda

if nargin < 2
    DataSet = xlsread('TuongDuongFlood.xlsx');
    Xte = DataSet(:, 1:end-1);
    % TrainBayGmmKdaEM
%     MaxComp = 10;
%     CovType = 0;
%     Reg = 1;
%     KerPar = 5;
%     BayGmmKdaModel = TrainBayGmmKdaFJ(DataSet, MaxComp, CovType,...
%     Reg, KerPar);
    
    % TrainBayGmmKdaEM
    MaxComp = 10; % Max. no. of Gaussian mixture components
    CovType = 'full'; % Full covariance matrix
    Reg = 1; % Regularization parameter
    KerPar = 5;    
    BayGmmKdaModel = TrainBayGmmKdaEM(DataSet, MaxComp, CovType,...
    Reg, KerPar);
end

KfdaModel = BayGmmKdaModel.KfdaModel;
IllusOpt = 0; % Illustrating KFDA data projection
Xtekfda_Normalized = PredictKFDA(Xte, KfdaModel, IllusOpt);
Xtenew = [Xte Xtekfda_Normalized];

[ClassResult, Posterior] = ...
    PredictGmmClassifier(Xtenew, BayGmmKdaModel);
end % function [ClassResult, Posterior] = PredictGmmClassifier(InputPattern, GmmClassifierModel)
