function [MI Result] = MutualInfoForClass(Data)
% Hoang
% Analysing features with mutual information
if nargin < 1
    Data = xlsread('AlgalApperance12IFClass510.xlsx');
end
Y = Data(:,end);

DataC1 = Data(Y == -1, :);
DataC1= DataNormalizeMatrixForClass(DataC1);

DataC2 = Data(Y == +1, :); 
DataC2= DataNormalizeMatrixForClass(DataC2);

InputDataC1 = [DataC1(:, 1:end-1)]; 
InputDataC2 = [DataC2(:, 1:end-1)]; 
OutputDataC1 = [DataC1(:, end)];
OutputDataC2 = [DataC2(:, end)];
%%
length(OutputDataC1);
length(OutputDataC2);
P_C1 = length(OutputDataC1)/(length(OutputDataC1) + length(OutputDataC2));
P_C2 = length(OutputDataC2)/(length(OutputDataC1) + length(OutputDataC2));
H_C = -( P_C1*log2(P_C1)+P_C2*log2(P_C2) );
%%
h1 = 0.1;
h2 = 0.1;

X = [InputDataC1; InputDataC2];
NumofData = size(X, 1);
NumofFeature = size(X, 2);
H_C_X = zeros(1, NumofFeature);
for Feature = 1 : NumofFeature;
% Feature
XFeature = X(:, Feature);
InputDataC1Feature = InputDataC1(:, Feature);
InputDataC2Feature = InputDataC2(:, Feature);
% idx = 12;
SS = 0;
% size(X,1)
for idx = 1 : size(XFeature,1)
    
Xi = XFeature(idx);
P_Xi_C1 = GaussKerDenEst(Xi, InputDataC1Feature, h1);
P_Xi_C2 = GaussKerDenEst(Xi, InputDataC2Feature, h2);

P_X = P_C1*P_Xi_C1 + P_C2*P_Xi_C2;

P_C1_X = P_Xi_C1*P_C1/P_X;
P_C2_X = P_Xi_C2*P_C2/P_X;

if P_C1_X == 0
    P_C1_X = 0.000001;
end

if P_C2_X == 0
    P_C2_X = 0.000001;
end

Sigma = (P_C1_X*log2(P_C1_X) + P_C2_X*log2(P_C2_X))/NumofData;

% SS = SS + P_X*Sigma;
SS = SS + 1*Sigma;
end

H_C_X(Feature) = -SS;

end % end features

MI = H_C - H_C_X';

% Fidx = 1 : size(X,2);
[SortedMI, SortedIdx] = sort(MI, 'descend');
MI
SortedMI
SortedIdx

NormalizedSortedMI = SortedMI*100/sum(SortedMI)

Result.MI = MI;
Result.SortedMI = SortedMI;
Result.SortedFidx = SortedIdx;

end

function f = GaussKerDenEst(X, Sample, h)
% Estimate density using Gaussian Kernel.
% Hoang.
% h should be automatically determined from the Sample. But how?
if nargin < 3
    X = rand(1, 3);
    Sample = randn(10, 3);
    h = 1;
end
N = size(Sample, 1);
D = size(Sample, 2);

if size(Sample, 2) ~= size(X, 2)
    disp('Dimension mismatches');
end

Xrep = repmat(X, N, 1);
a = GaussKernel((Xrep-Sample)/h);
b = 1/(N*(h^D));
f = b*sum(a);
end

function f = GaussKernel(x)
% Computing Gaussian Kernel for Kernel Density Estimation
% Hoang.
if nargin < 1
    x = rand(10,2);
end
% x must be 1xD
D1 = size(x,1);
D2 = size(x,2);
K = zeros(D1, 1);
for i = 1:D1
    a = (2*pi)^(-D2/2);
    xi = x(i,:);
    b = exp(-0.5*(xi*xi'));
    K(i) = a*b;
end
f = K;
end