function KfdaModel = TrainKFDA(Xtr, Ytr, KerPar)
% Train Kernel Fisher Dis Analysis model
% Hoang
if nargin < 3
    InputData = xlsread('SoilLiquefaction185.xlsx');
    Xtr = InputData(:,1 : end-1);
    Ytr = InputData(:, end);   
    KerPar = 1;
end

options.KernelType = 'Gaussian';
options.t = KerPar;
[eigvector, ~] = KDA(options, Ytr, Xtr);

KfdaModel.eigvector = eigvector;
KfdaModel.Xtr = Xtr;
KfdaModel.Ytr = Ytr;
KfdaModel.KerPar = KerPar;

end % function KfdaModel = TrainKFDA(Xtr, Ytr, KerPar)