function Xtekfda_Normalized = PredictKFDA(Xte, KfdaModel, IllusOpt)
% Mapping data using Kernel Fisher Dis Analysis model
% Hoang
if nargin < 3
    InputData = xlsread('SoilLiquefaction185.xlsx');
    Xtr = InputData(:,1 : end-1);
    Ytr = InputData(:, end); 
    KerPar = 50;  
    KfdaModel = TrainKFDA(Xtr, Ytr, KerPar) ;
    Xte = Xtr;   
    IllusOpt = 1;
end % if nargin < 3

options.KernelType = 'Gaussian';
options.t = KfdaModel.KerPar;

Xtr = KfdaModel.Xtr ;

eigvector = KfdaModel.eigvector;

Ktest = constructKernel(Xte, Xtr, options);
Xtekfda = Ktest*eigvector;

Ktrain = constructKernel(Xtr, Xtr, options);
Xtrkfda = Ktrain*eigvector;

NumXtr = size(Xtr, 1);
DataKfda = [Xtrkfda; Xtekfda];
[NormalizeDataKfda, ~, ~]= DataNormalizeMatrixForReg(DataKfda);
Xtekfda_Normalized = NormalizeDataKfda(NumXtr+1:end, :);

if IllusOpt == 1
    Labels = unique(KfdaModel.Ytr);
    C1 = Labels(1);
    C2 = Labels(2);
    XpC1 = Xtekfda_Normalized(KfdaModel.Ytr==C1, :);
    XpC2 = Xtekfda_Normalized(KfdaModel.Ytr==C2, :);
    figure(1);   
    plot((XpC1), 'r*'); hold on;
    plot((XpC2), 'bo');    
    legend({'C1=Neg','C2=Pos'});
    xlabel('Data Point'); ylabel('Projected Output');
end

end % function Xte_mapped = MapKDA(Xte, Xtr, eigvector, KerPar)
