function FrequencyCateFeatureInspect(DataSet, FeaIdx, FigNum)
% Hoang
if nargin < 3
    DataSet = csvread('LandslideLaoCai.csv');
    FeaIdx = 10;
    FigNum = 1;
end % if nargin < 3

Cate = unique(DataSet(:, FeaIdx));
NumX = size(DataSet, 1);

CateCount = zeros(1, length(Cate));

for i = 1 : NumX
    for j = 1 : length(Cate)
        if DataSet(i, FeaIdx) == Cate(j)
           CateCount(j) = CateCount(j) + 1;  
        end            
    end % for j = 1 : length(Cate)        
end % for i = 1 : NumX

FreqCate = CateCount/sum(CateCount);
XLabel = ['Category of IF' num2str(FeaIdx)];
YLabel = 'Frequency';
YRange = 0:0.1:max(FreqCate)*1.5;
IF_Seq = 1 : CateCount;
NumX = size(IF_Seq, 2);
RealXLabelsInput = cell(1, NumX);
for k = 1 : NumX
    RealXLabelsInput{k} = num2str(IF_Seq(k));
end
BarPlot(FreqCate, FigNum, XLabel, YLabel, YRange, RealXLabelsInput);

end % function FrequencyFeatureInspect(DataSet, FeaIdx, FigNum)
