function FittedGmModel = FitGmmModelFjMethod(X, MaxComp, CovType, Reg)
% Hoang
% Density Estimation with GMM-FJ method
if nargin < 4
    DataSet = xlsread('TuongDuongFlood.xlsx');
    X = DataSet(:, 1:end-1);
    MaxComp = 20;
    CovType = 0;
    Reg = 0.1;
end

MinNumComp = 1;
MaxNumComp = MaxComp;
Regularize = Reg;
TheTa = 1e-5;
Covoption = CovType; % 0: free covariances; 1 : diagonal covariances

[~,bestpp,bestmu,bestcov,~,~] = mixtures4(X,MinNumComp, ...
    MaxNumComp, Regularize, TheTa, Covoption);

FittedGmModel = gmdistribution(bestmu, bestcov, bestpp);

end % function FittedGmModel = FitGmmModelFjMethod(X)
