function NormalizedFOSIPercent = FastImplementation(NoFeature, ModelFun)
% Feature Importance Evaluation with FAST
if nargin < 2
    NoFeature = 3;
    ModelFun = 'PseudoModel';   
end

% Step 1: set paths
my_dir = pwd ; % use the 'pwd' command if you have already setup the Matlab
% Set current directory to 'my_dir' and add path to sub-folders:
cd(my_dir)
addpath(genpath(my_dir))
% Step 2: setup the model and define input ranges
% Number of uncertain parameters subject to SA:
M = NoFeature; 
% Parameter ranges (from literature):
xmin = zeros(1, NoFeature);
xmax = ones(1, NoFeature);
% Parameter distributions:
DistrFun  = 'unif'  ; 
DistrPar = cell(M,1); 
for i=1:M; DistrPar{i} = [ xmin(i) xmax(i) ] ; end
% Name of parameters (will be used to costumize plots):
% X_labels = FeatureLabels; 
% Define output:
myfun = ModelFun;
% Step 3: approximate first-order sensitivity indices by FAST
% FAST sampling:
[X,s] = FAST_sampling(DistrFun,DistrPar,M);
% Run the model and compute model output at sampled parameter sets:
Y = model_evaluation(myfun,X);
% Estimate indices: 
Si_fast = FAST_indices(Y,M);
% Step 4: Convergence analysis
N_fast = length(Y);
% We can now assess whether FAST estimates would change if using a larger
% number of samples:
NNfast = [N_fast:1000:N_fast+3000];
Si_fast_conv = nan(length(NNfast),M) ;
Si_fast_conv(1,:) = Si_fast ;
for n=2:length(NNfast)
    [Xn,~] = FAST_sampling(DistrFun,DistrPar,M,NNfast(n));
    Yn = model_evaluation(myfun,Xn) ;
    Si_fast_conv(n,:) = FAST_indices(Yn,M) ;
end

FOSI = Si_fast_conv(end,:);
NormalizedFOSIPercent = FOSI*100/sum(FOSI);
NormalizedFOSIPercent = NormalizedFOSIPercent';
% Plot results:
% figure(1);
% plot_convergence(Si_fast_conv,NNfast,[],[],[],'model evals','1st-order sensitivity',X_labels)
end