function DatawClass = ConvertReal2Cate(DataSet)
% Hoang
% Convert real values to categories
if nargin < 1
   DataSet = xlsread('TuongDuongFlood');    
end % if nargin < 1
RawDataSet = DataSet; 
RawX = RawDataSet(:,1:end-1);

[m n] = size(RawX);
DatawClass = zeros(m,n);
for v = 1 : n
    Xv = RawX(:,v);
    XvClass = unique(Xv);
    XvNumClass = length(XvClass);
    Xvc = zeros(length(XvClass),1);
    for i = 1 : length(Xv)
        for j = 1 : XvNumClass
            if Xv(i) == XvClass(j)
                Xvc(i) = j;
            end %  
        end    
    end % for i = 1 : length(Xv)
    
    DatawClass(:,v) = Xvc;    
end % for v = 1 : n

end % function f = ConvertReal2Cate(Data)