function [TPR, FPR, FNR, TNR]= ConfusionMatrix(Yte, Ytep, Pos, Neg)
% Hoang
if nargin < 4
    Yte =  [ 1 1 1 1 -1 1  1 -1];
    Ytep = [-1 1 1 1  1 1 -1 -1];
    Pos =  1;
    Neg = -1;
end
CM = zeros(2,2);
ny = length(Yte);

for i = 1 : ny
    if Yte(i) == Pos && Ytep(i) == Pos
        CM(1,1) =  CM(1,1) + 1;
    end
    if Yte(i) == Neg && Ytep(i) == Pos
        CM(1,2) =  CM(1,2) + 1;
    end
    if Yte(i) == Pos && Ytep(i) == Neg
        CM(2,1) =  CM(2,1) + 1;
    end
    if Yte(i) == Neg && Ytep(i) == Neg
        CM(2,2) =  CM(2,2) + 1;
    end
end
% disp(CM);
TP = CM(1,1); FP = CM(1,2);
TN = CM(2,2); FN = CM(2,1);

TPR = TP/(TP+FN);
FPR = FP/(FP+TN);
FNR = FN/(TP+FN);
TNR = TN/(TN+FP);

end % function [TPR, FPR, FNR, TNR]= ConfusionMatrix(Yte, Ytep, Pos, Neg)
