function BarPlot(Data, FigNum, XLabel, YLabel, YRange, RealXLabelsInput)
% Hoang
% YRange describe interval of Y
if nargin < 6
%     Data = [0.82 0.88 0.85 0.91];
% YRange = 0.5:0.1:max(Data)*1.2; 

    Data = [80.64 85.26 82.31 87.76];  
    YRange = 50:10:max(Data)*1.2; 
    FigNum = 1;
    YLabel = 'CAR(%)';
    XLabel = 'Model';      
    
%     IF_Seq = [2	8 1	7 9	10 11 12 4 3 6 5];
%     
%     NumX = size(IF_Seq, 2);
%     RealXLabelsInput = cell(1, NumX);
%     for k = 1 : NumX
%         RealXLabelsInput{k} = num2str(IF_Seq(k));
%     end
RealXLabelsInput = {'BPNN', 'SVM', 'ANFIS', 'ANFIS-ESM'};
end % if nargin < 6

[md, ~] = size(Data);
if md == 1
    Data = Data';
end
% Note: Data must be column vector.
figure(FigNum);
X = 1:length(Data);

H=bar(X, Data);
% grid on;
set(H,'FaceColor',[1,1,5]*0.1,'LineWidth',1) 
xlabel(XLabel); ylabel(YLabel);
set(gca, 'YTick', YRange);
text(X,Data,num2str(Data, 5),...
    'HorizontalAlignment','center',...
    'VerticalAlignment','bottom');
ylim([YRange(1) YRange(end)]);

set(gca, 'XTick', 1:12, 'XTickLabel', RealXLabelsInput);
end % function BarPlot(Data, FigNum, YLabel)