MODULE variables
 IMPLICIT NONE
 !variables for the main loop in the program sensitivity_evuot95
 !help variables for the program
 INTEGER :: stat,i,j,k,f
 REAL :: mod_res
 !---------- input variables to the subroutine do_evuot_d ----------
 !variables in the input file that are not needed but passed to the function anyway
 REAL :: CFNR=-9.9,CFST=-9.9,CFVU=2079.0,CFKU=12.0,CFPV=28.0, &
	 CFKL=1200.0,CFPR=-9.9,CFUU=-9.9,CFSU=-9.9,CFNN=-9.9, &
	 CFTD=-9.9,CFTW=-9.9,CFRR=-9.9,CFVV=-9.9,CFWW=-9.9, &
         CFW1=-9.9,CFW2=-9.9,CFCL=-9.9,CFCM=-9.9,CFCH=-9.9, &
	 CFDD=-9.9,CFAP=-9.9

 !This does nothing in the subroutine do_evuot_d at the moment (no table lookup) but passed to it anyway.
 REAL, DIMENSION(10) :: ALB    

 !The artificial input data : albedo cloudCover cloudHeight moistureParameter solarRadiation temperature windSpeed z0
 REAL :: CFAB,CFNH,CFHH,CFAL,CFAS,CFT2,CFUA,CZ0

 !---------- additional variables needed by do_evuot_d ----------
 !         1     2     3     4     5     6     7     8   9    10   11
 REAL :: cft2d,cfnhd,cfhhd,cfuad,cfabd,cfasd,cfald,clad,clod,cz0d,chud
! INTEGER, DIMENSION(8) :: pick_jacobian_data
! DATA pick_jacobian_data/1,2,3,4,5,6,7,10/

 !make the real variables point to the jacobian_help vector for easier manipulaiton
 COMMON  cft2d,cfnhd,cfhhd,cfuad,cfabd,cfasd,cfald,clad,clod,cz0d,chud
 REAL :: jacobian_helper(11)=0
 !jacobian_helper(1) == cft2d, jacobian_helper(2) == cfnhd, and so on...
 EQUIVALENCE (jacobian_helper(1),cft2d)
 REAL :: jacobian(10,11)

 !---------- constants in this run, normaly read from a 'control file' ----------
 !control file data, these are also passed to do_evuot_d
 REAL :: CLA=60.30,CLO=24.85,CHU=10.0

 !---------- variables returned by do_evuot_d ----------
 !results that are returned by do_evuot_d
 REAL, DIMENSION (10) :: res, resd

 !---------- header strings for the output files ----------
 CHARACTER (len=30), dimension(11) :: info
 DATA info/'temperature','cloudCover','cloudHeight','windSpeed','albedo','solarRadiation',&
	   'moistureParameter','latitude','longitude','z0','measurementHeight'/
 CHARACTER (len=6), dimension(11) :: names
 
 !---------- file names for the output files ----------
 CHARACTER (len=30), dimension(10) :: file_name
 DATA file_name/'albedo.dat','solarElevation.dat','solarRadiation.dat','moisture_parameter.dat',&
		'obukhov_length.dat','temperature_scale.dat','friction_velocity.dat','sensible_heat_flux',&
		'net_radiation.dat','latent_heat_flux.dat'/

 !logical variable for overwriting existing files
 LOGICAL :: over_write=.TRUE.

 REAL, DIMENSION(36) :: output_data
 !header string
 CHARACTER(LEN=101) :: header

END MODULE variables
