PROGRAM sensitivity_evuot95
 USE variables
 IMPLICIT NONE
 CHARACTER (len=70), dimension(2) :: input_file
 !input data files
 DATA input_file/'../input/variable_range.txt','../input/variable_range_ws.txt'/

 !loop through the input files
 DO f=1,SIZE(input_file)
	WRITE(*,*) TRIM(input_file(f)),SIZE(input_file)
 	OPEN(200,FILE=TRIM(input_file(f)),ACTION='read')
 	READ(200,'(A)',IOSTAT=stat) header
 	write(*,*) header
 	k=1
 	DO	!read the input parameters
	 	READ(200,*,IOSTAT=stat) CFAB,CFNH,CFHH,CFAL,CFAS,CFT2,CFUA,CZ0

	 	!break the loop when you've reached the end of the input file
	 	IF (stat /= 0) EXIT

	 	!print every 1000th line so you know where you are
	 	IF (MOD(k,1000) .EQ. 0) THEN
			WRITE(*,FMT='(A,I10,8F10.2)') 'Line:',k,CFAB,CFNH,CFHH,CFAL,CFAS,CFT2,CFUA,CZ0
	 	END IF

		!construct the full Jacobian column by column
	 	DO i=1,11
			!zero all variables cft2d ... chud (variables in jacobian_helper correspond to the equivalent variables 
			!named cft2d ... chud)

	        	!jacobian_helper is the "seeding vector" used to construct the jacobian one column at a time.
	 		jacobian_helper = 0
			jacobian_helper(i) = 1
		
			!call the function that calculates the results and the derivatives
			CALL DO_EVUOT_D(cfnr, cfst, cfvu, cfku, cfpv, cfkl, cfpr, cft2,cft2d, cfuu, cfsu, cfnn, cftd, &
			                cftw, cfrr, cfvv, cfww, cfw1, cfw2, cfnh, cfnhd, cfcl, cfhh, cfhhd, cfcm, &
	        		        cfch, cfdd, cfua, cfuad, cfap, cfab, cfabd, cfas, cfasd, cfal, cfald, alb, & 
			                cla, clad, clo, clod, cz0, cz0d, chu, chud, res, resd)

			!put the results in the correct Jacobian column
			jacobian(:,i) = resd
	 	END DO

         	!do also write the "standard" data to a file
	 	output_data = (/ FLOAT(k),CFST,CFVU,CFKU,CFPV,CFKL,CFPR,CFT2, &
                	          CFUU,CFSU,CFNN,CFTD,CFTW,CFRR,CFVV,CFWW, &
                	          CFW1,CFW2,CFNH,CFCL,CFHH,CFCM,CFCH,CFDD, &
                	          CFUA,CFAP,res /)
		!subroutine to write the data to files         
         	CALL save_data(info,file_name,jacobian,over_write,output_data,k,f)

	 	!set to False after the first write
	 	over_write = .FALSE.

		!reset the jacobian just to be safe (should not be needed, though)
		jacobian = 0
        
		!increment row
        	k=k+1
 	END DO
 	CLOSE(200)
	WRITE(*,*) 'Read ', k-1 ,' lines'
	over_write = .TRUE.
 END DO
END PROGRAM sensitivity_evuot95

!Makefile 
!all:
!	f95 variables.f95 salfa_d.f95 clrad_d.f95 dpls_d.f95 dpll_d.f95 do_evuot_d.f95 save_data.f95 sensitivity_evuot95.f95 -o sensitivity.out


