!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.10 (r5717) - 30 Jul 2015 16:03
!
!  Differentiation of salfa in forward (tangent) mode:
!   variations   of useful results: cfak
!   with respect to varying inputs: plat ppit
!END OF the acutal subroutine that does the work <---------------------
!OTHER SUBROUTINES
SUBROUTINE SALFA_D(ivv, ikk, ipa, iklo, plat, platd, ppit, ppitd, ppp, &
& sinal, sinfii, cosfii, cfak, cfakd)
  IMPLICIT NONE
!input variables
  INTEGER, INTENT(IN) :: ivv, ikk, ipa, iklo
  REAL, INTENT(IN) :: plat, ppit
  REAL, INTENT(IN) :: platd, ppitd
!output variables
  REAL, INTENT(OUT) :: ppp, sinal, sinfii, cosfii, cfak
  REAL, INTENT(OUT) :: cfakd
!local variables
  INTEGER, DIMENSION(12) :: ipaiv
  INTEGER :: ipv
  REAL :: rad, rlat, rpv, s, decl, rdecl, pp, rl, dklo, h, hh
  REAL :: rlatd, rld, hd, hhd
  INTRINSIC MOD
  INTRINSIC REAL
  INTRINSIC SIN
  INTRINSIC COS
  INTRINSIC SQRT
  INTRINSIC ASIN
  REAL :: arg1
  REAL :: arg2
  REAL :: result1
  REAL :: result1d
  REAL :: arg10
  REAL :: pppd
  REAL :: sinald
!days passed when the month changes
  ipaiv = (/0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334/)
!radians / degrees
  rad = 0.0174522925
!latitude to radians
  rlatd = rad*platd
  rlat = rad*plat
!leap year check
  ipv = ipa + ipaiv(ikk)
  IF (ikk .GE. 3 .AND. MOD(ivv, 4) .EQ. 0) ipv = ipv + 1
!day to float
  rpv = REAL(ipv)
  s = 0.0171672
!declination in degrees
  decl = 0.33281 + 3.7872*SIN(s*rpv) - 22.984*COS(s*rpv)
!declination in radians
  rdecl = rad*decl
  arg1 = 2.0*s*rpv
  arg2 = 2.0*s*rpv
  pp = -(0.1229*SIN(s*rpv)) + 0.0072*COS(s*rpv) - 0.1565*SIN(arg1) - &
&   0.0528*COS(arg2)
  rld = -(24.0*ppitd/360.0)
  rl = 24.0/360.0*(30.0-ppit)
  pppd = -rld
  ppp = pp - rl
  dklo = REAL(iklo-iklo/100*100)/60.0 + REAL(iklo/100)
  hd = 360.0*pppd/24.0
  h = 360.0/24.0*(dklo-12.0+ppp)
  hhd = rad*hd
  hh = rad*h
  sinald = SIN(rdecl)*rlatd*COS(rlat) + COS(rdecl)*(-(rlatd*SIN(rlat)*&
&   COS(hh))-COS(rlat)*hhd*SIN(hh))
  sinal = SIN(rdecl)*SIN(rlat) + COS(rdecl)*COS(rlat)*COS(hh)
  arg1 = 1.0 - sinal**2
  result1 = SQRT(arg1)
  sinfii = COS(rdecl)/result1*SIN(hh)
  arg10 = 1 - sinal**2
  result1 = SQRT(arg10)
  cosfii = (sinal*SIN(rlat)-SIN(rdecl))/(result1*COS(rlat))
!solar elevation in degrees
  IF (sinal .EQ. 1.0 .OR. sinal .EQ. (-1.0)) THEN
    result1d = 0.0
  ELSE
    result1d = sinald/SQRT(1.0-sinal**2)
  END IF
  result1 = ASIN(sinal)
  cfakd = 57.29578*result1d
  cfak = result1*57.29578
END SUBROUTINE SALFA_D
