!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.10 (r5717) - 30 Jul 2015 16:03
!
!  Differentiation of dpls in forward (tangent) mode:
!   variations   of useful results: cfh0 cftt cfqt cfut cfle deltatheta
!   with respect to varying inputs: cfal cf0 cf2 cf3 cfua cz0 cft2
!                chu pl
!stable
SUBROUTINE DPLS_D(pl, pld, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d&
& , cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, cfutd, cfqt, &
& cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, deltatheta, deltathetad)
  IMPLICIT NONE
!input
  REAL, INTENT(IN) :: pl, cz0, chu, cfua, cf0, cf2, cf3, cft2, cfal
  REAL, INTENT(IN) :: pld, cz0d, chud, cfuad, cf0d, cf2d, cf3d, cft2d, &
& cfald
!output
  REAL, INTENT(OUT) :: cfut, cfqt, cftt, cfh0, cfle, deltatheta
  REAL, INTENT(OUT) :: cfutd, cfqtd, cfttd, cfh0d, cfled, deltathetad
!local
  REAL :: a, b, c, d, tr, t0, g
  REAL :: ad, bd, cd, dd, trd, t0d, gd
  INTRINSIC EXP
  REAL :: arg1
  REAL :: arg1d
  REAL :: arg2
  REAL :: arg2d
!Below Eq. 1 in Karppinen et al. 1997
!A=psi_m(z_0/L)-psi_m(z/L)
  arg1d = -(.29*(cz0d*pl+cz0*pld))
  arg1 = -(.29*cz0*pl)
  arg2d = -(.29*(chud*pl+chu*pld))
  arg2 = -(.29*chu*pl)
  ad = 17.0*(arg1d*EXP(arg1)-arg2d*EXP(arg2))
  a = 17.0*(EXP(arg1)-EXP(arg2))
!Equation 9b in van Ulden and Holtslag 1985
!B = -psi_h(z=48,L) = 5*z/L = 5*48/L = 240*1/L
  bd = 240.0*pld
  b = 240.0*pl
!Equation 9b in van Ulden and Holtslag 1985
!C = -psi_h(z=50,L) = 5*z/L = 5*50/L = 250*1/L
  cd = 250.0*pld
  c = 250.0*pl
!Equation 8 in van Ulden and Holtslag 1985 for u*
!u* = k*U(z)/(ln(z/z0)+psi_m(z_0/L)-psi_m(z/L))
  cfutd = (.4*cfuad*(cf0+a)-.4*cfua*(cf0d+ad))/(cf0+a)**2
  cfut = .4*cfua/(cf0+a)
!D = u*²/(L*g*k*k) = theta*/(k*TR), Note: PL = 1/L
  dd = ((cfutd*cfut+cfut*cfutd)*pl+cfut**2*pld)/1.5696
  d = cfut*cfut*pl/1.5696
  trd = (cft2d*(1.0-d*(3.218875825+b))-(cft2-0.48)*(-(dd*(3.218875825+b)&
&   )-d*bd))/(1.0-d*(3.218875825+b))**2
  tr = (cft2-0.48)/(1.0-d*(3.218875825+b))
  t0d = trd - (trd*d+tr*dd)*(12.+c) - tr*d*cd
  t0 = tr - tr*d*(12.+c) + 0.5
!Eq. 21 from van Ulden and Holtslag 1985
!T0**4 and TR**6 for easier reading. This gives the same result as in the F77 version of EVUOT to the 4th decimal
  cfqtd = cf2d - .567*(4*t0**3*t0d-.935*6*tr**5*trd/100000.0)/10000000.0
  cfqt = cf2 - .567*(t0**4-.935*tr**6/100000.0)/10000000.0
!ground flux estimated from the temperature difference between TR and T0
  gd = -(5.0*(trd-t0d))
  g = -(5.0*(tr-t0))
!solve theta* from van Ulden and Holtslag 1985 Eq. 6 -->
!theta* = TR*u*²/(k*g*L), CFTT = k * u*²/(L*g*k*k) * TR = TR*u*²/(L*g*k) = theta* (temperature scale)
  cfttd = .4*(dd*tr+d*trd)
  cftt = .4*d*tr
!rho(T2) = rho_ref*T_ref/T2
!349477.0 = T_ref ~ 288 K and rho ref ~ 1.2 kg/m³ and c_p ~ 1011 kJ/(kg*K)
!CFH0 = rho(T) * c_p * theta* * u*, Eq. 5 in van Ulden and Holtslag 1985
  cfh0d = -((349477.0*(cfttd*cfut+cftt*cfutd)*cft2-349477.0*cftt*cfut*&
&   cft2d)/cft2**2)
  cfh0 = -(349477.0*cftt*cfut/cft2)
!lambdaE = Q_E = Q*-G-H_0, Eq. 10 in van Ulden and Holtslag 1985
  cfled = cfqtd - gd - cfh0d
  cfle = cfqt - g - cfh0
!deltaTheta = theta* - (aS/(S+1)-1)(Q*-G)/(rho*c_p*u*)-theta_d*a: the right hand term is Eq. 6 in Karppinen 
!et al. 1997. CF3 = (aS/(S+1)-1)/(rho(T)*c_p)
!deltaTheta is the difference between the temperature scale calculated from the energy budget equations 
!and using the "profile method". The iteration is done by changing 1/L.
  deltathetad = cfttd - ((cf3d*(cfqt-g)+cf3*(cfqtd-gd))*cfut-cf3*(cfqt-g&
&   )*cfutd)/cfut**2 - .033*cfald
  deltatheta = cftt - cf3*(cfqt-g)/cfut - .033*cfal
END SUBROUTINE DPLS_D
