!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.10 (r5717) - 30 Jul 2015 16:03
!
!  Differentiation of dpll in forward (tangent) mode:
!   variations   of useful results: cfh0 cftt cfqt cfut cfle deltatheta
!   with respect to varying inputs: cfal cf0 cf2 cf3 cfua cz0 cft2
!                chu pl
!unstable
SUBROUTINE DPLL_D(pl, pld, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d&
& , cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, cfutd, cfqt, &
& cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, deltatheta, deltathetad)
  IMPLICIT NONE
!input
  REAL, INTENT(IN) :: pl, cz0, chu, cfua, cf0, cf2, cf3, cft2, cfal
  REAL, INTENT(IN) :: pld, cz0d, chud, cfuad, cf0d, cf2d, cf3d, cft2d, &
& cfald
!output
  REAL, INTENT(OUT) :: cfut, cfqt, cftt, cfh0, cfle, deltatheta
  REAL, INTENT(OUT) :: cfutd, cfqtd, cfttd, cfh0d, cfled, deltathetad
!local
  REAL :: a, b, c, cc, d, tr, t0, g
  REAL :: ad, bd, cd, ccd, dd, trd, t0d, gd
  INTRINSIC SQRT
  INTRINSIC ALOG
  REAL :: result1
  REAL :: result1d
  REAL :: arg1
  REAL :: arg1d
!Eq. 2 in Karppinen et al. 1997: A=-psi_m(z/L)+psi_m(z_0/L)
!PL = 1/L, CZ0 roughness length, CHU = wind speed mesasurement height
  ad = .25*(1.0-16.0*chu*pl)**(-0.75)*16.0*(chud*pl+chu*pld) - .25*(1.0-&
&   16.0*cz0*pl)**(-0.75)*16.0*(cz0d*pl+cz0*pld)
  a = (1.0-16.0*cz0*pl)**.25 - (1.0-16.0*chu*pl)**.25
!psi_H = 2*alog([1+y²]/2)
!C = 1+y² where y=(1-16*z/L)^(1/4) from van Ulden and Holtslag 1985 Eqs 9 and 9a: z3=50 meters and PL = 1/L
  result1d = -(800.0*pld/(2.0*SQRT(1.0-800.0*pl)))
  result1 = SQRT(1.0 - 800.0*pl)
  cd = result1d
  c = 1.0 + result1
!B = -psi_H(z3/L)+psi_H(z2/L) where psi_H = 2*log([1+y²]/2) and y=(1-16*z/L)^(1/4), z3=50 meters, z2 = 2 meters
  arg1d = -(32.0*pld)
  arg1 = 1.0 - 32.0*pl
  IF (arg1 .EQ. 0.0) THEN
    result1d = 0.0
  ELSE
    result1d = arg1d/(2.0*SQRT(arg1))
  END IF
  result1 = SQRT(arg1)
  bd = 2.0*(result1d*c-(1.0+result1)*cd)/(c*(1.0+result1))
  b = 2.0*ALOG((1.0+result1)/c)
!CC = -2*log([1+y²]/2) = 2*log(2/[1+sqrt(1-16*50/L)])
  ccd = -(2.0*cd/c)
  cc = 2.0*ALOG(2.0/c)
!CFUT = friction velocity from Eq. 1 in Karppinen et al. 1997
!u* = U(z)*k/(ln(z/z_0)-psi_m(z/L)+psi_m(z_0/L)) where CF0=ln(z/z_0)
  cfutd = (.4*cfuad*(cf0+a)-.4*cfua*(cf0d+ad))/(cf0+a)**2
  cfut = .4*cfua/(cf0+a)
!D = u*²/(L*g*k*k) = theta*/k, Note: PL = 1/L
  dd = ((cfutd*cfut+cfut*cfutd)*pl+cfut**2*pld)/1.5696
  d = cfut*cfut*pl/1.5696
  trd = (cft2d*(1.0-d*(3.218875825+b))-(cft2-0.48)*(-(dd*(3.218875825+b)&
&   )-d*bd))/(1.0-d*(3.218875825+b))**2
  tr = (cft2-0.48)/(1.0-d*(3.218875825+b))
  t0d = trd - (trd*d+tr*dd)*(12.+cc) - tr*d*ccd
  t0 = tr - tr*d*(12.+cc) + 0.5
!Eq. 21 from van Ulden and Holtslag 1985
!T0**4 and TR**6 for easier reading. This produces the same result as in the F77 version of EVUOT to the 4th decimal
  cfqtd = cf2d - .567*(4*t0**3*t0d-.935*6*tr**5*trd/100000.0)/10000000.0
  cfqt = cf2 - .567*(t0**4-.935*tr**6/100000.0)/10000000.0
!ground flux estimated from the temperature difference between TR and T0
  gd = -(5.0*(trd-t0d))
  g = -(5.0*(tr-t0))
!solve theta* from van Ulden and Holtslag 1985 Eq. 6 -->
!theta* = T*u*²/(k*g*L), CFTT = k * u*²/(L*g*k*k) * T = T*u*²/(L*g*k) = theta* (temperature scale)
  cfttd = .4*(dd*tr+d*trd)
  cftt = .4*d*tr
!rho(T2) = rho_ref*T_ref/T2
!349477.0 = T_ref ~ 288 K and rho ref ~ 1.2 kg/m³ and c_p ~ 1011 kJ/(kg*K)
!CFH0 = rho(T) * c_p * theta* * u*, Eq. 5 in van Ulden and Holtslag 1985
  cfh0d = -((349477.0*(cfttd*cfut+cftt*cfutd)*cft2-349477.0*cftt*cfut*&
&   cft2d)/cft2**2)
  cfh0 = -(349477.0*cftt*cfut/cft2)
!lambdaE = Q_E = Q*-G-H_0, Eq. 10 in van Ulden and Holtslag 1985
  cfled = cfqtd - gd - cfh0d
  cfle = cfqt - g - cfh0
!DPLL = theta* - (aS/(S+1)-1)(Q*-G)/(rho*c_p*u*)-theta_d*a: the right hand term is Eq. 6 in Karppinen et al. 1997
!CF3 = (aS/(S+1)-1)/(rho(T)*c_p)
!deltaTheta is the difference between the temperature scale calculated from the energy budget equations and 
!using the "profile method". The iteration is done by changing 1/L.
  deltathetad = cfttd - ((cf3d*(cfqt-g)+cf3*(cfqtd-gd))*cfut-cf3*(cfqt-g&
&   )*cfutd)/cfut**2 - .033*cfald
  deltatheta = cftt - cf3*(cfqt-g)/cfut - .033*cfal
END SUBROUTINE DPLL_D
