!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.10 (r5717) - 30 Jul 2015 16:03
!
!  Differentiation of do_evuot in forward (tangent) mode:
!   variations   of useful results: results
!   with respect to varying inputs: cfab cfnh cfal cfas cfua cfhh
!                cz0 cft2 chu cla clo
!   RW status of diff variables: cfab:in results:out cfnh:in cfal:in
!                cfas:in cfua:in cfhh:in cz0:in cft2:in chu:in
!                cla:in clo:in
!the acutal subroutine that does the work ----------------------------->
SUBROUTINE DO_EVUOT_D(cfnr, cfst, cfvu, cfku, cfpv, cfkl, cfpr, cft2, &
& cft2d, cfuu, cfsu, cfnn, cftd, cftw, cfrr, cfvv, cfww, cfw1, cfw2, &
& cfnh, cfnhd, cfcl, cfhh, cfhhd, cfcm, cfch, cfdd, cfua, cfuad, cfap, &
& cfab, cfabd, cfas, cfasd, cfal, cfald, alb, cla, clad, clo, clod, cz0&
& , cz0d, chu, chud, results, resultsd)
  IMPLICIT NONE
!input data
  REAL, INTENT(IN) :: cfnr, cfst, cfvu, cfku, cfpv, cfkl, cfpr, cft2, &
& cfuu, cfsu, cfnn, cftd, cftw, cfrr, cfvv, cfww, cfw1, cfw2, cfnh, cfcl&
& , cfhh, cfcm, cfch, cfdd, cfua, cfap, cfab, cfas, cfal, cla, clo, cz0&
& , chu
  REAL, INTENT(IN) :: cft2d, cfnhd, cfhhd, cfuad, cfabd, cfasd, cfald, &
& clad, clod, cz0d, chud
  REAL, DIMENSION(10), INTENT(IN) :: alb
!output data
  REAL, DIMENSION(10), INTENT(OUT) :: results
  REAL, DIMENSION(10), INTENT(OUT) :: resultsd
!local variables
  REAL :: cfak, cfpl, cftt, cfut, cfh0, cfqt, cfle, cfh1, cfh2, cfwt, &
& cfgr, cf0, cf1, cf2, cf3, cf4, CLRAD, un
  REAL :: cfakd, cfpld, cfttd, cfutd, cfh0d, cfqtd, cfled, cf0d, cf2d, &
& cf3d, cf4d, CLRAD_D, und
  REAL :: sg, c1, pp, si, sn, cs, s, tr, t0, a, rv, d, pl, deltatheta, &
& deltatheta_dx, x, dx, e, tc, b0, gr, x1, x2
  REAL :: sd, trd, t0d, ad, rvd, dd, pld, deltathetad, deltatheta_dxd, &
& xd, tcd, b0d, grd, x1d, x2d
  INTEGER :: iv, ik, ip, il, i, n
  INTRINSIC INT
  INTRINSIC EXP
  INTRINSIC ALOG
  INTRINSIC ABS
  REAL :: result1
  REAL :: result1d
  REAL :: arg1
  REAL :: arg1d
  REAL :: arg10
  REAL :: arg10d
  REAL :: abs1
  REAL :: abs0
!match the surface albedo with the ground surface quality/state (CFSU 0-9) to the ten albedo values in the control file 
!UNCOMMENTED TO TEST SENSITIVITY OF ALBEDO AND NOT STATE OF THE GROUND
!CFAB=ALB(INT(CFSU)+1)
!Stefan Boltsman's constant 5.67e-8 W/(m^2 K)
  sg = .567/10000000.0
!Emprirical constant from van Ulden and Holtslag 1985 (Journal of Climate an Applied Meteorology) 9.35e-6 K⁻²
  c1 = .935/100000.0
  iv = INT(cfvu)
  ik = INT(cfku)
  ip = INT(cfpv)
  il = INT(cfkl)
!SALFA returns the sun elevation angle in degrees and calculates various help variables such as azimuth and zenith angles
!Input: IV=year (yy), IK=Month (mm), IP=Day (dd), IL=clock (HHMM), CLA=lat, CLO=lon, 
!Output("dummy arguments"): PP=solar midday difference in hours, SI=sin of the elevation angle, SI= sin of the azimut angle,
!CS=cos of the azimut angle
!CFAK=solar elevation in degrees
!CALL to get the value for CFAK
  CALL SALFA_D(iv, ik, ip, il, cla, clad, clo, clod, pp, si, sn, cs, &
&        cfak, cfakd)
!The subroutine returns the ground moisture parameters according to precipitation codes for the present 
!(CFWW), past 3 hours (CFW2) and past hour (CFW1). 
!If the CFW1 and CFW2 values are missing --> moisture parameter seems to become 1.
!CALL to get the value for CFAL
!COMMENTED TO TEST SENSITIVITY OF MOISTURE PARAMETER
!CALL ALFM(CFAK,CFSU,CFWW,CFW1,CFW2,CFRR,CFAL)
!SI=sinus of the solar elevation angle produced by the subroutine SALFA()
!CFAP = hourly amount of sunshine
!get the value for CFAS --> presenty prohibited by declaring CFAS as INTENT(IN)
!if you want to use CFAS declare CFAS as INTENT(INOUT) for the subroutine
!CALL GLOB(SI,CFAP,CFAS)
!The term CFAS*(1.0-CFAB) = K* (Net shortwave radiation) = (1-albedo)*R_S(K_R) (Eq. 10 in Karppinen et al. 1997)
!CF2 = K* + L_c
  result1d = CLRAD_D(cft2, cft2d, cfnh, cfnhd, cfhh, cfhhd, cfsu, &
&   result1)
  cf2d = cfasd*(1.0-cfab) - cfas*cfabd + result1d
  cf2 = cfas*(1.0-cfab) + result1
!S is the slope of the saturation entalphy curve (sat vap pres curve). CFT2 is the temperature at 2 metres.  
!Karppinen et al. 1997 (Int. J. Env and Poll.) between Eq. 5 and Table 1
!The equation is not exactly the same though: T2^2 here and T2 in Karppinen et al. 1997 
!Equation calculated as suggested by Dop et al. 1982:
  arg1d = 5423.0*cft2d/cft2**2
  arg1 = 5423.0*(1.0/273.16-1.0/cft2)
  sd = (51371.0*arg1d*EXP(arg1)*cft2**2-51371.0*EXP(arg1)*(cft2d*cft2+&
&   cft2*cft2d))/(cft2*cft2)**2
  s = 51371.0*EXP(arg1)/(cft2*cft2)
!Eq. 6 in Karppinen et al. 1997 (Int. J. Env and Poll.) but the density of air is scaled to the temperature CFT2
!349477.0 = c_p*rho_ref*288 K
!The density of air at the temperature T2 is rho(T2) = rho_ref*T_ref/T2 --> into Equation below 
!--> (aS/(S+1)-1)/c_p * (T2/T_ref*rho_ref) where T_ref ~ 288 K and rho_ref ~ 1.2 kg/m³ and c_p ~ 1011 kJ/(kg*K)
!Then CF3 = (aS/(S+1)-1)/(rho(T)*c_p)
  cf3d = (cft2d*(cfal*s/(s+1.0)-1.0)+cft2*((cfald*s+cfal*sd)*(s+1.0)-&
&   cfal*s*sd)/(s+1.0)**2)/349477.0
  cf3 = cft2*(cfal*s/(s+1.0)-1.0)/349477.0
!ln(z/z_0) 
!CHU = wind speed measurement height, CZ0 = roughness parameter
  cf0d = (chud*cz0-chu*cz0d)/(cz0*chu)
  cf0 = ALOG(chu/cz0)
!u* friction velocity (UN) calculated without stability functions, Eq. 1 Karppinen et al. 1997
!CFUA = wind speed at 10 metres
  und = (.4*cfuad*cf0-.4*cfua*cf0d)/cf0**2
  un = .4*cfua/cf0
!Subtract the temperature change from 2 meters to 50 meters --> 0.01K/m * (50m-2m) = 0.48K
  trd = cft2d
  tr = cft2 - .48
!This is the temperature at 0 meters using the lapse rate of 0.01K/m --> +0.02C for a drop in height by 2 meters
  t0d = cft2d
  t0 = cft2 + 0.02
!Eq. 21 in van Ulden and Holtslag 1985 (Journal of Climate an Applied Meteorology)
!A = L_out - L_in = SG*T_0⁴ - SG*c_1*T_r⁶ (positive is upwards)
!SG*T_0⁴ is the outgoing longwave radiation. SG*c_1*T_r⁶ is the incomming longwave radiation from the atmosphere.
!A=-L_net  + first aprrox for G (~2.5 Wm⁻²) !could at least be changed to a diurnal variation of some sort
!T0**4 and TR**6 for easier reading. This produces the same result as in the F77 version of EVUOT to the 4th decimal
  ad = sg*(4*t0**3*t0d-c1*6*tr**5*trd)
  a = sg*(t0**4-c1*tr**6) + 2.5
!CF4=-Lnet+G-thetad*alfa*UN*rho*cp/(alfa(s/(s+1))-1)
  cf4d = ad - (0.033*(cfald*un+cfal*und)*cf3-0.033*cfal*un*cf3d)/cf3**2
  cf4 = a - 0.033*cfal*un/cf3
!3.924 = 9.81*0.4 = g*k
!RV = g*k*CF3/(T_R*u*³) when CF3 = (aS/(S+1)-1)/(rho(T)*c_p) then RV = g*k*(aS/(S+1)-1)/(Tr*u*³*rho*c_p)
  rvd = (3.924*cf3d*tr*un**3-3.924*cf3*((trd*un+tr*und)*un**2+tr*un*(und&
&   *un+un*und)))/(tr*un*un*un)**2
  rv = 3.924*cf3/(tr*un*un*un)
!NOTE: more important : (CF2-CF4)*alfa(s/(s+1)-1) ~ -lambdaE0 +(Q*-G) ~ H0 -> stability can be estimated from the sign 
!CF2-CF4: CF2 = K*+L_c, CF4 = L_out - L_in + G - thetad*a*u**rho*c_p/(a*S/(S+1)-1)
!CF2-CF4 = K*+L_c - L_out + L_in - G + thetad*a*u**rho*c_p/(a*S/(S+1)-1)
!K* + L_c + L_in-L_out = Q*
!CF2-CF4 = Q* - G  + thetad*a*u**rho*c_p/(a*S/(S+1)-1) = -H_0/(a*S/(S+1)-1)
!alternatively a more clear form would be: (CF2 - CF4)*(a*S(S+1)-1) = (a*S(S+1)-1)*(Q*-G)+thetad*a*u**rho*c_p 
!---> = (a*S(S+1)-1)(Q*-G)-(Q*-G)+thetad*a*u**rho*c_p = (a*S(S+1)-1)(Q*-G)+thetad*a*u**rho*c_p-(Q*-G) = lambdaE-(Q*-G) = -H_0
!Note that aS/(S+1) < 1 and therefore aS/(S+1)-1 < 0. The sign does not change with aS/(S+1)-1
!stable
  IF (cf2 - cf4 .LT. 0) THEN
!D = 1/L --> CF2-CF4 = -H_0/(aS/(S+1)-1), RV = g*k*(aS/(S+1)-1)/(T*u*³*rho*c_p). When L=T*u*²/(k*g*theta*) and 
!theta* = -H_0/(rho*c_p*u*) --> 1/L = -k*g*H_0/(T*u*³*rho*c_p) = RV*(CF2-CF4)
!D = 1/L inverse M-O length
    dd = rvd*(cf2-cf4) + rv*(cf2d-cf4d)
    d = rv*(cf2-cf4)
    cfh0d = 0.0
    cfttd = 0.0
    cfqtd = 0.0
    cfutd = 0.0
    pld = 0.0
    cfled = 0.0
    DO i=1,10
!increase the inverse M-O length untill delta_theta* = T*u*²/(k*g*L) - (aS/(S+1)-1)(Q*-G)/(rho*c_p*u*)-theta_d*a
!changes sign i.e. becomes positive
      pld = i*dd
      pl = d*i
      CALL DPLS_D(pl, pld, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d&
&           , cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, &
&           cfutd, cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, &
&           deltatheta, deltathetad)
      IF (deltatheta .GT. 0) GOTO 100
    END DO
!increments and tolerance for the loop
 100 xd = pld
    x = pl
    dx = 0.00001
    e = 0.000001
!iterative loop
    DO n=1,20
!iterative loop --> change 1/L untill the temperature scale difference as returned in DPLS is less than E 
!with no more than 20 iterations. The variables CFUT, CFQT, CFTT, CFH0, and CFLE get their values here.
!check the subroutine to see which wariables are inputs and outputs
      CALL DPLS_D(x, xd, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d, &
&           cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, cfutd&
&           , cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, &
&           deltatheta, deltathetad)
      IF (deltatheta .GE. 0.) THEN
        abs0 = deltatheta
      ELSE
        abs0 = -deltatheta
      END IF
      IF (n .GT. 20 .OR. abs0 .LT. e) THEN
        GOTO 110
      ELSE
        CALL DPLS_D(x + dx, xd, cz0, cz0d, chu, chud, cfua, cfuad, cf0, &
&             cf0d, cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut&
&             , cfutd, cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, &
&             cfled, deltatheta_dx, deltatheta_dxd)
!change 1/L, here X, in the right direction X2 = X1-DX*deltaTheta/(deltaTheta_dx-deltaTheta). 
!If the difference deltaTheta increases, decrease X, otherwise increase X. 
!Note that both deltaTheta = DPLS(X) and deltaTheta_dx = DPLS(X+DX) decreases with each iteration.
        xd = xd - (dx*deltathetad*(deltatheta_dx-deltatheta)-dx*&
&         deltatheta*(deltatheta_dxd-deltathetad))/(deltatheta_dx-&
&         deltatheta)**2
        x = x - dx*deltatheta/(deltatheta_dx-deltatheta)
      END IF
    END DO
!Finaly set the value for the inverse M-O length...
 110 cfpld = xd
    cfpl = x
!Unstable
  ELSE IF (cf2 - cf4 .GT. 0) THEN
!temperature in celcius	
    tcd = cft2d
    tc = cft2 - 273.16
!Empirical regression equations (B0 and GR, reference?) to find where to start the iteration to find 1/L
!CFAL = moisture parameter, CF0 = ln(z/z_0), TC = temperature in Celsius
!Does B0 refere to boyant production of TKE?
    b0d = .0429*cfald - (.012685+.046081/(cfal-4.2765))*tcd + .046081*&
&     cfald*tc/(cfal-4.2765)**2 + (.00962*cfald-(.00093463+.0013998/(&
&     cfal-2.1069))*tcd+.0013998*cfald*tc/(cfal-2.1069)**2)*cf0 + (&
&     .19806+.00962*cfal-(.00093463+.0013998/(cfal-2.1069))*tc)*cf0d
    b0 = .0429*cfal - 2.1235 - (.012685+.046081/(cfal-4.2765))*tc + (&
&     .19806+.00962*cfal-(.00093463+.0013998/(cfal-2.1069))*tc)*cf0
!Does GR refere to flux into the ground?
    grd = .0002*tcd - .000237*tcd*cfal - (.001465+.000237*tc)*cfald + ((&
&     (.000065522+.000077531/(cfal-1.828))*tcd-.0007136*cfald-.000077531&
&     *cfald*tc/(cfal-1.828)**2)*cz0-(.0029854-.0007136*cfal+(.000065522&
&     +.000077531/(cfal-1.828))*tc)*cz0d)/cz0**2
    gr = .49957 + .0002*tc - (.001465+.000237*tc)*cfal + (.0029854-&
&     .0007136*cfal+(.000065522+.000077531/(cfal-1.828))*tc)/cz0
!X = 1/L --> CF2-CF4 = -H_0/(aS/(S+1)-1), RV = g*k*(aS/(S+1)-1)/(T*u*³*rho*c_p). When L=T*u*²/(k*g*theta*) and 
!theta* = -H_0/(rho*c_p*u*) --> 1/L = -k*g*H_0/(T*u*³*rho*c_p) = RV*(CF2-CF4)
!X = 1/L inverse M-O length
    xd = rvd*(cf2-cf4) + rv*(cf2d-cf4d)
    x = rv*(cf2-cf4)
!RV is always negative because of CF3 in RV since (aS/(S+1)-1) < 0 and therefore X1 is always negative ---> 
!needs to be so because it is in a logarithm in the following equation
    x1d = 1000.0*rvd
    x1 = 1000.0*rv
    x2d = (xd*x1-x*x1d)/x1**2
    x2 = x/x1
!empirical formula to find the best guess for 1/L based on moisture parameter (CFAL), temperature (TC), 
!roughness length (CZ0) and CF0
    arg10d = b0d + grd*ALOG(-x1) + gr*x1d/x1
    arg10 = b0 + gr*ALOG(-x1)
    xd = (xd*(1.0-x/(EXP(arg10)*x2*(.45042*x2+.81505)/(x2+.26547)))+x*(&
&     xd*EXP(arg10)*x2*(.45042*x2+.81505)/(x2+.26547)-x*((arg10d*EXP(&
&     arg10)*x2*(.45042*x2+.81505)+EXP(arg10)*(x2d*(.45042*x2+.81505)+x2&
&     *.45042*x2d))*(x2+.26547)-EXP(arg10)*x2*(.45042*x2+.81505)*x2d)/(&
&     x2+.26547)**2)*(x2+.26547)**2/(EXP(arg10)**2*x2**2*(.45042*x2+&
&     .81505)**2))/(1.0-x/(EXP(arg10)*x2*(.45042*x2+.81505)/(x2+.26547))&
&     )**2
    x = x/(1.0-x/(EXP(arg10)*x2*(.45042*x2+.81505)/(x2+.26547)))
!initiation of the loop
    dx = -0.00001
    e = 0.000001
    cfh0d = 0.0
    cfttd = 0.0
    cfqtd = 0.0
    cfutd = 0.0
    cfled = 0.0
!iterative loop
    DO n=1,20
!check the subroutine DPLL to see which variables are inputs and outputs
!DPLL returns the difference between theta* from the profile method and theta* from the energy balance equations.
      CALL DPLL_D(x, xd, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d, &
&           cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, cfutd&
&           , cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, &
&           deltatheta, deltathetad)
      IF (deltatheta .GE. 0.) THEN
        abs1 = deltatheta
      ELSE
        abs1 = -deltatheta
      END IF
      IF (n .GT. 20 .OR. abs1 .LT. e) THEN
        GOTO 120
      ELSE
!change 1/L, here X, until the temperature scale difference as returned in DPLL is less than E with no more than
!20 iterations. Note that DX is negative here.
        CALL DPLL_D(x + dx, xd, cz0, cz0d, chu, chud, cfua, cfuad, cf0, &
&             cf0d, cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut&
&             , cfutd, cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, &
&             cfled, deltatheta_dx, deltatheta_dxd)
        xd = xd - (dx*deltathetad*(deltatheta_dx-deltatheta)-dx*&
&         deltatheta*(deltatheta_dxd-deltathetad))/(deltatheta_dx-&
&         deltatheta)**2
        x = x - dx*deltatheta/(deltatheta_dx-deltatheta)
      END IF
    END DO
 120 cfpld = xd
    cfpl = x
!None of the above holds true
  ELSE
!Set the value for the inverse M-O length = 0
    cfpl = 0.0
!sensible heat flux H0 = 0	
    cfh0 = 0
!CF2 = K* + L_c and -A = L_net - G --> CFLE = K* + L_c + L_net - G  = Q* - G ----> 
!H0 + lambdaE = Q* - G ---> when H0=0 then lambdaE = Q* - G
    cfled = cf2d - ad
    cfle = cf2 - a
!Q* = lambdaE-G + 0.05*z_0
    cfqtd = cfled + 0.05*cz0d
    cfqt = cfle - 2.5 + 0.05*cz0
!+ other variables?! CFTT, CFUT
    cfh0d = 0.0
    cfpld = 0.0
    cfttd = 0.0
    cfutd = 0.0
  END IF
!return the variables
  resultsd(1:10) = (/cfabd, cfakd, cfasd, cfald, cfpld, cfttd, cfutd, &
&   cfh0d, cfqtd, cfled/)
  results(1:10) = (/cfab, cfak, cfas, cfal, cfpl, cftt, cfut, cfh0, cfqt&
&   , cfle/)
END SUBROUTINE DO_EVUOT_D
