!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.10 (r5717) - 30 Jul 2015 16:03
!
!  Differentiation of clrad in forward (tangent) mode:
!   variations   of useful results: clrad
!   with respect to varying inputs: h t c
!FUNCTION(S)
!CLRAD(CFT2,CFNH,CFHH,CFSU)
REAL FUNCTION CLRAD_D(t, td, c, cd, h, hd, su, clrad)
  IMPLICIT NONE
!input
  REAL, INTENT(IN) :: t, c, h, su
  REAL, INTENT(IN) :: td, cd, hd
!local
  REAL, PARAMETER :: sg=.0000000567, c1=.00000935
  REAL :: f
  REAL :: fd
  REAL :: clrad
!No clouds, no radiation from them
  IF (c .LE. 0.0) THEN
    clrad = 0.0
    clrad_d = 0.0
  ELSE
!Cloud base temperature T_c = T-0.01*H where T is the temperature at 2 meters and H is the cloud base height
!Eq. 14 in Karppinen et al. 1997 (Int. J. Env and Poll.)
!F here is L'_c in Eq. 14
    fd = sg*((cd*(1.0-c1*t*t)-c*c1*(td*t+t*td))*(t-.01*h)**4+c*(1.0-c1*t&
&     *t)*4*(t-.01*h)**3*(td-.01*hd))
    f = c*sg*(1.0-c1*t*t)*(t-.01*h)**4
    IF (su .LT. 5.0) THEN
!For no snowcover on the ground Eq. 15a in Karppinen et al. 1997 (Int. J. Env and Poll.)
      clrad_d = .64*fd
      clrad = .64*f
    ELSE
!For snow covered ground Eq. 15b in Karppinen et al. 1997 (Int. J. Env and Poll.)
      clrad_d = .56*fd
      clrad = .56*f
    END IF
  END IF
END FUNCTION CLRAD_D
