# -*- coding: utf-8 -*-
"""
Created on Thu Nov 19 15:44:10 2015

@author: backmanj
"""
#import pandas as pd
import numpy as np

#files to create
write_to_files = ['variable_range.txt','variable_range_ws.txt']

#shift register with max value
def shift(in_reg,max_value):
    in_reg[0] += 1
    full = False
    for i in range(0,len(in_reg)):
        if in_reg[i] > max_value[i]-1:
            if i+1<len(in_reg):
                in_reg[i]=0
                in_reg[i+1] += 1
            else: #break if the increment should be outside of the shift register
                full = True
    return in_reg,full
k=0
for write_file in write_to_files:
    #variables to be written
    var = {'z0':[],'albedo':[],'temperature':[],'cloudCover':[],'cloudHeight':[],'windSpeed':[] \
        ,'moistureParameter':[],'solarRadiation':[]}
    
    #roughness length
    z0 = np.linspace(0.3,1.3,6,dtype=float)
    var['z0'] = z0
    print 'z0', z0
    
    #surface albedo
    albedo = np.linspace(0.05,0.7,6,dtype=float)
    var['albedo'] = albedo
    print 'albedo', albedo
    
    #temperature at 2 metres
    temperature = np.linspace(-20,30,6,dtype=float)+273.15
    var['temperature'] = temperature
    print 'temperature', temperature
    
    #cloud cover fraction
    cloudCover = np.linspace(0,1,6,dtype=float)
    var['cloudCover'] = cloudCover
    print 'cloud cover', cloudCover
    
    #height of predominant clouds
    cloudHeight = np.linspace(30,6000,6,dtype=float)
    var['cloudHeight'] = cloudHeight
    print 'cloudHeight', cloudHeight
    
    #wind speed at 10 metres
    if k==0:
        windSpeed = np.linspace(1,20,6,dtype=float)
    elif k==1:
        windSpeed = np.logspace(0,np.log10(12),10,dtype=float)
    
    var['windSpeed'] = windSpeed
    print 'windSpeed', windSpeed
    
    #ground moisture parameter (alpha)
    moistureParameter = np.linspace(0.5,1,6,dtype=float)
    var['moistureParameter'] = moistureParameter
    print 'moisture parameter', moistureParameter
    
    #incomming solar radiation
    solarRadiation = np.linspace(0,900,6,dtype=float)
    var['solarRadiation'] = solarRadiation
    print 'solar radiation', solarRadiation
    
    var_name = np.sort(var.keys())
    cols = np.size(var_name)
    
    var_length = [np.size((var[key])) for key in var_name]
    
    rows = 0
    for ln in var_length:
        if rows == 0:
            rows = ln
        else:
            rows = rows*ln
    
    data_control = np.zeros((1,5),dtype=float)
    data_input = np.zeros((1,27),dtype=float)
    
    f = open(write_file,'w')
    form = ['%4.2f ','%4.2f ','%6.0f ','%3.1f ','%4.0f ','%5.1f ','%5.2f ','%4.2f']
    head_text = [text for text in var_name]
    head_join = ' '.join(head_text)
    header = head_join+(' '*(100-len(head_join)))
    f.write(header)
    f.write('\n')
    
    ind = [0 for i in var_name]
    full = False
    n=0
    while not full:
        save_vars = []        
        for i in range(0,len(var_name)):
            key = var_name[i]
            save_vars.append(var[key][ind[i]])
            #var_list[n,i] = var[key][ind[i]]
        ind,full = shift(ind,var_length)
        n += 1
        #save the data to a file
        for i in range(0,len(save_vars)):
            f.write(form[i]%save_vars[i])
            #print form[i]%save_vars[i]
        f.write('\n')
    f.close()
    k+=1
    
