	PROGRAM sermod
***	PROGRAM sermod	(PV-jul87,KV ,AK -oct 91)
*
*	Ohjelma yhdistaa 1-4 aseman tuulet(22-23 /ND:24-31,tape6) 
*       (asemien tuulet luetaan uniteilta 1-4)
*	ja interpoloi aikasarjan tunnin valein resedaksi.
*	Tulostiedosto(tape7) sisaltaa suureet 1-25 COMMON-
*	alueella cfpar.
*
*	Ohjausparametrit(tape5):
*	nas tuuliasemien lkm
*	zr0 sovellutuskohteen rosoisuus (m)
*	etd etf cdir cfff ddir zs zs0(8) nas-kertaa
*	etd aseman etaisyys(km) suunnan painotukseen
*	etf	    -		nopeuden     -
*	cdir suunnan skaalaus asteiksi
*	cfff nopeuden skaalaus => m/s
*	ddir suunnan epatarkkuusvali(ast)
*	zs   tuulen mittauskorkeus(m)
*	zs0  rosoisuudet(m) suuntaluokissa 1-8
*
	INTEGER*4 seed
	REAL*4 nd(50)
	REAL*4 re
	DIMENSION x(27,4),etd(4),etf(4),cdir(4),cfff(4),
     1		  ddir(4),det(4),fet(4),i1(13),i2(10)
	DIMENSION ns(10),m2(3,3),m3(3,3),zs(4),zs0(8,4)
	INTEGER days(12)
	CHARACTER*40 wdstname(4)

	DATA wdstname /'wind1.sermod',
     *   '/usr20/akarppin/orahaut/syn/.rsd',
     *   '/usr20/akarppin/orahaut/syn/.rsd',
     *   '/usr20/akarppin/orahaut/syn/.rsd'/
	
	DATA i1 /1, 7, 8, 9, 11, 12, 13, 15, 19, 21, 25, 26, 27/
	DATA i2 /2, 3, 4, 5, 16, 17, 18, 20, 22, 23/
	DATA ns/50,60,70,68,56,80,85,89,44,95/
	DATA m2 /1, 1, 1, 4, 0, 0, 4, 1, 1/
	DATA m3 /4, -1, 1, 4, -1, 0, 4, -1, 4/
        DATA days/31,28,31,30,31,30,31,31,30,31,30,31/
 
*        OPEN (5,FILE='control.sermod.sodan',STATUS='OLD',READONLY)
*        OPEN (6,FILE='/usr20/akarppin/orahaut/syn/sodan.rsd',
*     *        STATUS='OLD',READONLY)
*        OPEN (7,FILE='sodan.sermod.res',STATUS='NEW')      
	re = secnds(0.0)
	seed = 1000 * re - 1

	READ (UNIT=55, FMT=*, ERR=999, END=999) nas,zr0,(etd(i),etf(i),
     1     cdir(i),cfff(i),ddir(i),zs(i),(zs0(j,i),j=1,8),i=1,nas)

	IF (nas.gt.1) THEN
*	muut tuulitiedot tiedostoissa wind2.sermod,wind3.sermod ja wind4.sermod
*           do 20 i=2,nas
*               open(UNIT=i,FILE=wdstname(i),STATUS='OLD',READONLY)
*  20	   CONTINUE
	END IF

	nil=-999999
*	 maanpinnan laadun ja sademaaran alkuarvot
	x(10,1)=9.0
	x(14,1)=0.0

	DO 50 i=1,nas
	    det(i) = 100.0 / (etd(i) + 100.0)
	    fet(i) = 100.0 / (etf(i) + 100.0)
  50	CONTINUE
	ic=0
	iw=0
*
 100	READ (UNIT=66, FMT=*, ERR=300, END=300) (nd(i),i=1,6),t2m,
     1	nd(9),nd(11),tdew,twet,nd(15),pres,(nd(i),i=16,25),nd(10),
     1  rr
	ic=ic+1
*
*	merenpintapaine (hPa) ja lampotila (C) (yhdella desimaalilla)
        nd(7) =  pres
	nd(8) =  t2m

*	dew-point ja wet-bulb lampotilat (C) (yhdella desimaalilla)
	nd(12) = tdew
	nd(13) = twet

*	sademaara (mm) (yhdella desimaalilla) (minka ajan sademaara?)
	nd(14) = rr

	IF (MOD(nd(3),4.).eq.0) days(2)=29

	x(1, 4) = 3.0 * nd(1) - 1.0
	DO 101 i=2,23
	    x(i, 4) = nd(i)
 101	 CONTINUE

	IF (nd(14) .LT. 0) x(14, 4) = 0.0

	x(7, 4) =  nd(7)

	DO 102 i=11,13
	    j = i
	    IF (i .LT. 12) j = 8
	    x(j, 4) =  nd(j) + 273.16
 102	CONTINUE
 
	DO 103 i=11,19,8
	    IF (nd(i) .GT. 8) nd(i) = 8
	    x(i, 4) = nd(i) / 8.0
 103	    CONTINUE
*
*	alapilvien korkeus ollut ennen 10 metreissa !
*	korjattu 7.11. 1991 AK
	i = nd(21)
*	puuttuva tieto ja pilveton tilanne  !
*
*	i=0 tarkoittaa ,ettei pilvia ole
	IF (i.eq.0) i=3000
*	i=9990 tarkoittaa ettei pilvia voida havaita
	IF (I.EQ.9990) i=60
*
	IF (i .GT. 6000) GO TO 104
*	IF (i .LT. 10) GO TO 105

	x(21, 4) =  i
	GO TO 106

*	suurin korkeus 6 km (vs. WMO 2.5 km ?!)
 104	x(21, 4) = 6000.0
	GO TO 106

*	jos i<10 palautetaan 60 metriin (miksi ?)
 105	x(21, 4) = 60.0

 106	cf = 0.0
	cx = 0.0
	cy = 0.0
	cc = 0.0
	cb = 0.0

 	DO 108 i=1,nas
	    IF(i.GT.1) READ (UNIT=i, FMT=*) (nd(2*i+22),n=1,22),nd(2*i+23)

*	 tuulen suunta
	    j = nd(2 * i + 22)
	    IF (nas .EQ. 1.AND.j .EQ. 0) GO TO 109
*	 tuulen nopeus
	    k = nd(2 * i + 23)
	    IF (j .EQ. nil.OR.k .EQ. nil) GO TO 108

*	    cdir =1  ja ddir =10 (normaali-resedalla)
*
	    d = cdir(i) * j + ddir(i) * (ran(seed) - 0.5)

	    IF (d .LT. 22.5.OR.d .GE. 337.5) THEN
	        id = 1
	       ELSE
		id = int((d+22.5)/45.0) + 1
	    END IF

*	     rosoisuus tuulensuuntasektorissa id
	    z0 = zs0(id, i)
*	     zs(i) on aseman i tuulen mittauskorkeus
*
	    f = cfff(i) * k * alog(60.0/z0) * alog(10.0/zr0) / 
	1       (alog(zs(i) / z0) * alog(60.0/zr0))

	    CALL dfuv(d,f,u,v)

	    IF (nas .GT. 1) GO TO 107
	    IF (f .LT. 1.0) GO TO 110

	    GO TO 112

 107	    cf = cf + f * fet(i)
	    cx = cx + u * det(i)
	    cy = cy + v * det(i)
	    cc = cc + fet(i)
	    cb = cb + det(i)
 108	CONTINUE

 	IF (cc .LE. 0.0001) GO TO 109

	f = cf / cc

	IF (f .LE. 0.01) GO TO 109

	IF (f .LT. 1.0) f = 1.0

	u = cx / cb
	v = cy / cb

	CALL uvdf(u,v,d,a)

	GO TO 111


 109	d = 180.0 + 360.0 * (ran(seed) - 0.5)
        
 110	f = 1.0

 111	CALL dfuv(d,f,u,v)

 112	x(24, 4) = armear(d)
	x(25, 4) = f
*	 tuulen u- ja v- komponentit
	x(26, 4) = u
	x(27, 4) = v

*	puuttuvat tiedot korvataan edellisen havainnon arvoilla
*	pinnan laatu & sademaara + vahan muitakin parametreja


	do 113 ii=7,23
	   IF (nd(ii) .EQ. nil) x(ii, 4) = x(ii, 1)
  113   continue
	IF (ic .GT. 1) GO TO 200
*
*	ensimmainen tietue
*
	DO 114 i=2,25
	    x(i, 3) = x(i, 4)
 114	CONTINUE

	x(1, 3) = 1.0
	x(6, 3) = -100.0

	DO 115 i=3,4
	    WRITE (UNIT=7, FMT=555, ERR=300) 
     *      iw,(INT(x(j,i)),j=2,6),(x(j,i),j=7,9),INT(x(10,i)),
     *      (x(j,i),j=11,14),(INT(x(j,i)),j=15,18),x(19,i),
     *      (INT(x(j,1)),j=20,23),(x(j,i),j=24,25) 
	iw=iw+1
 115	CONTINUE
 
	DO 120 i=1,27
	    x(i, 1) = x(i, 4)
 120	CONTINUE

*
	GO TO 100


 200	DO 202 i=1,13
	    k = i1(i)
	    a = x(k, 1)
	    r = (x(k, 4) - a) / 3.0

	    DO 201 j=2,3
		x(k, j) = r * (j - 1) + a
 201	    CONTINUE

 202	CONTINUE

	DO 203 i=1,10
	    j = i2(i)
	    x(j, 2) = x(j, 1)
	    x(j, 3) = x(j, 4)
 203	CONTINUE

	n1 = int(x(16,1))
	n4 = int( x(16, 4))
	j1 = 1
	IF (n1 .GT. 49) j1 = 3
	IF (n1 .GT. 19.AND.n1 .LT. 30) j1 = 2
	j4 = 1
	IF (n4 .GT. 49) j4 = 3
	IF (n4 .GT. 19.AND.n4 .LT. 30) j4 = 2
	j = m2(j4, j1)
	IF (j .EQ. 0) GO TO 150

	x(16, 2) = x(16, j)

	GO TO 151

 150	x(16, 2) = 0.0

 151	j = m3(j4, j1)

	IF (j-0) 152,153,154

 152	x(16, 3) = ns(n4 - 19)
	GO TO 155

 153	x(16, 3) = 0.0
	GO TO 155

 154	x(16, 3) = x(16, j)

 155	x(6, 2) = x(6, 1) + 100.0
	x(6, 3) = x(6, 4) - 100.0

	IF (x(6,3).LT.0) THEN
           x(6,3)=2300
	   x(5,3)=x(5,3)-1
	   IF ( x(5,3).LE.0 ) THEN
	      x(4,3) = x(4,3) -1
              IF (x(4,3).GT.0) THEN
                 x(5,3) = days ( INT(x(4,3)) )
                ELSE
                 x(3,3) = x(3,3)-1
                 x(4,3) = 12.
                 x(5,3) = 31.
              END IF
           END IF
        END IF	

	DO 204 i=10,14,4
	    x(i, 2) = x(i, 1)
	    x(i, 3) = x(i, 1)
 204	CONTINUE

	DO 205 j=2,3
	    CALL uvdf(x(26,j),x(27,j),d,a)
	    x(24, j) = armear(d)
 205	CONTINUE

	DO 206 i=2,4
	WRITE (UNIT=7, FMT=555, ERR=300) 
     *      iw,(INT(x(j,i)),j=2,6),(x(j,i),j=7,9),INT(x(10,i)),
     *      (x(j,i),j=11,14),(INT(x(j,i)),j=15,18),x(19,i),
     *      (INT(x(j,i)),j=20,23),(x(j,i),j=24,25) 
        iw=iw+1
 206	CONTINUE

	DO 207 i=1,27
	    x(i, 1) = x(i, 4)
 207	CONTINUE

	GO TO 100

 300	x(1, 1) = x(1,1) + 1.0
	x(6, 1) = x(6, 1) + 100.0
	WRITE (UNIT=7, FMT=555, ERR=999) 
     *      iw,(INT(x(j,1)),j=2,6),(x(j,1),j=7,9),INT(x(10,1)),
     *      (x(j,1),j=11,14),(INT(x(j,1)),j=15,18),x(19,1),
     *      (INT(x(j,1)),j=20,23),(x(j,1),j=24,25) 
        iw=iw+1

 555	FORMAT(3I5,2I3,I5,F7.1,F6.1,F6.1,I3,F5.2,3F6.1,I6,
     *         3I3,F5.2,I3,I6,2I3,F8.1,F6.2)
 999	CONTINUE
	END

	subroutine dfuv(ddd,ff,u,v)
***	subroutine dfuv		 (sk-18.11.80)
*	===============
*
*	tehtava-
*	   laskee tuulen komponentit u ja v
*	parametrit-
*	   ddd	 in  tuulen suunta asteina (met.suunta)
*	    ff	 in  tuulen nopeus
*	     u	out  u-komponentti
*	     v	out  v-komponentti
*
	u = -ff * sind(ddd)
	v = -ff * cosd(ddd)
	RETURN
	END
*
	subroutine uvdf(u,v,ddd,ff)
***	subroutine uvdf		(sk-18.11.80)
*	===============
*	
*	tehtava-
*	   laskee tuulen suunnan (met.suunta)
*	   tuulen komponenteista u ja v.
*
*	parametrit-
*	   u    in  u-komponentti
*	   v	in  v-komponentti
*	 ddd  out   suunta asteina (met. suunta)
*	  ff  out   nopeus
*
*	jos u**2 + v**2 =0,asetetaan ddd=ff=0
*	  		   
	    r = u * u + v * v
	    IF (r .LE. 0.0) GO TO 100
	    ff = sqrt(r)
	    ddd = 57.2957795 * atan2(u,v) + 180.0
	    GO TO 999
  100	    ddd = 0.0
	    ff = 0.0
  999	    RETURN
	    END
*
      FUNCTION ARMEAR(D)
***   FUNCTION ARMEAR   (PV-APR87)
*
*     FUNKTIO LASKEE ARITMEETTISEN VIRTAUSSUUNNAN METEORO-
*     LOGISESTA TUULEN SUUNNASTA (D(ASTEINA)),TAI P#INVASTOIN
*
      IF (D .LT. 270.0) GOTO 100
      ARMEAR=630.0-D
      GOTO 999
  100 ARMEAR=270.0-D
  999 RETURN
      END
