#compute model weights using posterior from the model output as a prior
source("load_obs.R")
source("load_models.R")
source("BMAutils.R")

statesFull=c('FW', 'NENW', 'NC', 'Hun', 'CWO', 'MM', 'CC', 'Msyd', 'Ill', 'SET', 'ACT', 'Victoria')


season="DJF" 
period="hindcast"  #"hindcast" for 1990-2009 or "forecast" for
           #  2060-2079


library(MCMCpack)
NDRAW=5000
BURN=500
KEEP=1
nSAMPLES=NDRAW

#now compute the weights
lik=function(y, mu, sigma) {
  sum=0
  for (i in c(1:length(y))) {
    sum=sum+log(dnorm(y[i], mu[i], sigma+0.5))
  }
  return(exp(sum))
}


#par(mfrow=c(4,3))
weightMat=weightMat1=weightMat2=matrix(NA, nrow=12, ncol=12)
ww1Mat=ww2Mat=wwMat=matrix(NA, ncol=20, nrow=12)


for (nState in c(1:12)) {
  
  region=statesFull[nState]
  obs=load.obs(season, region)
  model=load.reg.models(season, period, region)
  obs$years=obs$years-obs$years[1]

  model$years=model$years-model$years[1]
  nObs=length(obs$years)
  
  obsout=MCMCregress(obs$obs~obs$years, thin=KEEP, mcmc=NDRAW)
  obsbeta0=obsout[,1]
  obsbeta1=obsout[,2]
  obssigma=obsout[,3]
  
  
  beta0Mat=beta1Mat=sigmaMat=matrix(NA, nrow=12, ncol=nSAMPLES)
  for (i in c(1:12)) {
 #first figure out how to correct the variance
    out=MCMCregress(model$allmodels[i,]~model$years, thin=KEEP, mcmc=NDRAW)
                  # b0=mean(obsbeta0), b1=0,
                  #B0=c(1.5/var(obsbeta0), 0.00001))
    beta0Mat[i,]=out[,1]
    beta1Mat[i,]=out[,2]
    sigmaMat[i,]=out[,3]
  }
 


weight=weight1=weight2=rep(0, 12)
names(weight)=names(weight1)=names(weight2)=c(1:12)

obsbeta0mean=mean(obsbeta0)
obsbeta1mean=mean(obsbeta1)
obssigmamean=mean(obssigma)

for (nModels in c(1:12)) {
   for (j in c(1:nSAMPLES)) {
    #weight based on beta0, beta1 and internal var
    mu=beta0Mat[nModels,j]+beta1Mat[nModels,j]*obs$years
   weight[nModels]=weight[nModels]+lik(obs$obs, mu, sqrt(sigmaMat[nModels, j]))
   
   #weight based on beta0 and internal var
   mu=beta0Mat[nModels,j]+obsbeta1mean*obs$years
   weight1[nModels]=weight1[nModels]+lik(obs$obs, mu, sqrt(sigmaMat[nModels, j])) 

   #weight based on beta1 and internal var
   mu=obsbeta0mean+beta1Mat[nModels,j]*obs$years
   weight2[nModels]=weight2[nModels]+lik(obs$obs, mu, sqrt(sigmaMat[nModels, j])) 
   
   
  }
}

weight=weight/sum(weight)
weight2=weight2/sum(weight2)
weight1=weight1/sum(weight1)


weightMat[nState, ]=weight
weightMat1[nState, ]=weight1
weightMat2[nState, ]=weight2


COLORS=c("purple", "orange", "black" ,"brown2", "springgreen4", "coral3", "darkgoldenrod1",
         "skyblue1", "turquoise3", "deeppink3", "yellow2","pink" )

yy=matrix(NA, ncol=nObs, nrow=12)


par(mfrow=c(3,3))
barplot(weight, col=COLORS, main="weight", xlab="models")
barplot(weight1, col=COLORS, main="weight intercept")
barplot(weight2, col=COLORS, main="weight slope")



plot(obs$years, obs$obs, ylab="obs", xlab="years", ylim=c(min(obs$obs)-3,max(obs$obs)+3), main="model 1,2, 3")
yyo=mean(obsbeta0)+mean(obsbeta1)*obs$years
lines(obs$years, yyo, col=2, lty=2, lwd=4)
for (i in c(1:3)){
  yy[i,]=mean(beta0Mat[i,])+mean(beta1Mat[i,])*obs$years
  lines(obs$years, yy[i,], col=COLORS[i])
  lines(obs$years, model$allmodels[i,], col=COLORS[i], lty=2)
}
plot(obs$years, obs$obs, ylab="obs", xlab="years", ylim=c(min(obs$obs)-3,max(obs$obs)+3), main="model 4,5,6")
lines(obs$years, yyo, col=2, lty=2, lwd=4)
for (i in c(4:6)){
  yy[i,]=mean(beta0Mat[i,])+mean(beta1Mat[i,])*obs$years
  lines(obs$years, yy[i,], col=COLORS[i])
  lines(obs$years, model$allmodels[i,], col=COLORS[i], lty=2)
}
plot(obs$years, obs$obs, ylab="obs", xlab="years", ylim=c(min(obs$obs)-3,max(obs$obs)+3), main="model 7, 8, 9")
lines(obs$years, yyo, col=2, lty=2, lwd=4)
for (i in c(7:9)){
  yy[i,]=mean(beta0Mat[i,])+mean(beta1Mat[i,])*obs$years
  lines(obs$years, yy[i,], col=COLORS[i])
  lines(obs$years, model$allmodels[i,], col=COLORS[i], lty=2)
}
plot(obs$years, obs$obs, ylab="obs", xlab="years", ylim=c(min(obs$obs)-3,max(obs$obs)+3), main="model 10, 11, 12")
lines(obs$years, yyo, col=2, lty=2, lwd=4)
for (i in c(10:12)){
  yy[i,]=mean(beta0Mat[i,])+mean(beta1Mat[i,])*obs$years
  lines(obs$years, yy[i,], col=COLORS[i])
  lines(obs$years, model$allmodels[i,], col=COLORS[i], lty=2)
}

plot(obs$years, obs$obs, ylab="obs", xlab="years", ylim=c(min(obs$obs)-3,max(obs$obs)+3), main="weighted fit")
lines(obs$years, yyo, col=2, lty=2, lwd=4)
wwy=wwy2=rep(0, nObs)
meanBeta0=meanBeta1=0
for (i in c(1:12)) {
  # meanBeta0=meanBeta0+mean(weight2[i]*beta0Mat[i,])
  #meanBeta1=meanBeta1+mean(weight1[i]*beta1Mat[i,])
  wwy=wwy+weight[i]*yy[i,] 
}
lines(obs$years, wwy, lwd=4, col=1)



plot(obs$years, obs$obs, ylab="obs", xlab="years", ylim=c(min(obs$obs)-3,max(obs$obs)+3), main="weighted fit (I/S)")
lines(obs$years, yyo, col=2, lty=2, lwd=4)
wwy1=wwy2=rep(0, nObs)
meanBeta0=meanBeta1=0
for (i in c(1:12)) {
  # meanBeta0=meanBeta0+mean(weight2[i]*beta0Mat[i,])
  #meanBeta1=meanBeta1+mean(weight1[i]*beta1Mat[i,])
  wwy1=wwy1+weight1[i]*yy[i,] 
  wwy2=wwy2+weight2[i]*yy[i,] 
}
lines(obs$years, wwy1, lwd=4, col=3)
lines(obs$years, wwy2, lwd=4, col=4)

wwMat[nState,]=wwy
ww1Mat[nState,]=wwy1
ww2Mat[nState,]=wwy2
#dev.off()

} #end nstates


#file1=paste("Yanan-results/", season, "/", "weight1.txt", sep="")#
#write(t(weightMat1), file=file1,  ncol=12)
#file2=paste("Yanan-results/", season, "/", "weight2.txt", sep="")
#write(t(weightMat2), file=file2, ncol=12)
#file3=paste("Yanan-results/", season, "/",  "weight.txt", sep="")
#write(t(weightMat), file=file3, ncol=12)





file1=paste("weight1est.txt", sep="")
write(t(ww1Mat), file=file1,  ncol=nObs)
file2=paste("weight2est.txt", sep="")
write(t(ww2Mat), file=file2, ncol=nObs)
file3=paste("weightest.txt", sep="")
write(t(wwMat), file=file3, ncol=nObs)



#compute the model output estimate for each model
season="MAM" 
period="hindcast"  #"hindcast" for 1990-2009 or "forecast" for
#  2060-2079


library(MCMCpack)
NDRAW=5000
BURN=500
KEEP=1
nSAMPLES=NDRAW

for (nState in c(1:12)) {
  
  region=statesFull[nState]
  obs=load.obs(season, region)
  model=load.reg.models(season, period, region)
  obs$years=obs$years-obs$years[1]
  
  model$years=model$years-model$years[1]
  nObs=length(obs$years)
  
  obsout=MCMCregress(obs$obs~obs$years, thin=KEEP, mcmc=NDRAW)
  obsbeta0=obsout[,1]
  obsbeta1=obsout[,2]
  obssigma=obsout[,3]
  
  
  beta0Mat=beta1Mat=sigmaMat=matrix(NA, nrow=12, ncol=nSAMPLES)
  for (i in c(1:12)) {
    #first figure out how to correct the variance
    out=MCMCregress(model$allmodels[i,]~model$years, thin=KEEP, mcmc=NDRAW)
    # b0=mean(obsbeta0), b1=0,
    #B0=c(1.5/var(obsbeta0), 0.00001))
    beta0Mat[i,]=out[,1]
    beta1Mat[i,]=out[,2]
    sigmaMat[i,]=out[,3]
  }
  
  yy=matrix(NA, ncol=nObs, nrow=12)
  for (i in c(1:12)){
    yy[i,]=mean(beta0Mat[i,])+mean(beta1Mat[i,])*model$years
  }

  
  ff=paste("modelfit.txt", sep="")
  cat(ff, "\n")
  write(t(yy), file=ff, ncol=nObs)
}
