#compute model weights using posterior from the model output as a prior
#cross validation using one of the model output as obs


period="hindcast"  #"hindcast" for 1990-2009 or "forecast" for
#  2060-2079


library(MCMCpack)
NDRAW=5000
BURN=500
KEEP=1
nSAMPLES=NDRAW

#now compute the weights
lik=function(y, mu, sigma) {
  sum=0
  for (i in c(1:length(y))) {
    sum=sum+log(dnorm(y[i], mu[i], sigma))
  }
  return(exp(sum))
}




weightMat=weightMat1=weightMat2=matrix(NA, nrow=12, ncol=numModels)


for (nState in c(1:12)) {
  
  region=statesFull[nState]
  model=load.reg.models(season, period, region)
  obs=load.obs(season, region)
  obs$years=obs$years-obs$years[1]
  obs$obs=model$allmodels[Ind,]
  
  model$allmodels=model$allmodels[-Ind,]
  model$years=model$years-model$years[1]
  nObs=length(obs$years)
  
  obsout=MCMCregress(obs$obs~obs$years, thin=KEEP, mcmc=NDRAW)
  obsbeta0=obsout[,1]
  obsbeta1=obsout[,2]
  obssigma=obsout[,3]
  
  
  beta0Mat=beta1Mat=sigmaMat=matrix(NA, nrow=numModels, ncol=nSAMPLES)
  fithind=matrix(NA, ncol=nObs, nrow=numModels)
  for (i in c(1:numModels)) {
    #first figure out how to correct the variance
    out=MCMCregress(model$allmodels[i,]~model$years, thin=KEEP, mcmc=NDRAW)
    # b0=mean(obsbeta0), b1=0,
    #B0=c(1.5/var(obsbeta0), 0.00001))
    beta0Mat[i,]=out[,1]
    beta1Mat[i,]=out[,2]
    sigmaMat[i,]=out[,3]
    fithind[i, ] = mean(out[,1])+mean(out[,2])*model$years    
  }
  
  
  vecNo=c(1:12)
  weight=weight1=weight2=rep(0, numModels)
  names(weight)=names(weight1)=names(weight2)=vecNo[-Ind]
  
  obsbeta0mean=mean(obsbeta0)
  obsbeta1mean=mean(obsbeta1)
  obssigmamean=mean(obssigma)
  
  for (nModels in c(1:numModels)) {
    for (j in c(1:nSAMPLES)) {
      #weight based on beta0, beta1 and internal var
      mu=beta0Mat[nModels,j]+beta1Mat[nModels,j]*obs$years
      weight[nModels]=weight[nModels]+lik(obs$obs, mu, sqrt(sigmaMat[nModels, j]))
      
      #weight based on beta0 and internal var
      mu=beta0Mat[nModels,j]+obsbeta1mean*obs$years
      weight1[nModels]=weight1[nModels]+lik(obs$obs, mu, sqrt(sigmaMat[nModels, j])) 
     #weight1[nModels]=weight1[nModels]+lik(obs$obs, mu, sqrt(obssigmamean))
     
      #weight based on beta1 and internal var
      mu=obsbeta0mean+beta1Mat[nModels,j]*obs$years
      weight2[nModels]=weight2[nModels]+lik(obs$obs, mu, sqrt(sigmaMat[nModels, j])) 
       #weight2[nModels]=weight2[nModels]+lik(obs$obs, mu, sqrt(obssigmamean)) 
    }
  }
  
  weight=weight/sum(weight)
  weight2=weight2/sum(weight2)
  weight1=weight1/sum(weight1)
  
  
  weightMat[nState, ]=weight
  weightMat1[nState, ]=weight1
  weightMat2[nState, ]=weight2
  

wwy=wwy1=wwy2=rep(0, nObs)
yy=matrix(NA, ncol=nObs, nrow=numModels)
for (i in c(1:numModels)) {
  yy[i,]=mean(beta0Mat[i,])+mean(beta1Mat[i,])*obs$years
  wwy=wwy+weight[i]*yy[i,]
  wwy1=wwy1+weight1[i]*yy[i,]
  wwy2=wwy2+weight2[i]*yy[i,]
}

  PLOT=F
  if (PLOT==T) {
  COLORS=c("purple", "orange", "black" ,"brown2", "springgreen4", "coral3", "darkgoldenrod1",
           "skyblue1", "turquoise3", "deeppink3", "yellow2","pink" )
  
  COLORS=COLORS[-Ind]
  yy=matrix(NA, ncol=nObs, nrow=numModels)
  
 
  par(mfrow=c(2,3))
  barplot(weight, col=COLORS, main="weight", xlab="models")
  barplot(weight1, col=COLORS, main="weight intercept")
  barplot(weight2, col=COLORS, main="weight slope")
  
 
 yyo=mean(obsbeta0)+mean(obsbeta1)*obs$years
 for (i in c(1:numModels)){
   yy[i,]=mean(beta0Mat[i,])+mean(beta1Mat[i,])*obs$years
   }
  plot(obs$years, obs$obs, ylab="obs", xlab="years", ylim=c(min(obs$obs)-3,max(obs$obs)+3), main="weighted fit")
  lines(obs$years, yyo, col=2, lty=2, lwd=4)
  wwy=wwy2=rep(0, nObs)
  meanBeta0=meanBeta1=0
  for (i in c(1:numModels)) {
       wwy=wwy+weight[i]*yy[i,] 
  }
  lines(obs$years, wwy, lwd=4, col=1)
  
  plot(obs$years, obs$obs, ylab="obs", xlab="years", ylim=c(min(obs$obs)-3,max(obs$obs)+3), main="weighted fit (I/S)")
  lines(obs$years, yyo, col=2, lty=2, lwd=4)
  wwy1=wwy2=rep(0, nObs)
  meanBeta0=meanBeta1=0
  for (i in c(1:numModels)) {
    # meanBeta0=meanBeta0+mean(weight2[i]*beta0Mat[i,])
    #meanBeta1=meanBeta1+mean(weight1[i]*beta1Mat[i,])
    wwy1=wwy1+weight1[i]*yy[i,] 
    wwy2=wwy2+weight2[i]*yy[i,] 
  }
  lines(obs$years, wwy1, lwd=4, col=3)
  lines(obs$years, wwy2, lwd=4, col=4)
  
   
}#PLOT
  
} #end nstates


WRITE=F
if (WRITE==T) {
file1=paste("weight1CV.txt", sep="")
write(t(weightMat1), file=file1,  ncol=numModels)
file2=paste("weight2CV.txt", sep="")
write(t(weightMat2), file=file2, ncol=numModels)
file3=paste("weightCV.txt", sep="")
write(t(weightMat), file=file3, ncol=numModels)

}






