
#plot pdf of the differences using 3 (or 4) different sets of weights
#posterior predictive from the mixture

source("load_obs.R")
source("load_models.R")
source("BMAutils.R")

source("weightsBMA-norm.R")
#load("Yanan-results/proj.RData")

statesFull=c('FW', 'NENW', 'NC', 'Hun', 'CWO', 'MM', 'CC', 'Msyd', 'Ill', 'SET', 'ACT', 'Victoria')


season="DJF" 
period="forecast"  #"hindcast" for 1990-2009 or "forecast" for
#  2060-2079

file1=paste("weight1.txt", sep="")
weightMat1=read.table(file1)
file2=paste("weight2.txt", sep="")
weightMat2=read.table(file2)
file3=paste("weight.txt", sep="")
weightMat=read.table(file3)

file1=paste( "hindens1.txt", sep="")
hindens1=read.table(file1)
hindObs1=apply(hindens1, 1, mean)
file2=paste("hindens2.txt", sep="")
hindens2=read.table(file2)
hindObs2=apply(hindens2, 1, mean)
file3=paste( "hindens3.txt", sep="")
hindens3=read.table(file3)
hindObs3=apply(hindens3, 1, mean)

file1=paste("weight1est.txt", sep="")
wwEst1=read.table(file1)
file2=paste( "weight2est.txt", sep="")
wwEst2=read.table(file2)
file3=paste( "weightest.txt", sep="")
wwEst=read.table(file3)

library(MCMCpack)
NDRAW=5000
BURN=500
KEEP=1
nSAMPLES=NDRAW



nBoots=10000
numModels=12


par(mfrow=c(3,4))
for (nState in c(1:12)) {
  
  region=statesFull[nState]
  obs=load.obs(season, region)
  model=load.reg.models(season, period, region)
  obs$years=obs$years-obs$years[1]
  
  model$years=model$years-model$years[1]
  nObs=length(obs$years)
 
 
obsfit1=hindObs1[nState]
obsfit2=hindObs2[nState]
obsfit3=hindObs3[nState]

  beta0Mat=beta1Mat=sigmaMat=matrix(NA, nrow=12, ncol=nSAMPLES)
  fit=matrix(NA, ncol=nObs, nrow=12)
  for (i in c(1:12)) {
    #first figure out how to correct the variance
    out=MCMCregress(model$allmodels[i,]~model$years, thin=KEEP, mcmc=NDRAW)
    # b0=mean(obsbeta0), b1=0,
    #B0=c(1.5/var(obsbeta0), 0.00001))
    beta0Mat[i,]=out[,1]
    beta1Mat[i,]=out[,2]
    sigmaMat[i,]=out[,3]
    fit[i, ]=mean(beta0Mat[i,])+mean(beta1Mat[i,])*(obs$years)  
  }
  
ff=paste("modelfit.txt", sep="")
fitObs=read.table(ff, header=F)

  
  #bootstrap the residuals according to weights
  weight=as.numeric(weightMat[nState,])
  weight1=as.numeric(weightMat1[nState,])
  weight2=as.numeric(weightMat2[nState,])
  
  Samp=Samp1=Samp2=matrix(NA, ncol=1, nrow=nBoots)
  #sample with respect to the weights
  for (i in c(1:nBoots)) {
    index=sample(c(1:length(weight)), size=1, prob=weight)
    rand=sample(c(1:5000), size=1)
    Samp[i]=mean(rnorm(nObs, beta0Mat[index, rand]+beta1Mat[index, rand]*obs$years, sqrt(sigmaMat[index, rand]))-as.numeric(fitObs[index,]))
 
    index=sample(c(1:length(weight)), size=1, prob=weight1)
    rand=sample(c(1:5000), size=1)
    Samp1[i]=mean(rnorm(nObs, beta0Mat[index, rand]+beta1Mat[index, rand]*obs$years, sqrt(sigmaMat[index, rand]))-as.numeric(fitObs[index,]))
    
    index=sample(c(1:length(weight)), size=1, prob=weight2)
    rand=sample(c(1:5000), size=1)
    Samp2[i]=mean(rnorm(nObs, beta0Mat[index, rand]+beta1Mat[index, rand]*obs$years, sqrt(sigmaMat[index, rand]))-as.numeric(fitObs[index,]))
    
  }
  


MIN=min(c(Samp, Samp1, Samp2))
MAX=max(c(Samp, Samp1, Samp2))
#cat(MIN, MAX, "\n")
dens=density(Samp)
dens1=density(Samp1)  
dens2=density(Samp2)
MAXY=max(c(dens$y, dens1$y, dens2$y))+0.5
plot(0, type="n", ylim=c(0, MAXY), xlim=c(MIN-0.5, MAX+0.5), main=region, ylab="pdf", xlab="")
lines(density(Samp), col=1, lwd=3)
abline(v=quantile(Samp, prob=0.025), col=1, lty=2)
abline(v=quantile(Samp, prob=0.975), col=1, lty=2)
cat(quantile(Samp, prob=0.025), quantile(Samp, prob=0.975), "\n")
lines(density(Samp1), col=3)
lines(density(Samp2), col=4)
points(apply(fit, 1, mean)-apply(fitObs, 1, mean), rep(MAXY-0.3, 12), col=2)
points(mean(apply(fit, 1, mean)-apply(fitObs, 1, mean)), (MAXY-0.3), col=1, pch="x", cex=1.5)
lines(density(proj$proj[,nState]), lty=1, col=2)
cat(quantile(proj$proj[,nState], prob=0.025), quantile(proj$proj[,nState], prob=0.975), "\n")
abline(v=quantile(proj$proj[,nState], prob=0.025), col=2, lty=2)
abline(v=quantile(proj$proj[,nState], prob=0.975), col=2, lty=2)

   
}#nState
   
   