# ======================================================================
# PURPOSE
# =========
# To read in all regions

# STATUS
# ========
# Working

# INPUT
# =======
# None

# CALLS
# =======
# No externals

# OUTPUT
# ========
# regions => A vector of BMA regions. Vector of characters. 

# HISTORY
# ========
# Oct 16 2015 => Written by Roman Olson, CCRC, UNSW.
# ======================================================================

get.regions <- function() {

   inputdir  <- paste(Sys.getenv("BMADIR"), "input/tasmean/", sep="")
   regfile   <- paste(inputdir, "states.txt", sep="")
   regions   <- as.vector(as.matrix(read.table(regfile, sep=",",
                         colClasses="character", nrows=1, strip.white=TRUE)))
   regions
}
