                            %% CONSTANTS
                   
% Henry's law constant in pure water at 25Celsius. K=p/c form.
kHpc = 29.4118;      %(for CO2)                                 % L.atm/mol
%kHpc = 714.2857;    %(for CH4)                                  % L.atm/mol
%kHpc = 40;          %(for N2O)                                  % L.atm/mol

% Relative molecular mass of air
Ma = 28.97;

% Relative molecular mass
Mb = 44.01;           %(for CO2)
%Mb = 16.043;           %(for CH4)
%Mb = 44.013;           %(for N2O)

% Relative molecular mass of H20
Ms=18.01;

% Mass fraction (MF) of solutes in standard sea water as a proportion of
% total salinity.
MassFraction= ...
{'Compound' 'MF'  'v1'     'v2'      'v3'     'v4'       'v5'      'v6'   ;
  'NaCl'    0.798  16.22    1.3229    1.4849   0.0074691  30.78    2.0583 ;
  'KCl'     0.022   6.4883  1.3175   -0.7785   0.09272    -1.3     2.0811 ;
  'CaCl2'   0.033  32.028   0.787792 -1.1495   0.0026995  780860   5.8442 ;
  'MgCl2'   0.047  24.032   2.2694    3.7108   0.021853   -1.1236  0.14474;
  'MgSO4'   0.100  72.269   2.2238    6.6037   0.0079004  3340.1   6.1304};

% Association factor of H20
phiw = 2.6;

% Universal ideal gas law constant
R = 8.314472;

% Rhow0 (pure water) parameters (in Johnson 2010)
r = [999.842594 0.06793952 -0.00909529 0.0001001685 -0.000001120083 0.000000006536332];

% Rhow (marine water) parameters (in Johnson 2010)
a = [0.824493 -0.0040899 0.000076438 -0.00000082467 0.0000000053875];
b = [-0.00572466 0.00010277 -0.0000016546];
c  = 0.00048314;

% Rho air parameters (in Johnson 2010)
Sd = [1.293393662 -5.538444326*10^-3 3.860201577*10^-5 -5.2536065*10^-7];

% Eta air parameters (in Johnson 2010)
Sv = [1.715747771*10^-5 4.722402075*10^-8 -3.663027156*10^-10 ...
      1.873236686*10^-12 -8.050218737*10^-14];

%'a' and 'b' constants for temperature and salinity dependence of Bunsen
% solubility coeficient taken from Sarimiento (2013)
as = [-160.7373   215.4152  89.892    -1.477592]; %for CO2
bs = [ 0.029941  -0.027455  0.0053407          ]; %for CO2
%as = [-68.8862    101.4956  28.7314   0        ]; %for CH4
%bs = [-0.076146   0.04397  -0.0068672          ]; %for CH4
%as = [-165.8806   222.8743  92.0792   -1.48425 ]; %for N2O
%bs = [-0.056235   0.031619 -0.0048472          ]; %for N2O


% Temperature dependence of the solution: -delta_soln*H/R (in Johnson 2010)
tds = 2400;         %(for CO2)
%tds = 1700;         %(for CH4)
%tds = 2600;         %(for N2O)

% Liquid molar volume of air                                       cm^3/mol
Va = 20.1;   

% Liquid molar volume at its boiling point using the additive Schroeder method:
% increments of C=7,O=7, N=7, H=7, double bound=7 and triple bound=14 (see Johnson 2010)
% for CO2: molecular structure of CO2 is O=C=O
Vb = 1*7+2*7+2*7;                                                 %cm^3/mol
% for CH4: molecular structure of CH4 is 1C to 4H with 4 single bounds
%Vb = 1*7+4*7;
% for N2O: molecular structure of N2O is N=N=O
%Vb = 1*7+2*7+2*7;                                                 %cm^3/mol

%Real gas molar volume
Vm = 22.3;  %for CO2 and CH4                                         %L/mol
%Vm = 22.2432;  %for N2O                                              %L/mol

        %% FLUX NUMERICAL OPTIONS ( required for later k estimations)

% Henry constant correction for temperature and salinity
% 'Sar13': Sarmiento (2013) adapted from Weiss(1974), Weiss and Price(1980)
% 'Joh10': Johnson (2010)
NSkH = 'Joh10';
        
% Water transfer velocity (kwind)
NSkwind = 'Zea03';

% Chemical enhancement of water transfer velocity (alfa)
% 'Bea04': Borges et al (2004)
% 'Cea96': Carini et al (1996)
% 'Joh10': Johnson (2010)
% 'R&C01': Raymond Cole (2001)
NSalfa = 'Joh10';

% Water difusivity scheme (Dw)
% 'H&L74': Hayduk & Laudie (1974)
% 'H&M82': Hayduk & Minhas (1982)
% 'W&C55': Wilkie & Chang  (1955)
NSdw = 'W&C55';

              %% Eddy-Covariance Estimated Gas Fluxes
              
%load Eddy-Covariance data
dir ='C:\Users\Vasco Vieira\Dropbox\interface gas flux\Dados\Erik Sahlee\';
file='ogarn_level_1_stat_linreg_201405';
load([dir file]);
C=stat.C;           C=mean([C(1:end-4) C(2:end-3) C(3:end-2) C(4:end-1) C(5:end)],2);
C(1:3216)=[];       C(502:end)=[];
CD=stat.CD;         CD=mean([CD(1:end-4) CD(2:end-3) CD(3:end-2) CD(4:end-1) CD(5:end)],2);
CD(1:3216)=[];      CD(502:end)=[];
QD=stat.QD;         QD =mean([QD(1:end-4) QD(2:end-3) QD(3:end-2) QD(4:end-1) QD(5:end)],2);
QD(1:3216)=[];      QD(502:end)=[];
T=stat.T;           T=mean([T(1:end-4) T(2:end-3) T(3:end-2) T(4:end-1) T(5:end)],2);
T(1:3216)=[];       T(502:end)=[];
WD=stat.WD;         WD=mean([WD(1:end-4) WD(2:end-3) WD(3:end-2) WD(4:end-1) WD(5:end)],2);
WD(1:3216)=[];      WD(502:end)=[];
WS=stat.WS;         WS=mean([WS(1:end-4) WS(2:end-3) WS(3:end-2) WS(4:end-1) WS(5:end)],2);
WS(1:3216)=[];      WS(502:end)=[];
wcd=stat.wcd;       wcd=mean([wcd(1:end-4) wcd(2:end-3) wcd(3:end-2) wcd(4:end-1) wcd(5:end)],2);
wcd(1:3216)=[];     wcd(502:end)=[];
wqd=stat.wqd;       wqd=mean([wqd(1:end-4) wqd(2:end-3) wqd(3:end-2) wqd(4:end-1) wqd(5:end)],2);
wqd(1:3216)=[];     wqd(502:end)=[];
wt=stat.wt;         wt=mean([wt(1:end-4) wt(2:end-3) wt(3:end-2) wt(4:end-1) wt(5:end)],2);
wt(1:3216)=[];      wt(502:end)=[];
date= stat.date;
date(1:3216,:)=[];  date(502:end,:)=[];

%load measured environmental variables
dir='C:\Users\Vasco Vieira\Dropbox\interface gas flux\Dados\ms2\';
file='Field_validation';
load([dir file]);
P   = pa/1000;

%filter time instances
i=find(date(:,5)~=0 & date(:,5)~=30);
date(i,:)=[];
dnum=datenum(date); dnum=dnum-min(dnum); 
C(i)=[]; CD(i)=[]; QD(i)=[]; T(i)=[]; WD(i)=[]; WS(i)=[]; wcd(i)=[]; wqd(i)=[]; wt(i)=[];

mu = Ma/Ms;

ra_c = CD./1000;
ra_v = QD./1000;
ra_a = P*101325.01./(R*(T+273.15));
F1   = wcd./1000;
F2   = mu.*ra_c./ra_a.*wqd./1000;
F3   = (1+mu*ra_v./ra_a).*ra_c./(T+273.15).*wt;
Fgas = F1+F2+F3;

                      %% DATA (for k estimates)

% air-water gas flux                                         mmol*(m^2*s^1)
F  = Fgas;
    
% Gas concentration in the air in                                  mmol/m^3
Ca = nan(size(F));%Ca_mmol./1000;

% Gas concentration in the air in                                       ppm
Cappm = Ca_ppm;

% Air temperature at height 0                                          (C)
Ta0 = ta;

% Air temperature at height h                                          (C)
Tah = T12m;

% Air pressure at height 0                                            (atm)
P0  = pa/1000;

% Air pressure at height h                                            (atm)
Ph  = pa/1000;

% relative humidity at height h                                    (scalar)
hrh = rh;

% Wind velocity h meters above the surface                              m/s
U = ws12m;

% heigth of wind measurement                                            (m)
zu = 12*ones(size(Ca));

% Gas concentration in the water                                   mmol/m^3
Cw = nan(size(Ca));

% Gas concentration in the water in                                     ppm
Cwppm = Cw_ppm;

% Salinity                                                              ppt
S = S_MyO;

% Water skin temperature                                                 C
Tw = Twaverider;

% Water current velocity                                              (m/s)
w = 0.001*ones(size(Ca));

% Water depth                                                           (m)
zw = 100*ones(size(Ca));

                             %% k CALCULUS

%observed transfer velocity
Tka    = 273.15+Ta0;
Pascal = P0*101325.01;
Tkw    = 273.15+Tw;
kH     = estimatekH(P,S,Tkw,as,bs,kHpc,R,tds,Vb,Vm,NSkH);
%k      = -F./(Ca./kH-Cw);                                              %m/s
k      = -F.*10.^6.*R.*Tka.*kH./((Cappm-Cwppm).*Pascal);               %m/s

%wind direction bounds for Eddy-Covariance footprint
wdbounds = [100 160];
i        = find(wd>wdbounds(1) & wd<wdbounds(2));
ibounds  = i;

                %% plot for E-C script 'get_EC_gasflux.m'
                
subplot (2,3,1)
plot(dnum,F1,'k.'); hold on
plot(dnum(i),F1(i),'ko'); hold on
plot(dnum,F2,'b.'); hold on
plot(dnum(i),F2(i),'bo'); hold on
plot(dnum,F3,'r.'); hold on
plot(dnum(i),F3(i),'ro'); 
ylabel('WPL')
legend('wcd all','footprint','wq','footprint','wt','footprint')

subplot (2,3,2)
plot(dnum,Fgas,'k.'); hold on
plot(dnum(i),Fgas(i),'r.')
ylabel('F(CO_2)')

subplot(2,3,3)
plot(dnum,QD,'k.'); hold on
plot(dnum(i),QD(i),'r.')
ylabel('q (mmol/m^3)')

subplot(2,3,4)
plot(dnum,WS,'k.'); hold on
plot(dnum(i),WS(i),'r.')
xlabel('date num')
ylabel('wind speed')

subplot(2,3,5)
plot(dnum,WD,'k.'); hold on
plot(dnum(i),WD(i),'r.')
xlabel('date num')
ylabel('wind direction')

subplot(2,3,6)
dppm=Cappm-Cwppm;
plot(dnum,dppm,'k.'); hold on
plot(dnum(i),dppm(i),'r.')
xlabel('date num')
ylabel('\Deltappm')

                 %% figure with transfer velocities
                 
Alfa  = estimatealfa(S,Tw,Tkw,NSalfa,NSdw,NSkwind,a,b,c,r,MassFraction,Ms,phiw,Vb);
k600  = k*100*60*60./Alfa;

d1 = find(dnum>1.28 & dnum<1.7);
d2 = find(dnum>2.8 & dnum<3.3);
                 
figure(2)
subplot(2,2,1)
plot(U,k*100*60*60,'k.'); hold on
plot(U(i),k(i)*100*60*60,'ro'); hold on
plot(U(d1),k(d1)*100*60*60,'g^'); hold on
plot(U(d2),k(d2)*100*60*60,'cv'); hold on
xlabel('U_z')
ylabel('k (cm/h)')
legend('all observed','E-C footprint')

subplot(2,2,2)
plot(U,k600,'k.'); hold on
plot(U(i),k600(i),'ro'); hold on
plot(U(d1),k600(d1),'g^'); hold on
plot(U(d2),k600(d2),'cv'); hold on
xlabel('U_z')
ylabel('k_6_0_0 (cm/h)')

subplot(2,2,3)
plot(dnum,k*100*60*60,'k.'); hold on
plot(dnum(i),k(i)*100*60*60,'ro'); hold on
plot(dnum(d1),k(d1)*100*60*60,'g^'); hold on
plot(dnum(d2),k(d2)*100*60*60,'cv'); hold on
xlabel('date num')
ylabel('k (cm/h)')

subplot(2,2,4)
plot(dnum,k600,'k.'); hold on
plot(dnum(i),k600(i),'ro'); hold on
plot(dnum(d1),k600(d1),'g^'); hold on
plot(dnum(d2),k600(d2),'cv'); hold on
xlabel('date num')
ylabel('k_6_0_0 (cm/h)')

clear Alfa a b c file fp g i j Hs Karman kHpc Lp mu p QD q qh;
clear ('-regexp','^C|^d|^F\d|^h|^M|^N|^R|^r|^S|^P|^p|^T|^t|^V|^W|^w|^z') 
